/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.notice.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSON;
import com.google.common.collect.Lists;
import com.tydic.bcm.personal.constants.DycBusiCodeEnum;
import com.tydic.bcm.saas.personal.notice.BcmSaasAbilityTodoToGuwpService;
import com.tydic.bcm.saas.personal.notice.BcmSaasSendTodoService;
import com.tydic.bcm.saas.personal.notice.bo.BcmSaasAbilityTodoToGuwpRspBO;
import com.tydic.bcm.saas.personal.notice.bo.BcmSaasProductTodoBO;
import com.tydic.bcm.saas.personal.notice.bo.BcmSaasTodoProductReqBO;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmUpdateProcessStatusToGuwpReqBO;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmUpdateTaskStatusToGuwpReqBO;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_SAAS_GROUP_DEV/3.0.0/com.tydic.bcm.saas.personal.notice.BcmSaasAbilityTodoToGuwpService"})
public class BcmSaasAbilityTodoToGuwpServiceImpl
implements BcmSaasAbilityTodoToGuwpService {
    private static final Logger log = LoggerFactory.getLogger(BcmSaasAbilityTodoToGuwpServiceImpl.class);
    @Resource
    private BcmSaasSendTodoService bcmSaasSendTodoService;
    @Value(value="${PUSH_GUWP_BPM_URL}")
    private String pushGuwpBpmUrl;
    @Value(value="${PUSH_GUWP_TODO_UPDATE_STATUS_URL}")
    private String pushGuwpTodoUpdateStatusUrl;

    @Override
    @PostMapping(value={"receiveTodo"})
    public BcmSaasAbilityTodoToGuwpRspBO receiveTodo(@RequestBody BcmSaasTodoProductReqBO reqBO) {
        log.info("\u63a5\u6536\u5230\u63a8\u9001\u8fc7\u6765\u7684\u4ee3\u529e {}", (Object)JSON.toJSONString((Object)reqBO));
        if (CollectionUtil.isEmpty(reqBO.getBusiList())) {
            return new BcmSaasAbilityTodoToGuwpRspBO();
        }
        for (BcmSaasTodoProductReqBO.BusiTodo busiTodo : reqBO.getBusiList()) {
            if (DycBusiCodeEnum.SYNC_TODO.getCode().equals(busiTodo.getDycBusiCode())) {
                this.bcmSaasSendTodoService.pushTodo(busiTodo.getData());
                continue;
            }
            if (!DycBusiCodeEnum.SYNC_DONE.getCode().equals(busiTodo.getDycBusiCode()) && !DycBusiCodeEnum.TODO_REVOKE.getCode().equals(busiTodo.getDycBusiCode())) continue;
            BcmSaasProductTodoBO data = busiTodo.getData();
            BcmUpdateTaskStatusToGuwpReqBO bcmUpdateTaskStatusToGuwpReqBO = new BcmUpdateTaskStatusToGuwpReqBO();
            bcmUpdateTaskStatusToGuwpReqBO.setAppProcessId(data.getProcInstId());
            bcmUpdateTaskStatusToGuwpReqBO.setAppTakId(data.getTodoId() + "");
            if (DycBusiCodeEnum.SYNC_DONE.getCode().equals(busiTodo.getDycBusiCode())) {
                bcmUpdateTaskStatusToGuwpReqBO.setUpdateType(1);
            } else {
                bcmUpdateTaskStatusToGuwpReqBO.setUpdateType(3);
            }
            bcmUpdateTaskStatusToGuwpReqBO.setUserCodeList(Lists.newArrayList((Object[])new String[]{data.getCandidateOperExtId()}));
            log.info("\u4ee3\u529e\u66f4\u65b0\u72b6\u6001\u5165\u53c2 {}", (Object)JSON.toJSONString((Object)bcmUpdateTaskStatusToGuwpReqBO));
            String post = HttpUtil.post((String)this.pushGuwpTodoUpdateStatusUrl, (String)JSON.toJSONString((Object)bcmUpdateTaskStatusToGuwpReqBO));
            log.info("\u4ee3\u529e\u66f4\u65b0\u72b6\u6001\u56de\u53c2 {}", (Object)post);
            BcmUpdateProcessStatusToGuwpReqBO bcmUpdateProcessStatusToGuwpReqBO = new BcmUpdateProcessStatusToGuwpReqBO();
            bcmUpdateProcessStatusToGuwpReqBO.setProcessStatus(DycBusiCodeEnum.getByCode((String)busiTodo.getDycBusiCode()).getProcessStatus());
            bcmUpdateProcessStatusToGuwpReqBO.setAppProcessId(data.getProcInstId());
            String result = HttpUtil.post((String)this.pushGuwpBpmUrl, (String)JSON.toJSONString((Object)bcmUpdateProcessStatusToGuwpReqBO));
            log.info("\u4ee3\u529e\u66f4\u65b0\u6d41\u7a0b\u72b6\u6001 \u5165\u53c2 {} \u56de\u53c2\u6570  {} ", (Object)JSON.toJSONString((Object)bcmUpdateProcessStatusToGuwpReqBO), (Object)result);
        }
        return new BcmSaasAbilityTodoToGuwpRspBO();
    }
}

