/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.commodity.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.saas.personal.commodity.api.BcmSaasCirculateApplyOrderService;
import com.tydic.bcm.saas.personal.commodity.bo.BcmSaasCirculateApplyOrderReqBO;
import com.tydic.bcm.saas.personal.commodity.bo.BcmSaasCirculateApplyOrderRspBO;
import com.tydic.bcm.saas.personal.utils.BcmSaasRuUtil;
import com.tydic.bcm.saas.personal.utils.SaasParamValidateUtils;
import com.tydic.dyc.base.bo.BaseRspBo;
import com.tydic.osworkflow.approve.ability.EacQueryOperationRecordsListAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacOperLogAbilityReqBO;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_SAAS_GROUP_DEV/3.0.0/com.tydic.bcm.saas.personal.commodity.api.BcmSaasCirculateApplyOrderService"})
public class BcmSaasCirculateApplyOrderServiceImpl
implements BcmSaasCirculateApplyOrderService {
    private static final Logger log = LoggerFactory.getLogger(BcmSaasCirculateApplyOrderServiceImpl.class);
    @Autowired
    private EacQueryOperationRecordsListAbilityService eacQueryOperationRecordsListAbilityService;
    @Value(value="${notice.circulate.taskCode}")
    private String noticeCirculateTaskCode;
    @Value(value="${notice.url}")
    private String noticeUrl;
    @Value(value="${bcm.dyc.front.url}")
    private String frontUrl;

    @Override
    @PostMapping(value={"circulateApplyOrder"})
    public BcmSaasCirculateApplyOrderRspBO circulateApplyOrder(@RequestBody BcmSaasCirculateApplyOrderReqBO reqBO) {
        SaasParamValidateUtils.validate(reqBO);
        JSONObject data = new JSONObject();
        data.put("detailUrl", (Object)(this.frontUrl + reqBO.getJumpUrl()));
        data.put("senderName", (Object)reqBO.getName());
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("taskCode", this.noticeCirculateTaskCode);
        params.put("data", data.toString());
        params.put("sendId", reqBO.getUserId());
        params.put("sendName", reqBO.getName());
        params.put("receivers", reqBO.getReceivers());
        log.info("\u7ad9\u5185\u4fe1\u53d1\u9001\u53c2\u6570 {}", (Object)JSON.toJSONString(params));
        String result = HttpUtil.post((String)this.noticeUrl, (String)JSON.toJSONString(params));
        log.info("\u7ad9\u5185\u4fe1\u53d1\u9001\u7ed3\u679c {}", (Object)result);
        BaseRspBo baseRspBo = (BaseRspBo)JSON.parseObject((String)result, BaseRspBo.class);
        if (!"0000".equals(baseRspBo.getRespCode())) {
            throw new ZTBusinessException(baseRspBo.getRespDesc());
        }
        EacOperLogAbilityReqBO eacOperLogAbilityReqBO = new EacOperLogAbilityReqBO();
        eacOperLogAbilityReqBO.setTaskId(reqBO.getTaskId());
        eacOperLogAbilityReqBO.setUserId(reqBO.getUserId() + "");
        eacOperLogAbilityReqBO.setUserName(reqBO.getName());
        eacOperLogAbilityReqBO.setOrgId(reqBO.getOrgId() + "");
        eacOperLogAbilityReqBO.setOrgName(reqBO.getOrgName());
        eacOperLogAbilityReqBO.setAction("circulate");
        eacOperLogAbilityReqBO.setResult("\u4f20\u9605");
        this.eacQueryOperationRecordsListAbilityService.addOperationRecord(eacOperLogAbilityReqBO);
        return BcmSaasRuUtil.success(BcmSaasCirculateApplyOrderRspBO.class);
    }
}

