/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.product.ext.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.bcm.saas.personal.constant.BcmSaasPersonalProductConstant;
import com.tydic.bcm.saas.personal.product.ext.api.BcmUocReciverITEvaInfoService;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmOutUocReciverITEvaInfoServiceReqBO;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmSaleOrderEvaBaseInfoBO;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmSaleOrderEvaObjInfoBO;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmSaleOrderEvaStarLevelBO;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmUocReciverITEvaInfoReqBO;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmUocReciverITEvaInfoRspBO;
import com.tydic.bcm.saas.personal.utils.BcmSaasHttpUtil;
import com.tydic.bcm.saas.personal.utils.BcmSaasRuUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_SAAS_GROUP_DEV/3.0.0/com.tydic.bcm.saas.personal.product.ext.api.BcmUocReciverITEvaInfoService"})
public class BcmUocReciverITEvaInfoServiceImpl
implements BcmUocReciverITEvaInfoService {
    private static final Logger log = LoggerFactory.getLogger(BcmUocReciverITEvaInfoServiceImpl.class);
    @Value(value="${RECIVER_IT_EVA_URL}")
    private String url;
    @Value(value="#{'${EVA_ITEM_CODE}'.split(',')}")
    private List<String> itemCodeList;
    @Value(value="#{'${EVA_ITEM_NAME}'.split(',')}")
    private List<String> itemNameList;
    @Value(value="${EVA_MOD_ID:}")
    private String modId;

    @Override
    @PostMapping(value={"reciverITEva"})
    public BcmUocReciverITEvaInfoRspBO reciverITEva(@RequestBody BcmUocReciverITEvaInfoReqBO reqBO) {
        this.push(reqBO);
        return BcmSaasRuUtil.success(BcmUocReciverITEvaInfoRspBO.class);
    }

    private void push(BcmUocReciverITEvaInfoReqBO reqBO) {
        BcmOutUocReciverITEvaInfoServiceReqBO bcmOutUocReciverITEvaInfoServiceReqBO = new BcmOutUocReciverITEvaInfoServiceReqBO();
        bcmOutUocReciverITEvaInfoServiceReqBO.setSaleOrderNo(reqBO.getOrderNo());
        bcmOutUocReciverITEvaInfoServiceReqBO.setUserId(reqBO.getEvaluateUserId());
        bcmOutUocReciverITEvaInfoServiceReqBO.setName(reqBO.getEvaluateUserName());
        ArrayList<BcmSaleOrderEvaStarLevelBO> starLevelList = new ArrayList<BcmSaleOrderEvaStarLevelBO>(this.itemCodeList.size());
        ArrayList<BcmSaleOrderEvaObjInfoBO> objInfoList = new ArrayList<BcmSaleOrderEvaObjInfoBO>(1);
        for (int i = 0; i < this.itemCodeList.size(); ++i) {
            BcmSaleOrderEvaStarLevelBO starLevelBO = new BcmSaleOrderEvaStarLevelBO();
            starLevelBO.setItemCode(this.itemCodeList.get(i));
            starLevelBO.setItemName(this.itemNameList.get(i));
            starLevelBO.setLevelValue(reqBO.getEvaluateStar());
            starLevelList.add(starLevelBO);
        }
        BcmSaleOrderEvaObjInfoBO evaObjectInfoBO = new BcmSaleOrderEvaObjInfoBO();
        evaObjectInfoBO.setStarLevelList(starLevelList);
        evaObjectInfoBO.setObjType(BcmSaasPersonalProductConstant.EvaAct.EVA);
        objInfoList.add(evaObjectInfoBO);
        bcmOutUocReciverITEvaInfoServiceReqBO.setObjInfoList(objInfoList);
        BcmSaleOrderEvaBaseInfoBO evaBaseInfoBO = new BcmSaleOrderEvaBaseInfoBO();
        evaBaseInfoBO.setModId(this.modId);
        evaBaseInfoBO.setMemId(reqBO.getEvaluateUserId());
        evaBaseInfoBO.setMemName(reqBO.getEvaluateUserName());
        evaBaseInfoBO.setEvaAct(BcmSaasPersonalProductConstant.EvaAct.EVA);
        evaBaseInfoBO.setSysCode("STMS");
        try {
            evaBaseInfoBO.setEvaTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(reqBO.getEvaluateTime()));
        }
        catch (ParseException e) {
            log.error(e.getMessage());
        }
        bcmOutUocReciverITEvaInfoServiceReqBO.setEvaBaseInfo(evaBaseInfoBO);
        BcmSaasHttpUtil.doPost(this.url, JSONObject.toJSONString((Object)bcmOutUocReciverITEvaInfoServiceReqBO));
    }
}

