/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.task.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.client.utils.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmQueryApplyCommodityOrderListService;
import com.tydic.bcm.personal.commodity.bo.BcmApplyCommodityOrderBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyCommodityOrderListReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyCommodityOrderListRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.constants.BcmPersonalFlowConstant;
import com.tydic.bcm.personal.flow.api.BcmQueryFlowInstanceService;
import com.tydic.bcm.personal.flow.bo.BcmQueryFlowInstanceReqBO;
import com.tydic.bcm.personal.flow.bo.BcmQueryFlowInstanceRspBO;
import com.tydic.bcm.saas.personal.notice.BcmSaasSendNoticeService;
import com.tydic.bcm.saas.personal.notice.BcmSaasSendTodoService;
import com.tydic.bcm.saas.personal.notice.bo.BcmSaasAddTodoBO;
import com.tydic.bcm.saas.personal.notice.bo.BcmSaasProductTodoBO;
import com.tydic.bcm.saas.personal.task.api.BcmSaasSendMessageCutoffApplyOrderTaskService;
import com.tydic.bcm.saas.personal.task.bo.BcmSaasSendMessageCutoffApplyOrderTaskReqBO;
import com.tydic.bcm.saas.personal.task.bo.BcmSaasSendMessageCutoffApplyOrderTaskRspBO;
import com.tydic.bcm.saas.personal.utils.BcmSaasRuUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_SAAS_GROUP_DEV/3.0.0/com.tydic.bcm.saas.personal.task.api.BcmSaasSendMessageCutoffApplyOrderTaskService"})
public class BcmSaasSendMessageCutoffApplyOrderTaskServiceImpl
implements BcmSaasSendMessageCutoffApplyOrderTaskService {
    private static final Logger log = LoggerFactory.getLogger(BcmSaasSendMessageCutoffApplyOrderTaskServiceImpl.class);
    @Autowired
    private BcmQueryApplyCommodityOrderListService bcmQueryApplyCommodityOrderListService;
    private final BcmSaasSendNoticeService bcmSaasSendNoticeService;
    @Value(value="${bcm.dyc.front.url}")
    private String frontUrl;
    @Autowired
    private BcmSaasSendTodoService bcmSaasSendTodoService;
    @Autowired
    private BcmQueryFlowInstanceService bcmQueryFlowInstanceService;
    @Value(value="${APPLY_ORDER_TODO_CODE:APPLY_COMMODITY_ORDER}")
    private String applyOrderTodoCode;

    @Override
    @PostMapping(value={"sendMessageCutoffApplyOrder"})
    public BcmSaasSendMessageCutoffApplyOrderTaskRspBO sendMessageCutoffApplyOrder(@RequestBody BcmSaasSendMessageCutoffApplyOrderTaskReqBO reqBO) {
        BcmQueryApplyCommodityOrderListReqBO bcmQueryApplyCommodityOrderListReqBO = this.getBcmQueryApplyCommodityOrderListReqBO();
        BcmQueryApplyCommodityOrderListRspBO bcmQueryApplyCommodityOrderListRspBO = this.bcmQueryApplyCommodityOrderListService.getList(bcmQueryApplyCommodityOrderListReqBO);
        if (!"0000".equals(bcmQueryApplyCommodityOrderListRspBO.getRespCode())) {
            throw new ZTBusinessException(bcmQueryApplyCommodityOrderListRspBO.getRespDesc());
        }
        if (CollectionUtils.isNotEmpty((Collection)bcmQueryApplyCommodityOrderListRspBO.getList())) {
            for (BcmApplyCommodityOrderBO bo : bcmQueryApplyCommodityOrderListRspBO.getList()) {
                this.bcmSaasSendNoticeService.sendAsyncPendingSelect(bo);
                this.sendTodo(bo);
            }
        }
        return BcmSaasRuUtil.success(BcmSaasSendMessageCutoffApplyOrderTaskRspBO.class);
    }

    private BcmQueryApplyCommodityOrderListReqBO getBcmQueryApplyCommodityOrderListReqBO() {
        BcmQueryApplyCommodityOrderListReqBO bcmQueryApplyCommodityOrderListReqBO = new BcmQueryApplyCommodityOrderListReqBO();
        bcmQueryApplyCommodityOrderListReqBO.setApplyOrderStatusList(Collections.singletonList(BcmPersonalApplyOrderStatusEnum.IN_SELECT.getStatus()));
        bcmQueryApplyCommodityOrderListReqBO.setSelectDeadlineStartDate((Date)DateUtil.offsetDay((Date)new Date(), (int)-1));
        return bcmQueryApplyCommodityOrderListReqBO;
    }

    private void sendTodo(BcmApplyCommodityOrderBO applyOrder) {
        BcmQueryFlowInstanceReqBO bcmQueryFlowInstanceReqBO = new BcmQueryFlowInstanceReqBO();
        bcmQueryFlowInstanceReqBO.setObjId(applyOrder.getApplyOrderId());
        bcmQueryFlowInstanceReqBO.setIsFinish(BcmPersonalFlowConstant.IsFinish.NO);
        bcmQueryFlowInstanceReqBO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        bcmQueryFlowInstanceReqBO.setObjType(BcmPersonalFlowConstant.ObjType.APPLY_ORDER);
        BcmQueryFlowInstanceRspBO bcmQueryFlowInstanceRspBO = this.bcmQueryFlowInstanceService.queryFlowInstance(bcmQueryFlowInstanceReqBO);
        if (!"0000".equals(bcmQueryFlowInstanceRspBO.getRespCode())) {
            log.error(bcmQueryFlowInstanceRspBO.getRespDesc());
            return;
        }
        if (StringUtils.isBlank((String)bcmQueryFlowInstanceRspBO.getFlowInstId())) {
            log.error("\u672a\u67e5\u8be2\u5230\u6d41\u7a0b\u5b9e\u4f8b");
            return;
        }
        BcmSaasProductTodoBO bcmSaasProductTodoBO = new BcmSaasProductTodoBO();
        bcmSaasProductTodoBO.setBusiId(String.valueOf(applyOrder.getApplyOrderId()));
        bcmSaasProductTodoBO.setTodoUrl(this.frontUrl + "ecSelectGoods?tabId=1002&f=ecCommodityOnshelfManage&applyOrderId=" + applyOrder.getApplyOrderId());
        bcmSaasProductTodoBO.setTodoItemName("\u5f85\u9009\u5b9a\u5546\u5bb6\uff1a\u5546\u54c1\u4e0a\u67b6\u7533\u8bf7\u5355" + applyOrder.getApplyOrderCode());
        bcmSaasProductTodoBO.setProcInstId(bcmQueryFlowInstanceRspBO.getFlowInstId());
        bcmSaasProductTodoBO.setCandidateOperId(applyOrder.getApplyUserId().toString());
        bcmSaasProductTodoBO.setCandidateOperName(applyOrder.getApplyUserName());
        bcmSaasProductTodoBO.setCreateTime(new Date());
        bcmSaasProductTodoBO.setTodoItemCode(this.applyOrderTodoCode);
        this.bcmSaasSendTodoService.pushTodo(bcmSaasProductTodoBO);
        BcmSaasAddTodoBO bcmSaasAddTodo = new BcmSaasAddTodoBO();
        bcmSaasAddTodo.setBusiId(String.valueOf(applyOrder.getApplyOrderId()));
        bcmSaasAddTodo.setTodoUrl(this.frontUrl + "ecSelectGoods?tabId=1002&f=ecCommodityOnshelfManage&applyOrderId=" + applyOrder.getApplyOrderId());
        bcmSaasAddTodo.setTodoItemName("\u5f85\u9009\u5b9a\u5546\u5bb6\uff1a\u5546\u54c1\u4e0a\u67b6\u7533\u8bf7\u5355" + applyOrder.getApplyOrderCode());
        bcmSaasAddTodo.setCandidateOperId(applyOrder.getApplyUserId().toString());
        bcmSaasAddTodo.setCandidateOperName(applyOrder.getApplyUserName());
        bcmSaasAddTodo.setTodoItemCode(this.applyOrderTodoCode);
        log.info("\u63a8\u9001\u5f85\u529e\u5165\u53c2{}", (Object)JSON.toJSONString((Object)bcmSaasAddTodo));
        this.bcmSaasSendTodoService.sendTodo(bcmSaasAddTodo);
    }

    public BcmSaasSendMessageCutoffApplyOrderTaskServiceImpl(BcmSaasSendNoticeService bcmSaasSendNoticeService) {
        this.bcmSaasSendNoticeService = bcmSaasSendNoticeService;
    }
}

