/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.client.utils.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmQueryBranchBankInvoiceRelaListService;
import com.tydic.bcm.personal.common.bo.BcmBranchBankInvoiceRelaBO;
import com.tydic.bcm.personal.common.bo.BcmQueryBranchBankInvoiceRelaListReqBO;
import com.tydic.bcm.personal.common.bo.BcmQueryBranchBankInvoiceRelaListRspBO;
import com.tydic.bcm.saas.personal.common.api.BcmSaasQueryInvoicePageListService;
import com.tydic.bcm.saas.personal.common.bo.BcmSaasQueryInvoicePageListReqBO;
import com.tydic.bcm.saas.personal.common.bo.BcmSaasQueryInvoicePageListRspBO;
import com.tydic.bcm.saas.personal.utils.BcmSaasHttpUtil;
import com.tydic.bcm.saas.personal.utils.BcmSaasRuUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_SAAS_GROUP_DEV/3.0.0/com.tydic.bcm.saas.personal.common.api.BcmSaasQueryInvoicePageListService"})
public class BcmSaasQueryInvoicePageListServiceImpl
implements BcmSaasQueryInvoicePageListService {
    @Autowired
    private BcmQueryBranchBankInvoiceRelaListService bcmQueryBranchBankInvoiceRelaListService;
    @Value(value="${QRY_INVOICE_LIST_URL:}")
    private String qryInvoiceListUrl;
    private final Integer toBeAssociated = 1001;
    private final Integer associated = 1002;

    @Override
    @PostMapping(value={"queryInvoicePageList"})
    public BcmSaasQueryInvoicePageListRspBO queryInvoicePageList(@RequestBody BcmSaasQueryInvoicePageListReqBO reqBO) {
        this.verifyParam(reqBO);
        return this.getInvoicePageList(reqBO);
    }

    private BcmSaasQueryInvoicePageListRspBO getInvoicePageList(BcmSaasQueryInvoicePageListReqBO reqBO) {
        List<BcmBranchBankInvoiceRelaBO> list = this.getBranchBankInvoiceList(reqBO);
        JSONObject params = new JSONObject();
        if (!CollectionUtils.isEmpty(list)) {
            if (this.toBeAssociated.equals(reqBO.getTabId())) {
                params.put("ignoreInvoiceIds", list.stream().map(BcmBranchBankInvoiceRelaBO::getInvoiceId).collect(Collectors.toList()));
            } else if (this.associated.equals(reqBO.getTabId())) {
                params.put("invoiceIds", list.stream().map(BcmBranchBankInvoiceRelaBO::getInvoiceId).collect(Collectors.toList()));
            } else {
                throw new ZTBusinessException("\u9519\u8bef\u7684tabId");
            }
        }
        params.put("pageNo", (Object)reqBO.getPageNo());
        params.put("pageSize", (Object)reqBO.getPageSize());
        params.put("invoiceTitle", (Object)reqBO.getInvoiceTitle());
        params.put("invoiceType", (Object)reqBO.getInvoiceType());
        String result = BcmSaasHttpUtil.doPost(this.qryInvoiceListUrl, params.toJSONString());
        JSONObject json = JSONObject.parseObject((String)result);
        return BcmSaasRuUtil.jss(json.get((Object)"data").toString(), BcmSaasQueryInvoicePageListRspBO.class);
    }

    private List<BcmBranchBankInvoiceRelaBO> getBranchBankInvoiceList(BcmSaasQueryInvoicePageListReqBO reqBO) {
        BcmQueryBranchBankInvoiceRelaListReqBO bcmQueryBranchBankInvoiceRelaListReqBO = new BcmQueryBranchBankInvoiceRelaListReqBO();
        bcmQueryBranchBankInvoiceRelaListReqBO.setBranchBankOrgId(reqBO.getBranchBankOrgId());
        BcmQueryBranchBankInvoiceRelaListRspBO bcmQueryBranchBankInvoiceRelaListRspBO = this.bcmQueryBranchBankInvoiceRelaListService.queryBranchBankInvoiceRelaList(bcmQueryBranchBankInvoiceRelaListReqBO);
        if (!"0000".equals(bcmQueryBranchBankInvoiceRelaListRspBO.getRespCode())) {
            throw new ZTBusinessException(bcmQueryBranchBankInvoiceRelaListRspBO.getRespDesc());
        }
        return bcmQueryBranchBankInvoiceRelaListRspBO.getList();
    }

    private void verifyParam(BcmSaasQueryInvoicePageListReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getTabId() == null) {
            throw new ZTBusinessException("\u5165\u53c2tabId\u4e0d\u80fd\u4e3anull");
        }
        if (StringUtils.isBlank((String)reqBO.getBranchBankOrgId())) {
            throw new ZTBusinessException("\u5165\u53c2\u5206\u884c\u673a\u6784id\u4e0d\u80fd\u4e3anull");
        }
    }
}

