/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.notice.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.saas.personal.notice.BcmSaasSendTodoService;
import com.tydic.bcm.saas.personal.notice.bo.BcmAbilitySendTaskToGuwpReqBO;
import com.tydic.bcm.saas.personal.notice.bo.BcmSaasAddTodoBO;
import com.tydic.bcm.saas.personal.notice.bo.BcmSaasHaveDoneTodoBO;
import com.tydic.bcm.saas.personal.notice.bo.BcmSaasProductTodoBO;
import com.tydic.bcm.saas.personal.notice.bo.BcmSaasRevokeTodoBo;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmUpdateTaskStatusToGuwpReqBO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BcmSaasSendTodoServiceImpl
implements BcmSaasSendTodoService {
    private static final Logger log = LoggerFactory.getLogger(BcmSaasSendTodoServiceImpl.class);
    @Value(value="${UMC_TODO_URL}")
    private String umcTodoUrl;
    @Value(value="${UMC_DONE_TODO_URL}")
    private String umcDoneTodoUrl;
    @Value(value="${UMC_REVOKE_TODO_URL}")
    private String umcRevokeTodoUrl;
    @Value(value="${PUSH_GUWP_TODO_URL}")
    private String pushGuwpTodoUrl;
    @Value(value="${PUSH_GUWP_TODO_UPDATE_STATUS_URL}")
    private String pushGuwpTodoUpdateStatusUrl;

    @Override
    public void sendTodo(BcmSaasAddTodoBO addTodo) {
        this.sendBatchTodo(Lists.newArrayList((Object[])new BcmSaasAddTodoBO[]{addTodo}));
    }

    @Override
    public void sendBatchTodo(List<BcmSaasAddTodoBO> addTodoList) {
        if (CollectionUtil.isEmpty(addTodoList)) {
            return;
        }
        addTodoList.forEach(addTodo -> {
            if (StrUtil.isEmpty((CharSequence)addTodo.getCreateOperId())) {
                addTodo.setCreateOperId(BcmPersonalCommonConstant.DefaultUser.DEFAULT_USER_ID.toString());
                addTodo.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
            }
        });
        JSONObject reqStr = new JSONObject();
        reqStr.put("todoList", addTodoList);
        log.info("\u53d1\u9001\u4ee3\u529e\u53c2\u6570 {}", (Object)reqStr.toJSONString());
        String post = HttpUtil.post((String)this.umcTodoUrl, (String)reqStr.toJSONString());
        log.info("\u4ee3\u529e\u8fd4\u56de\u7ed3\u679c {}", (Object)post);
    }

    @Override
    public void pushTodo(BcmSaasProductTodoBO reqBO) {
        BcmAbilitySendTaskToGuwpReqBO sendData = new BcmAbilitySendTaskToGuwpReqBO();
        sendData.setTaskUrl(reqBO.getTodoUrl());
        sendData.setCreateDateTime(reqBO.getCreateTime());
        sendData.setTitle(reqBO.getTodoItemName());
        sendData.setAppProcessId(reqBO.getProcInstId());
        BcmAbilitySendTaskToGuwpReqBO.GuwpReceiveUserBO receiveUserBO = new BcmAbilitySendTaskToGuwpReqBO.GuwpReceiveUserBO();
        receiveUserBO.setUserName(reqBO.getCandidateOperName());
        receiveUserBO.setUserCode(reqBO.getCandidateOperExtId());
        sendData.setReceiveUserList(Lists.newArrayList((Object[])new BcmAbilitySendTaskToGuwpReqBO.GuwpReceiveUserBO[]{receiveUserBO}));
        log.info("\u63a8\u9001guwp\u4ee3\u529e\u53c2\u6570 {}", (Object)JSONObject.toJSONString((Object)sendData));
        String post = HttpUtil.post((String)this.pushGuwpTodoUrl, (String)JSONObject.toJSONString((Object)sendData));
        log.info("\u63a8\u9001guwp\u4ee3\u529e\u8fd4\u56de\u7ed3\u679c {}", (Object)post);
    }

    @Override
    public void sendHaveDone(BcmSaasHaveDoneTodoBO haveDoneTodo) {
        if (haveDoneTodo == null) {
            return;
        }
        if (haveDoneTodo.getOperUserId() == null) {
            haveDoneTodo.setOperUserId(BcmPersonalCommonConstant.DefaultUser.DEFAULT_USER_ID);
            haveDoneTodo.setOperUserName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        }
        JSONObject reqStr = new JSONObject();
        reqStr.put("todoList", (Object)haveDoneTodo);
        log.info("\u53d1\u9001\u5df2\u529e\u53c2\u6570 {}", (Object)JSON.toJSONString((Object)haveDoneTodo));
        String post = HttpUtil.post((String)this.umcDoneTodoUrl, (String)JSON.toJSONString((Object)haveDoneTodo));
        log.info("\u5df2\u529e\u8fd4\u56de\u7ed3\u679c {}", (Object)post);
    }

    @Override
    public void revokeTodo(BcmSaasRevokeTodoBo revokeTodoBo) {
        if (revokeTodoBo == null) {
            return;
        }
        if (revokeTodoBo.getOperUserId() == null) {
            revokeTodoBo.setOperUserId(BcmPersonalCommonConstant.DefaultUser.DEFAULT_USER_ID);
            revokeTodoBo.setOperUserName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        }
        log.info("\u64a4\u56de\u4ee3\u529e\u53c2\u6570 {}", (Object)JSON.toJSONString((Object)revokeTodoBo));
        String post = HttpUtil.post((String)this.umcRevokeTodoUrl, (String)JSON.toJSONString((Object)revokeTodoBo));
        log.info("\u64a4\u56de\u4ee3\u529e\u8fd4\u56de\u7ed3\u679c {}", (Object)post);
    }

    @Override
    public void pushDone(BcmUpdateTaskStatusToGuwpReqBO updateTaskStatusToGuwpReqBO) {
        if (updateTaskStatusToGuwpReqBO == null) {
            return;
        }
        log.info("\u4ee3\u529e\u66f4\u65b0\u72b6\u6001\u5165\u53c2 {}", (Object)JSON.toJSONString((Object)updateTaskStatusToGuwpReqBO));
        String post = HttpUtil.post((String)this.pushGuwpTodoUpdateStatusUrl, (String)JSON.toJSONString((Object)updateTaskStatusToGuwpReqBO));
        log.info("\u4ee3\u529e\u66f4\u65b0\u72b6\u6001\u56de\u53c2 {}", (Object)post);
    }
}

