/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.product.ext.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.saas.personal.constant.BcmSaasPersonalCommonConstant;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmGetOutIdInfoByInnerIdRspBo;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmOrgInfoExtBo;
import com.tydic.bcm.saas.personal.utils.BcmSaasHttpUtil;
import com.tydic.dyc.saas.uoc.api.DycUocOrderTakeUpBudgetServiceExtPt;
import com.tydic.dyc.saas.uoc.bo.DycUocOrderTakeUpBudgetCommodityInfoBO;
import com.tydic.dyc.saas.uoc.bo.DycUocOrderTakeUpBudgetServiceExtReqBo;
import com.tydic.dyc.saas.uoc.bo.DycUocOrderTakeUpBudgetServiceExtRspBo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.saas.uoc.api.DycUocOrderTakeUpBudgetServiceExtPt"})
public class DycUocOrderTakeUpBudgetServiceExtPtImpl
implements DycUocOrderTakeUpBudgetServiceExtPt {
    private static final Logger log = LoggerFactory.getLogger(DycUocOrderTakeUpBudgetServiceExtPtImpl.class);
    @Value(value="${OCCUPY_BUDGET_URL:}")
    private String occupyBudgetUrl;
    @Value(value="${GET_OUT_INFO_URL:}")
    private String getOutInfoUrl;
    private static final String SUCCESS = "0";

    @PostMapping(value={"takeUpBudget"})
    public DycUocOrderTakeUpBudgetServiceExtRspBo takeUpBudget(@RequestBody DycUocOrderTakeUpBudgetServiceExtReqBo reqBO) {
        DycUocOrderTakeUpBudgetServiceExtRspBo rspBo = new DycUocOrderTakeUpBudgetServiceExtRspBo();
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        HashMap<Long, BcmOrgInfoExtBo> orgMap = new HashMap<Long, BcmOrgInfoExtBo>();
        this.changeUmcData(reqBO, orgIdList, orgMap);
        JSONObject reqStr = DycUocOrderTakeUpBudgetServiceExtPtImpl.setReqStr(reqBO, orgMap);
        log.info("\u8c03\u7528\u5916\u90e8\u7cfb\u7edf\u91ca\u653e\u8ba2\u5355\u9884\u7b97\u5165\u53c2\u4e3a\uff1a{}", (Object)reqStr);
        String rspStr = BcmSaasHttpUtil.doPost(this.occupyBudgetUrl, reqStr.toJSONString());
        log.info("\u8c03\u7528\u5916\u90e8\u7cfb\u7edf\u91ca\u653e\u8ba2\u5355\u9884\u7b97\u51fa\u53c2\u4e3a\uff1a{}", (Object)rspStr);
        JSONObject rspJson = JSON.parseObject((String)rspStr);
        if (!SUCCESS.equals(rspJson.getString("code"))) {
            throw new ZTBusinessException("\u8c03\u7528\u5916\u90e8\u7cfb\u7edf\u91ca\u653e\u8ba2\u5355\u9884\u7b97\u62a5\u9519:" + rspJson.getString("message"));
        }
        return rspBo;
    }

    private void changeUmcData(DycUocOrderTakeUpBudgetServiceExtReqBo reqBO, List<Long> orgIdList, Map<Long, BcmOrgInfoExtBo> orgMap) {
        if (ObjectUtil.isNotEmpty((Object)reqBO.getFinancialOrgId())) {
            orgIdList.add(Long.valueOf(reqBO.getFinancialOrgId()));
        }
        orgIdList.addAll(reqBO.getSaleOrderItemList().stream().map(item -> Long.valueOf(item.getSupplierId())).collect(Collectors.toList()));
        JSONObject reqUmcStr = new JSONObject();
        reqUmcStr.put("orgIdList", orgIdList);
        log.info("\u8c03\u7528\u4f1a\u5458\u63a5\u53e3\u8f6c\u6362\u6570\u636e\u5165\u53c2\u4e3a\uff1a{}", (Object)reqUmcStr);
        String rspUmcStr = BcmSaasHttpUtil.doPost(this.getOutInfoUrl, reqUmcStr.toJSONString());
        log.info("\u8c03\u7528\u4f1a\u5458\u63a5\u53e3\u8f6c\u6362\u6570\u636e\u51fa\u53c2\u4e3a\uff1a{}", (Object)rspUmcStr);
        BcmGetOutIdInfoByInnerIdRspBo innerIdRspBo = (BcmGetOutIdInfoByInnerIdRspBo)((Object)JSON.parseObject((String)JSON.parseObject((String)rspUmcStr).get((Object)"data").toString(), BcmGetOutIdInfoByInnerIdRspBo.class));
        if (!SUCCESS.equals(innerIdRspBo.getCode())) {
            throw new ZTBusinessException(innerIdRspBo.getCode());
        }
        if (ObjectUtil.isNotEmpty(innerIdRspBo.getUmcOrgInfoExtBoList())) {
            orgMap = innerIdRspBo.getUmcOrgInfoExtBoList().stream().collect(Collectors.toMap(BcmOrgInfoExtBo::getOrgId, Function.identity()));
        }
    }

    private static JSONObject setReqStr(DycUocOrderTakeUpBudgetServiceExtReqBo reqBo, Map<Long, BcmOrgInfoExtBo> orgMap) {
        JSONObject reqStr = new JSONObject();
        reqStr.put("id", (Object)reqBo.getSaleOrderId());
        if (orgMap.containsKey(Long.valueOf(reqBo.getFinancialOrgId()))) {
            reqStr.put("pkOrg", (Object)orgMap.get(Long.valueOf(reqBo.getFinancialOrgId())).getExtOrgId());
        }
        reqStr.put("orderType", (Object)reqBo.getPayStatus());
        reqStr.put("agentName", (Object)reqBo.getCreateOperName());
        reqStr.put("agentCode", (Object)reqBo.getExtCustId());
        if (BcmSaasPersonalCommonConstant.SkuSource.AGREEMENT.equals(Integer.valueOf(reqBo.getOrderSource()))) {
            reqStr.put("currency", (Object)"");
            reqStr.put("purchaseType", (Object)"2");
        } else {
            reqStr.put("currency", (Object)"CNY");
            reqStr.put("purchaseType", (Object)"1");
        }
        JSONArray payitemList = new JSONArray();
        for (DycUocOrderTakeUpBudgetCommodityInfoBO item : reqBo.getSaleOrderItemList()) {
            JSONObject itemStr = DycUocOrderTakeUpBudgetServiceExtPtImpl.setOrderItem(reqBo, item, orgMap);
            payitemList.add((Object)itemStr);
        }
        reqStr.put("payitemList", (Object)payitemList);
        return reqStr;
    }

    private static JSONObject setFile(DycUocOrderTakeUpBudgetServiceExtReqBo reqBo, DycUocOrderTakeUpBudgetCommodityInfoBO item) {
        JSONObject fileStr = new JSONObject();
        fileStr.put("ecmId", (Object)"");
        fileStr.put("fileName", (Object)"");
        fileStr.put("fileType", (Object)"");
        fileStr.put("fileLength", (Object)"");
        return fileStr;
    }

    private static JSONObject setOrderItem(DycUocOrderTakeUpBudgetServiceExtReqBo reqBo, DycUocOrderTakeUpBudgetCommodityInfoBO item, Map<Long, BcmOrgInfoExtBo> orgMap) {
        JSONObject itemStr = new JSONObject();
        itemStr.put("orderId", (Object)item.getSaleOrderItemId());
        itemStr.put("contractCode", (Object)reqBo.getRelCode());
        itemStr.put("contractName", (Object)reqBo.getRelName());
        itemStr.put("pkInoutbusiClass", (Object)item.getIncomeAndExpProjectId());
        itemStr.put("budgetAccount", (Object)reqBo.getBudgetProjectId());
        itemStr.put("ccCode", (Object)reqBo.getCostCenterId());
        itemStr.put("paidAmount", (Object)item.getPurchasePrice());
        if (orgMap.containsKey(Long.valueOf(item.getSupplierId()))) {
            itemStr.put("usci", (Object)orgMap.get(Long.valueOf(item.getSupplierId())).getCreditNo());
            itemStr.put("recAccount", (Object)orgMap.get(Long.valueOf(item.getSupplierId())).getBankAccount());
        }
        return itemStr;
    }
}

