/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.product.ext.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmSaasOutSendEvaInfoToZcPlatformServiceReqBO;
import com.tydic.bcm.saas.personal.utils.BcmSaasHttpUtil;
import com.tydic.bcm.saas.personal.utils.BcmSaasRuUtil;
import com.tydic.dyc.base.bo.BaseRspBo;
import com.tydic.dyc.saas.uoc.api.DycUocOrderToItPlatformServiceExtPt;
import com.tydic.dyc.saas.uoc.bo.DycUocOrderToItPlatformServiceReqBo;
import com.tydic.dyc.saas.uoc.bo.DycUocOrderToItPlatformServiceRspBo;
import com.tydic.dyc.saas.uoc.bo.DycUocToItPlatformOrderInfoBO;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.saas.uoc.api.DycUocOrderToItPlatformServiceExtPt"})
public class DycUocOrderToItPlatformServiceImpl
implements DycUocOrderToItPlatformServiceExtPt {
    private static final Logger log = LoggerFactory.getLogger(DycUocOrderToItPlatformServiceImpl.class);
    @Value(value="${ORDER_SYNC_URL:url}")
    private String orderSyncUrl;

    @PostMapping(value={"syncOrderInfo"})
    public DycUocOrderToItPlatformServiceRspBo syncOrderInfo(@RequestBody DycUocOrderToItPlatformServiceReqBo reqBo) {
        this.verifyParam(reqBo);
        this.toItPlatform(reqBo);
        return BcmSaasRuUtil.success(DycUocOrderToItPlatformServiceRspBo.class);
    }

    private void toItPlatform(DycUocOrderToItPlatformServiceReqBo reqBO) {
        for (DycUocToItPlatformOrderInfoBO bo : reqBO.getSaleOrderInfoList()) {
            BcmSaasOutSendEvaInfoToZcPlatformServiceReqBO bcmSaasOutSendEvaInfoToZcPlatformServiceReqBo = new BcmSaasOutSendEvaInfoToZcPlatformServiceReqBO();
            bcmSaasOutSendEvaInfoToZcPlatformServiceReqBo.setOrderNo(bo.getSaleOrderNo());
            bcmSaasOutSendEvaInfoToZcPlatformServiceReqBo.setOrderMoney(bo.getSaleOrderTotal().toString());
            bcmSaasOutSendEvaInfoToZcPlatformServiceReqBo.setOrderEffectTime(bo.getCreateTime().toString());
            bcmSaasOutSendEvaInfoToZcPlatformServiceReqBo.setPlancingOrderUser(bo.getCreateOperName());
            String body = JSONObject.toJSONString((Object)bcmSaasOutSendEvaInfoToZcPlatformServiceReqBo);
            String result = BcmSaasHttpUtil.doPost(this.orderSyncUrl, body);
            if (StringUtils.isNotBlank((String)result)) {
                BaseRspBo baseRspBo = BcmSaasRuUtil.jss(result, BaseRspBo.class);
                if ("0".equals(baseRspBo.getCode())) continue;
                log.error("\u8ba2\u5355\u4fe1\u606f\u63a8\u9001\u5230IT\u5e73\u53f0\u5931\u8d25{}", (Object)bo.getSaleOrderNo());
                throw new ZTBusinessException("\u8ba2\u5355\u4fe1\u606f\u63a8\u9001\u5230IT\u5e73\u53f0\u5931\u8d25");
            }
            log.error("\u8ba2\u5355\u4fe1\u606f\u63a8\u9001\u5230IT\u5e73\u53f0\u5931\u8d25{}", (Object)bo.getSaleOrderNo());
            throw new ZTBusinessException("\u8ba2\u5355\u4fe1\u606f\u63a8\u9001\u5230IT\u5e73\u53f0\u5931\u8d25");
        }
    }

    private void verifyParam(DycUocOrderToItPlatformServiceReqBo reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        for (DycUocToItPlatformOrderInfoBO orderInfoBO : reqBO.getSaleOrderInfoList()) {
            if (orderInfoBO.getOrderId() == null) {
                throw new ZTBusinessException("\u5165\u53c2\u8ba2\u5355id\u4e0d\u80fd\u4e3anull");
            }
            if (orderInfoBO.getSaleOrderId() == null) {
                throw new ZTBusinessException("\u5165\u53c2\u9500\u552e\u5355id\u4e0d\u80fd\u4e3anull");
            }
            if (!CollectionUtils.isEmpty((Collection)orderInfoBO.getSaleOrderItemList())) continue;
            throw new ZTBusinessException("\u5165\u53c2\u9500\u552e\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3anull");
        }
    }
}

