/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.product.ext.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmGetOutIdInfoByInnerIdRspBo;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmInspItemBO;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmOrgInfoExtBo;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmQueryOrderItemBO;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmUserInfoExtBo;
import com.tydic.bcm.saas.personal.utils.BcmSaasHttpUtil;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.ext.fsc.api.FscOrderInfoPushServiceExtPt;
import com.tydic.ext.fsc.bo.FscExtInvoiceBO;
import com.tydic.ext.fsc.bo.FscExtOrderItemBO;
import com.tydic.ext.fsc.bo.FscOrderInfoPushReqBO;
import com.tydic.ext.fsc.bo.FscOrderInfoPushRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_SAAS_GROUP_DEV/3.0.0/com.tydic.ext.fsc.api.FscOrderInfoPushServiceExtPt"})
public class FscOrderInfoPushServiceExtPtImpl
implements FscOrderInfoPushServiceExtPt {
    private static final Logger log = LoggerFactory.getLogger(FscOrderInfoPushServiceExtPtImpl.class);
    @Value(value="${ORDER_INFO_PUSH_URL:}")
    private String orderInfoPushUrl;
    @Value(value="${ORDER_ITEM_QUERY_URL:}")
    private String orderItemQueryUrl;
    @Value(value="${GET_OUT_INFO_URL:}")
    private String getOutInfoUrl;
    private static final String SUCCESS = "0";

    @PostMapping(value={"pushFscOrder"})
    public FscOrderInfoPushRspBO pushFscOrder(@RequestBody FscOrderInfoPushReqBO reqBO) {
        FscOrderInfoPushRspBO rspBO = new FscOrderInfoPushRspBO();
        ArrayList<Long> userIdList = new ArrayList<Long>();
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        HashMap<Long, BcmOrgInfoExtBo> orgMap = new HashMap<Long, BcmOrgInfoExtBo>();
        HashMap<Long, BcmUserInfoExtBo> userMap = new HashMap<Long, BcmUserInfoExtBo>();
        Map<Long, BcmInspItemBO> inspItemBOMap = this.changeOrderItem(reqBO, orgIdList);
        this.changeUmcData(reqBO, userIdList, orgIdList, orgMap, userMap);
        JSONObject reqStr = this.setReqStr(reqBO, inspItemBOMap, orgMap, userMap);
        log.info("\u8c03\u7528\u5916\u90e8\u7cfb\u7edf\u7ed3\u7b97\u5355\u4fe1\u606f\u63a8\u9001\u5165\u53c2\u4e3a\uff1a{}", (Object)reqStr);
        String rspStr = BcmSaasHttpUtil.doPost(this.orderInfoPushUrl, reqStr.toJSONString());
        log.info("\u8c03\u7528\u5916\u90e8\u7cfb\u7edf\u7ed3\u7b97\u5355\u4fe1\u606f\u63a8\u9001\u51fa\u53c2\u4e3a\uff1a{}", (Object)rspStr);
        JSONObject rspJson = JSON.parseObject((String)rspStr);
        if (!SUCCESS.equals(rspJson.getString("code"))) {
            throw new ZTBusinessException("\u8c03\u7528\u5916\u90e8\u7cfb\u7ed3\u7b97\u5355\u4fe1\u606f\u63a8\u9001\u62a5\u9519:" + rspJson.getString("message"));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void changeUmcData(FscOrderInfoPushReqBO reqBO, List<Long> userIdList, List<Long> orgIdList, Map<Long, BcmOrgInfoExtBo> orgMap, Map<Long, BcmUserInfoExtBo> userMap) {
        userIdList.add(reqBO.getCreateOperId());
        orgIdList.add(reqBO.getPurchaserId());
        JSONObject reqUmcStr = new JSONObject();
        reqUmcStr.put("userIdList", userIdList);
        reqUmcStr.put("orgIdList", orgIdList);
        log.info("\u8c03\u7528\u4f1a\u5458\u63a5\u53e3\u8f6c\u6362\u6570\u636e\u5165\u53c2\u4e3a\uff1a{}", (Object)reqUmcStr);
        String rspUmcStr = BcmSaasHttpUtil.doPost(this.getOutInfoUrl, reqUmcStr.toJSONString());
        log.info("\u8c03\u7528\u4f1a\u5458\u63a5\u53e3\u8f6c\u6362\u6570\u636e\u51fa\u53c2\u4e3a\uff1a{}", (Object)rspUmcStr);
        BcmGetOutIdInfoByInnerIdRspBo innerIdRspBo = (BcmGetOutIdInfoByInnerIdRspBo)((Object)JSON.parseObject((String)JSON.parseObject((String)rspUmcStr).get((Object)"data").toString(), BcmGetOutIdInfoByInnerIdRspBo.class));
        if (!SUCCESS.equals(innerIdRspBo.getCode())) {
            throw new ZTBusinessException(innerIdRspBo.getCode());
        }
        if (ObjectUtil.isNotEmpty(innerIdRspBo.getUmcOrgInfoExtBoList())) {
            orgMap = innerIdRspBo.getUmcOrgInfoExtBoList().stream().collect(Collectors.toMap(BcmOrgInfoExtBo::getOrgId, Function.identity()));
        }
        if (ObjectUtil.isNotEmpty(innerIdRspBo.getUmcUserInfoExtBoList())) {
            userMap = innerIdRspBo.getUmcUserInfoExtBoList().stream().collect(Collectors.toMap(BcmUserInfoExtBo::getUserId, Function.identity()));
        }
    }

    private Map<Long, BcmInspItemBO> changeOrderItem(FscOrderInfoPushReqBO reqBO, List<Long> orgIdList) {
        List inspItemIdList = reqBO.getFscExtOrderItemBOList().stream().map(FscExtOrderItemBO::getOrderItemId).distinct().collect(Collectors.toList());
        JSONObject queryOrderItemReqBO = new JSONObject();
        queryOrderItemReqBO.put("inspItemIdList", inspItemIdList);
        log.info("\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)queryOrderItemReqBO.toJSONString());
        String queryOrderItemRspBO = BcmSaasHttpUtil.doPost(this.orderItemQueryUrl, queryOrderItemReqBO.toJSONString());
        log.info("\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2\u51fa\u53c2\uff1a{}", (Object)queryOrderItemRspBO);
        BcmQueryOrderItemBO orderItemBO = (BcmQueryOrderItemBO)((Object)JSON.parseObject((String)JSON.parseObject((String)queryOrderItemRspBO).get((Object)"data").toString(), BcmQueryOrderItemBO.class));
        if (!SUCCESS.equals(orderItemBO.getCode())) {
            throw new ZTBusinessException(orderItemBO.getMessage());
        }
        log.info("\u8f6c\u6362\u540e\u7684\u5bf9\u8c61\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)((Object)orderItemBO)));
        if (ObjectUtil.isEmpty(orderItemBO.getInspItemList())) {
            return null;
        }
        orgIdList.addAll(orderItemBO.getInspItemList().stream().map(BcmInspItemBO::getSupplierId).collect(Collectors.toList()));
        return orderItemBO.getInspItemList().stream().collect(Collectors.toMap(BcmInspItemBO::getInspOrderItemId, Function.identity()));
    }

    private JSONObject setReqStr(FscOrderInfoPushReqBO reqBO, Map<Long, BcmInspItemBO> inspItemBOMap, Map<Long, BcmOrgInfoExtBo> orgMap, Map<Long, BcmUserInfoExtBo> userMap) {
        JSONObject reqStr = new JSONObject();
        reqStr.put("mallStatementId", (Object)reqBO.getFscOrderId());
        reqStr.put("mallStatementCode", (Object)reqBO.getFscOrderNo());
        if (orgMap.containsKey(reqBO.getPurchaserId())) {
            reqStr.put("pkOrg", (Object)orgMap.get(reqBO.getPurchaserId()).getExtOrgId());
        }
        if (userMap.containsKey(reqBO.getCreateOperId())) {
            reqStr.put("agentName", (Object)userMap.get(reqBO.getCreateOperId()).getCustName());
            reqStr.put("agentCode", (Object)userMap.get(reqBO.getCreateOperId()).getExtCustId());
        }
        reqStr.put("billMake", (Object)reqBO.getFscExtOrderExtFieldBo().getValue7());
        reqStr.put("currency", (Object)"CNY");
        reqStr.put("abstractInfo", (Object)"");
        JSONArray payitemList = this.setPayItem(reqBO, inspItemBOMap, orgMap);
        reqStr.put("payitemList", (Object)payitemList);
        JSONArray payInvoiceList = new JSONArray();
        for (FscExtInvoiceBO invoiceItem : reqBO.getFscExtInvoiceBOList()) {
            JSONObject payInvoice = this.setPayInvoice(invoiceItem);
            payInvoiceList.add((Object)payInvoice);
        }
        reqStr.put("payInvoiceList", (Object)payInvoiceList);
        JSONArray fileList = this.setFile(reqBO);
        reqStr.put("fileList", (Object)fileList);
        return reqStr;
    }

    private JSONArray setFile(FscOrderInfoPushReqBO reqBO) {
        JSONArray fileList = new JSONArray();
        for (FscExtInvoiceBO invoiceBO : reqBO.getFscExtInvoiceBOList()) {
            List fileBOS = invoiceBO.getFscExtAttachmentBOList().stream().map(item -> {
                JSONObject file = new JSONObject();
                file.put("ecmId", (Object)invoiceBO.getInvoiceNo());
                file.put("fileName", (Object)item.getAttachmentName());
                file.put("fileType", (Object)item.getAttachmentType());
                return file;
            }).collect(Collectors.toList());
            fileList.addAll(fileBOS);
        }
        return fileList;
    }

    private JSONObject setSupplierBank(FscOrderInfoPushReqBO reqBO) {
        JSONObject supplierBank = new JSONObject();
        supplierBank.put("accNum", (Object)"");
        supplierBank.put("accName", (Object)"");
        supplierBank.put("pkBankType", (Object)"");
        supplierBank.put("pkBankDoc", (Object)"");
        supplierBank.put("accountProperty", (Object)"");
        supplierBank.put("enableState", (Object)"");
        supplierBank.put("pkCurrType", (Object)"");
        supplierBank.put("isDefault", (Object)"");
        return supplierBank;
    }

    private JSONObject setSupplier(FscOrderInfoPushReqBO reqBO) {
        JSONObject supplier = new JSONObject();
        supplier.put("pkOrgS", (Object)reqBO.getSupplierId());
        supplier.put("supplierCode", (Object)"");
        supplier.put("supplierName", (Object)reqBO.getSupplierName());
        supplier.put("pkSupplierClass", (Object)"");
        supplier.put("supplierStatus", (Object)"");
        supplier.put("taxpayerId", (Object)"");
        supplier.put("societyCode", (Object)"");
        supplier.put("supplierCountry", (Object)"");
        return supplier;
    }

    private JSONObject setPayInvoice(FscExtInvoiceBO invoiceItem) {
        JSONObject payInvoice = new JSONObject();
        payInvoice.put("invoiceCode", (Object)invoiceItem.getInvoiceCode());
        payInvoice.put("invoiceNo", (Object)invoiceItem.getInvoiceNo());
        payInvoice.put("checkCode", (Object)"");
        payInvoice.put("invoiceDate", (Object)invoiceItem.getBillDate());
        payInvoice.put("noTaxMoney", (Object)invoiceItem.getAmt());
        payInvoice.put("incomeTax", (Object)invoiceItem.getTaxAmt());
        BigDecimal priceAndTax = invoiceItem.getAmt().add(invoiceItem.getTaxAmt());
        payInvoice.put("priceAndTax", (Object)priceAndTax);
        payInvoice.put("remark", (Object)"");
        return payInvoice;
    }

    private JSONArray setPayItem(FscOrderInfoPushReqBO reqBO, Map<Long, BcmInspItemBO> inspItemBOMap, Map<Long, BcmOrgInfoExtBo> orgMap) {
        JSONArray payItemList = new JSONArray();
        if (ObjectUtil.isNotEmpty((Object)reqBO.getFscExtOrderItemBOList())) {
            for (FscExtOrderItemBO extOrderItemBO : reqBO.getFscExtOrderItemBOList()) {
                JSONObject payItem = new JSONObject();
                payItem.put("idB", (Object)extOrderItemBO.getId());
                if (inspItemBOMap.containsKey(extOrderItemBO.getOrderItemId())) {
                    BcmInspItemBO bcmInspItemBO = inspItemBOMap.get(extOrderItemBO.getOrderItemId());
                    payItem.put("contractCode", (Object)this.getFieleValue(bcmInspItemBO, "jhContractNo"));
                    payItem.put("contractName", (Object)this.getFieleValue(bcmInspItemBO, "jhContractName"));
                    payItem.put("pkInoutBusiClass", (Object)this.getFieleValue(bcmInspItemBO, "incomeAndExpProjectId"));
                    payItem.put("budgetAccount", (Object)this.getFieleValue(bcmInspItemBO, "budgetProjectId"));
                    payItem.put("ccCode", (Object)this.getFieleValue(bcmInspItemBO, "costCenterId"));
                    payItem.put("fileId", (Object)this.getFieleValue(bcmInspItemBO, "financialId"));
                    payItem.put("amonut", (Object)bcmInspItemBO.getInspFee());
                    if (orgMap.containsKey(bcmInspItemBO.getSupplierId())) {
                        payItem.put("usci", (Object)orgMap.get(bcmInspItemBO.getSupplierId()).getCreditNo());
                        payItem.put("recAccount", (Object)orgMap.get(bcmInspItemBO.getSupplierId()).getBankAccount());
                    }
                }
                payItem.put("inputTaxCategoxy", (Object)"");
                payItemList.add((Object)payItem);
            }
        }
        return payItemList;
    }

    private String getFieleValue(BcmInspItemBO bcmInspItemBO, String code) {
        BaseExtendFieldBo extendFieldBo = bcmInspItemBO.getSaleOrderRspBo().getExtFields().stream().filter(item -> code.equals(item.getFieldCode())).findFirst().orElse(null);
        if (extendFieldBo != null) {
            return extendFieldBo.getFieldValue();
        }
        return null;
    }
}

