/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.task.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmQueryApplyCommodityOrderListService;
import com.tydic.bcm.personal.commodity.api.BcmUpdateBatchApplyCommodityOrderService;
import com.tydic.bcm.personal.commodity.bo.BcmApplyCommodityOrderBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyCommodityOrderListReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyCommodityOrderListRspBO;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateBatchApplyCommodityOrderReqBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.saas.personal.task.api.BcmSaasUccstopCommodityPoolAbilityTaskService;
import com.tydic.bcm.saas.personal.task.bo.BcmSaasOutUccstopCommodityPoolAbilityReqBO;
import com.tydic.bcm.saas.personal.task.bo.BcmSaasUccstopCommodityPoolAbilityTaskReqBO;
import com.tydic.bcm.saas.personal.task.bo.BcmSaasUccstopCommodityPoolAbilityTaskRspBO;
import com.tydic.bcm.saas.personal.utils.BcmSaasHttpUtil;
import com.tydic.bcm.saas.personal.utils.BcmSaasRuUtil;
import com.tydic.dyc.base.bo.BaseRspBo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_SAAS_GROUP_DEV/3.0.0/com.tydic.bcm.saas.personal.task.api.BcmSaasUccstopCommodityPoolAbilityTaskService"})
public class BcmSaasUccstopCommodityPoolAbilityTaskServiceImpl
implements BcmSaasUccstopCommodityPoolAbilityTaskService {
    private static final Logger log = LoggerFactory.getLogger(BcmSaasUccstopCommodityPoolAbilityTaskServiceImpl.class);
    @Value(value="${STOP.COMMODITY.POOL.URl}")
    private String url;
    @Autowired
    private BcmQueryApplyCommodityOrderListService bcmQueryApplyCommodityOrderListService;
    @Autowired
    private BcmUpdateBatchApplyCommodityOrderService bcmUpdateBatchApplyCommodityOrderService;

    @Override
    @PostMapping(value={"stopCommodityPool"})
    public BcmSaasUccstopCommodityPoolAbilityTaskRspBO stopCommodityPool(@RequestBody BcmSaasUccstopCommodityPoolAbilityTaskReqBO reqBO) {
        BcmQueryApplyCommodityOrderListReqBO bcmQueryApplyCommodityOrderListReqBO = this.getBcmQueryApplyCommodityOrderListReqBO();
        BcmQueryApplyCommodityOrderListRspBO bcmQueryApplyCommodityOrderListRspBO = this.bcmQueryApplyCommodityOrderListService.getList(bcmQueryApplyCommodityOrderListReqBO);
        if (!"0000".equals(bcmQueryApplyCommodityOrderListRspBO.getRespCode())) {
            throw new ZTBusinessException(bcmQueryApplyCommodityOrderListRspBO.getRespDesc());
        }
        if (CollectionUtils.isNotEmpty((Collection)bcmQueryApplyCommodityOrderListRspBO.getList())) {
            log.info("\u4ea7\u54c1\u5b9a\u5236\u5546\u54c1\u6c60\u5931\u6548\u4e0a\u67b6\u7533\u8bf7\u5355{}", (Object)JSONObject.toJSONString((Object)bcmQueryApplyCommodityOrderListRspBO));
            this.stopCommodityPool(bcmQueryApplyCommodityOrderListRspBO);
        }
        return BcmSaasRuUtil.success(BcmSaasUccstopCommodityPoolAbilityTaskRspBO.class);
    }

    private void stopCommodityPool(BcmQueryApplyCommodityOrderListRspBO bcmQueryApplyCommodityOrderListRspBO) {
        ArrayList<Long> applyOrderIdList = new ArrayList<Long>(bcmQueryApplyCommodityOrderListRspBO.getList().size());
        for (BcmApplyCommodityOrderBO bo : bcmQueryApplyCommodityOrderListRspBO.getList()) {
            BcmSaasOutUccstopCommodityPoolAbilityReqBO bcmSaasOutUccstopCommodityPoolAbilityReqBO = new BcmSaasOutUccstopCommodityPoolAbilityReqBO();
            bcmSaasOutUccstopCommodityPoolAbilityReqBO.setExpand7(String.valueOf(bo.getApplyOrderId()));
            String body = JSONObject.toJSONString((Object)bcmSaasOutUccstopCommodityPoolAbilityReqBO);
            String result = BcmSaasHttpUtil.doPost(this.url, body);
            BaseRspBo baseRspBo = BcmSaasRuUtil.jss(result, BaseRspBo.class);
            if ("0000".equals(baseRspBo.getRespCode())) {
                applyOrderIdList.add(bo.getApplyOrderId());
                continue;
            }
            log.error("\u4e0a\u67b6\u7533\u8bf7\u5355\u5546\u54c1\u5931\u6548\u5931\u8d25{}", (Object)bo.getApplyOrderId());
        }
        if (CollectionUtils.isNotEmpty(applyOrderIdList)) {
            this.updateBatchApplyOrder(applyOrderIdList);
        }
    }

    private void updateBatchApplyOrder(List<Long> applyOrderIdList) {
        BcmUpdateBatchApplyCommodityOrderReqBO bcmUpdateBatchApplyCommodityOrderReqBO = new BcmUpdateBatchApplyCommodityOrderReqBO();
        bcmUpdateBatchApplyCommodityOrderReqBO.setApplyOrderIdList(applyOrderIdList);
        bcmUpdateBatchApplyCommodityOrderReqBO.setUserId(BcmPersonalCommonConstant.DefaultUser.DEFAULT_USER_ID);
        bcmUpdateBatchApplyCommodityOrderReqBO.setUserName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        bcmUpdateBatchApplyCommodityOrderReqBO.setIsPushCommodityPool(BcmPersonalCommonConstant.IsPushCommodityPool.BECAME_INVALID);
        this.bcmUpdateBatchApplyCommodityOrderService.updateBatch(bcmUpdateBatchApplyCommodityOrderReqBO);
    }

    private BcmQueryApplyCommodityOrderListReqBO getBcmQueryApplyCommodityOrderListReqBO() {
        BcmQueryApplyCommodityOrderListReqBO bcmQueryApplyCommodityOrderListReqBO = new BcmQueryApplyCommodityOrderListReqBO();
        bcmQueryApplyCommodityOrderListReqBO.setLastBuyTime(new Date());
        bcmQueryApplyCommodityOrderListReqBO.setApplyOrderStatusList(Arrays.asList(BcmPersonalApplyOrderStatusEnum.IN_REPLY.getStatus(), BcmPersonalApplyOrderStatusEnum.IN_SELECT.getStatus(), BcmPersonalApplyOrderStatusEnum.SELECTED.getStatus(), BcmPersonalApplyOrderStatusEnum.IN_RESULT_APPROVAL.getStatus(), BcmPersonalApplyOrderStatusEnum.FINISH.getStatus()));
        bcmQueryApplyCommodityOrderListReqBO.setIsPushCommodityPool(BcmPersonalCommonConstant.IsPushCommodityPool.PUSHED);
        return bcmQueryApplyCommodityOrderListReqBO;
    }
}

