/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.commodity.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmApproveApplyOrderService;
import com.tydic.bcm.personal.common.api.BcmUpdateFlowTaskService;
import com.tydic.bcm.personal.common.bo.BcmApproveApplyOrderRspBO;
import com.tydic.bcm.personal.common.bo.BcmFlowInstanceBO;
import com.tydic.bcm.personal.common.bo.BcmFlowTaskBO;
import com.tydic.bcm.personal.common.bo.BcmUpdateFlowTaskReqBO;
import com.tydic.bcm.personal.common.bo.BcmUpdateFlowTaskRspBO;
import com.tydic.bcm.personal.constants.BcmFlowTaskStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.saas.personal.commodity.api.BcmSaasApprovalRecallService;
import com.tydic.bcm.saas.personal.commodity.bo.BcmSaasApprovalRecallReqBO;
import com.tydic.bcm.saas.personal.commodity.bo.BcmSaasApprovalRecallRspBO;
import com.tydic.bcm.saas.personal.constant.BcmSaasPersonalCommodityConstant;
import com.tydic.bcm.saas.personal.mq.BpmAuditMessageBO;
import com.tydic.bcm.saas.personal.notice.BcmSaasSendNoticeService;
import com.tydic.osworkflow.approve.ability.EacRuTaskAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacRecallAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacRecallAbilityRspBO;
import com.tydic.osworkflow.approve.ability.bo.EacRuTaskAbilityBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_SAAS_GROUP_DEV/3.0.0/com.tydic.bcm.saas.personal.commodity.api.BcmSaasApprovalRecallService"})
public class BcmSaasApprovalRecallServiceImpl
implements BcmSaasApprovalRecallService {
    private static final Logger log = LoggerFactory.getLogger(BcmSaasApprovalRecallServiceImpl.class);
    @Autowired
    private EacRuTaskAbilityService eacRuTaskAbilityService;
    @Autowired
    private BcmUpdateFlowTaskService updateFlowTaskService;
    @Autowired
    private BcmApproveApplyOrderService bcmApproveApplyOrderService;
    @Autowired
    private BcmSaasSendNoticeService bcmSaasSendNoticeService;

    @Override
    @PostMapping(value={"approvalRecall"})
    public BcmSaasApprovalRecallRspBO approvalRecall(@RequestBody BcmSaasApprovalRecallReqBO reqBO) {
        this.verifyParam(reqBO);
        EacRecallAbilityReqBO recallReqBO = new EacRecallAbilityReqBO();
        recallReqBO.setTaskIdList((List)Lists.newArrayList((Object[])new Long[]{reqBO.getTaskId()}));
        log.info("\u8c03\u7528\u6d41\u7a0b\u4e2d\u5fc3\u5ba1\u6279\u9010\u7ea7\u64a4\u56de\u5165\u53c2\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)recallReqBO));
        EacRecallAbilityRspBO recallRspBO = this.eacRuTaskAbilityService.recall(recallReqBO);
        log.info("\u8c03\u7528\u6d41\u7a0b\u4e2d\u5fc3\u5ba1\u6279\u9010\u7ea7\u64a4\u56de\u51fa\u53c2\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)recallRspBO));
        if (!"0000".equals(recallRspBO.getRespCode())) {
            throw new ZTBusinessException(recallRspBO.getRespDesc());
        }
        Long orderId = Long.valueOf(((EacRuTaskAbilityBO)recallRspBO.getRecallTaskList().get(0)).getBusinessId());
        this.updateFlowTaskStatus(reqBO);
        this.deleteNetFlowTask(reqBO, recallRspBO);
        if (ObjectUtil.isNotEmpty((Object)recallRspBO.getTaskList())) {
            List<BpmAuditMessageBO.TaskListDTO> taskList = this.insertFlowTask(recallRspBO);
            this.bcmSaasSendNoticeService.sendAsyncApplyOrderRevokeNotice(orderId, taskList, reqBO.getUseId(), reqBO.getName());
        }
        return new BcmSaasApprovalRecallRspBO();
    }

    private List<BpmAuditMessageBO.TaskListDTO> insertFlowTask(EacRecallAbilityRspBO recallRspBO) {
        ArrayList<BpmAuditMessageBO.TaskListDTO> taskList = new ArrayList<BpmAuditMessageBO.TaskListDTO>();
        Map<String, List<EacRuTaskAbilityBO>> procInstMap = recallRspBO.getTaskList().stream().collect(Collectors.groupingBy(EacRuTaskAbilityBO::getProcInstId));
        for (String procInstId : procInstMap.keySet()) {
            List<EacRuTaskAbilityBO> ruTaskAbilityBO = procInstMap.get(procInstId);
            BcmFlowInstanceBO bcmFlowInstance = new BcmFlowInstanceBO();
            bcmFlowInstance.setFlowInstId(procInstId);
            bcmFlowInstance.setCurrentNodeCode(ruTaskAbilityBO.get(0).getTacheCode());
            bcmFlowInstance.setCurrentNodeName(ruTaskAbilityBO.get(0).getTacheName());
            bcmFlowInstance.setCurrentNodeStatus(BcmSaasPersonalCommodityConstant.FlowInstanceCurrentNodeStatus.IN_APPROVAL);
            ArrayList<BcmFlowTaskBO> bcmFlowTaskList = new ArrayList<BcmFlowTaskBO>();
            for (EacRuTaskAbilityBO taskBO : ruTaskAbilityBO) {
                BpmAuditMessageBO.TaskListDTO taskDto = new BpmAuditMessageBO.TaskListDTO();
                taskDto.setApproveTaskId(taskBO.getTaskId() + "");
                taskDto.setProcDefKey(taskBO.getProcDefKey());
                BcmFlowTaskBO bcmFlowTask = new BcmFlowTaskBO();
                bcmFlowTask.setTaskId(taskBO.getTaskId() + "");
                bcmFlowTask.setFlowInstId(taskBO.getProcInstId());
                bcmFlowTask.setCurrentNodeCode(taskBO.getTacheCode());
                bcmFlowTask.setCurrentNodeName(taskBO.getTacheName());
                bcmFlowTask.setTaskCreateTime(taskBO.getCreateTime());
                bcmFlowTask.setTaskStatus(BcmFlowTaskStatusEnum.WAIT_APPROVE.getTaskStatus());
                if (taskBO.getUserId() != null) {
                    bcmFlowTask.setPendingAuditUserId(Long.valueOf(taskBO.getUserId()));
                    bcmFlowTask.setPendingAuditUserName(taskBO.getUserName());
                    taskDto.setUserId(Long.valueOf(taskBO.getUserId()));
                    taskDto.setUserName(taskBO.getUserName());
                }
                if (taskBO.getOrgId() != null) {
                    bcmFlowTask.setPendingAuditOrgId(Long.valueOf(taskBO.getOrgId()));
                    bcmFlowTask.setPendingAuditOrgName(taskBO.getOrgName());
                }
                taskList.add(taskDto);
                bcmFlowTaskList.add(bcmFlowTask);
            }
            bcmFlowInstance.setBcmFlowTaskList(bcmFlowTaskList);
            BcmApproveApplyOrderRspBO bcmApproveApplyOrderRspBO = this.bcmApproveApplyOrderService.approveApplyOrder(bcmFlowInstance);
            if ("0000".equals(bcmApproveApplyOrderRspBO.getRespCode())) continue;
            throw new ZTBusinessException(bcmApproveApplyOrderRspBO.getRespDesc());
        }
        return taskList;
    }

    private void deleteNetFlowTask(BcmSaasApprovalRecallReqBO reqBO, EacRecallAbilityRspBO recallRspBO) {
        for (EacRuTaskAbilityBO taskBO : recallRspBO.getRecallTaskList()) {
            BcmUpdateFlowTaskReqBO deleteTaskReqBO = new BcmUpdateFlowTaskReqBO();
            deleteTaskReqBO.setTaskId(taskBO.getTaskId() + "");
            deleteTaskReqBO.setDelFlag(BcmPersonalCommonConstant.DelFlag.YES);
            deleteTaskReqBO.setUpdateUserId(reqBO.getUseId());
            deleteTaskReqBO.setUpdateUserName(reqBO.getName());
            deleteTaskReqBO.setUpdateTime(new Date());
            BcmUpdateFlowTaskRspBO deleteTaskRspBO = this.updateFlowTaskService.updateFlowTask(deleteTaskReqBO);
            if ("0000".equals(deleteTaskRspBO.getRespCode())) continue;
            throw new ZTBusinessException(deleteTaskRspBO.getRespDesc());
        }
    }

    private void updateFlowTaskStatus(BcmSaasApprovalRecallReqBO reqBO) {
        BcmUpdateFlowTaskReqBO taskReqBO = new BcmUpdateFlowTaskReqBO();
        taskReqBO.setTaskId(reqBO.getTaskId() + "");
        taskReqBO.setTaskStatus(BcmFlowTaskStatusEnum.RECALL.getTaskStatus());
        taskReqBO.setUpdateUserId(reqBO.getUseId());
        taskReqBO.setUpdateUserName(reqBO.getName());
        taskReqBO.setUpdateTime(new Date());
        BcmUpdateFlowTaskRspBO taskRspBO = this.updateFlowTaskService.updateFlowTask(taskReqBO);
        if (!"0000".equals(taskRspBO.getRespCode())) {
            throw new ZTBusinessException(taskRspBO.getRespDesc());
        }
    }

    private void verifyParam(BcmSaasApprovalRecallReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5ba1\u6279\u9010\u7ea7\u64a4\u56de\u5165\u53c2\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
            throw new ZTBusinessException("\u5ba1\u6279\u9010\u7ea7\u64a4\u56de\u5165\u53c2\u4efb\u52a1ID\u4e3a\u7a7a");
        }
    }
}

