/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.commodity.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.client.utils.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmQueryApplyOrderService;
import com.tydic.bcm.personal.commodity.api.BcmUpdateBatchApplyCommodityOrderService;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyOrderReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyOrderRspBO;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateBatchApplyCommodityOrderReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateBatchApplyCommodityOrderRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.constants.BcmPersonalFlowConstant;
import com.tydic.bcm.personal.flow.api.BcmCancelFlowService;
import com.tydic.bcm.personal.flow.api.BcmQueryFlowInstanceService;
import com.tydic.bcm.personal.flow.bo.BcmCancelFlowReqBO;
import com.tydic.bcm.personal.flow.bo.BcmCancelFlowRspBO;
import com.tydic.bcm.personal.flow.bo.BcmQueryFlowInstanceReqBO;
import com.tydic.bcm.personal.flow.bo.BcmQueryFlowInstanceRspBO;
import com.tydic.bcm.saas.personal.commodity.api.BcmSaasCancelApplyOrderFlowService;
import com.tydic.bcm.saas.personal.commodity.bo.BcmSaasCancelApplyOrderFlowReqBO;
import com.tydic.bcm.saas.personal.commodity.bo.BcmSaasCancelApplyOrderFlowRspBO;
import com.tydic.bcm.saas.personal.notice.BcmSaasSendTodoService;
import com.tydic.bcm.saas.personal.notice.bo.BcmSaasRevokeTodoBo;
import com.tydic.bcm.saas.personal.utils.BcmSaasRuUtil;
import com.tydic.osworkflow.approve.ability.EacRuTaskAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacApproveForCancelAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacApproveForCancelAbilityRspBO;
import com.tydic.osworkflow.approve.ability.bo.EacApproveForCancelBO;
import com.tydic.osworkflow.approve.ability.bo.EacRuInstAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacRuInstAbilityRspBO;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_SAAS_GROUP_DEV/3.0.0/com.tydic.bcm.saas.personal.commodity.api.BcmSaasCancelApplyOrderFlowService"})
public class BcmSaasCancelApplyOrderFlowServiceImpl
implements BcmSaasCancelApplyOrderFlowService {
    private static final Logger log = LoggerFactory.getLogger(BcmSaasCancelApplyOrderFlowServiceImpl.class);
    @Autowired
    private BcmQueryApplyOrderService bcmQueryApplyOrderService;
    @Autowired
    private BcmQueryFlowInstanceService bcmQueryFlowInstanceService;
    @Autowired
    private BcmCancelFlowService bcmCancelFlowService;
    @Autowired
    private BcmUpdateBatchApplyCommodityOrderService bcmUpdateBatchApplyCommodityOrderService;
    @Autowired
    private EacRuTaskAbilityService eacRuTaskAbilityService;
    @Autowired
    private BcmSaasSendTodoService bcmSaasSendTodoService;
    @Value(value="${APPLY_ORDER_TODO_CODE:APPLY_COMMODITY_ORDER}")
    private String applyOrderTodoCode;

    @Override
    @PostMapping(value={"cancelApplyOrderFlow"})
    public BcmSaasCancelApplyOrderFlowRspBO cancelApplyOrderFlow(@RequestBody BcmSaasCancelApplyOrderFlowReqBO reqBO) {
        BcmQueryApplyOrderRspBO applyOrder = this.getApplyOrder(reqBO);
        if (!BcmPersonalApplyOrderStatusEnum.IN_RESULT_APPROVAL.getStatus().equals(applyOrder.getApplyOrderStatus()) && !BcmPersonalApplyOrderStatusEnum.IN_APPROVAL.getStatus().equals(applyOrder.getApplyOrderStatus())) {
            throw new ZTBusinessException("\u4e0a\u67b6\u7533\u8bf7\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u64a4\u9500");
        }
        BcmQueryFlowInstanceRspBO flowInstance = this.getFlowInstance(reqBO.getApplyOrderId());
        this.queryApproveForCancel(flowInstance);
        if (BcmPersonalApplyOrderStatusEnum.IN_APPROVAL.getStatus().equals(applyOrder.getApplyOrderStatus())) {
            this.updateApplyOrder(reqBO, BcmPersonalApplyOrderStatusEnum.DRAFT.getStatus());
        } else if (BcmPersonalApplyOrderStatusEnum.IN_RESULT_APPROVAL.getStatus().equals(applyOrder.getApplyOrderStatus())) {
            this.updateApplyOrder(reqBO, BcmPersonalApplyOrderStatusEnum.IN_SELECT.getStatus());
        }
        this.revokeTodo(reqBO);
        this.cancelFlow(flowInstance);
        return BcmSaasRuUtil.success(BcmSaasCancelApplyOrderFlowRspBO.class);
    }

    private void revokeTodo(BcmSaasCancelApplyOrderFlowReqBO reqBO) {
        BcmSaasRevokeTodoBo bcmSaasRevokeTodoBo = new BcmSaasRevokeTodoBo();
        bcmSaasRevokeTodoBo.setBusiId(reqBO.getApplyOrderId().toString());
        bcmSaasRevokeTodoBo.setOperUserName(reqBO.getName());
        bcmSaasRevokeTodoBo.setOperUserId(reqBO.getUserId());
        this.bcmSaasSendTodoService.revokeTodo(bcmSaasRevokeTodoBo);
    }

    private void queryApproveForCancel(BcmQueryFlowInstanceRspBO flowInstance) {
        EacApproveForCancelAbilityReqBO eacApproveForCancelAbilityReqBO = new EacApproveForCancelAbilityReqBO();
        eacApproveForCancelAbilityReqBO.setApproveInstIdList(Collections.singletonList(flowInstance.getFlowInstId()));
        EacApproveForCancelAbilityRspBO eacApproveForCancelAbilityRspBO = this.eacRuTaskAbilityService.queryApproveForCancel(eacApproveForCancelAbilityReqBO);
        log.info("\u67e5\u8be2\u6d41\u7a0b\u4e2d\u5fc3\u6d41\u7a0b\u662f\u5426\u53ef\u64a4\u9500\u5165\u53c2{},\u51fa\u53c2{}", (Object)JSONObject.toJSONString((Object)eacApproveForCancelAbilityReqBO), (Object)JSONObject.toJSONString((Object)eacApproveForCancelAbilityRspBO));
        if (!"0000".equals(eacApproveForCancelAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException(eacApproveForCancelAbilityRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)eacApproveForCancelAbilityRspBO.getApproveInstList()) || !((EacApproveForCancelBO)eacApproveForCancelAbilityRspBO.getApproveInstList().get(0)).getEnableCancel().booleanValue()) {
            throw new ZTBusinessException("\u6d41\u7a0b\u4e0d\u5141\u8bb8\u64a4\u9500");
        }
    }

    private void cancelFlow(BcmQueryFlowInstanceRspBO flowInstance) {
        BcmCancelFlowReqBO bcmCancelFlowReqBO = new BcmCancelFlowReqBO();
        bcmCancelFlowReqBO.setFlowInstId(flowInstance.getFlowInstId());
        BcmCancelFlowRspBO bcmCancelFlowRspBO = this.bcmCancelFlowService.cancelFlow(bcmCancelFlowReqBO);
        if (!"0000".equals(bcmCancelFlowRspBO.getRespCode())) {
            throw new ZTBusinessException(bcmCancelFlowRspBO.getRespDesc());
        }
        EacRuInstAbilityReqBO eacRuInstAbilityReqBO = new EacRuInstAbilityReqBO();
        eacRuInstAbilityReqBO.setApproveInstId(flowInstance.getFlowInstId());
        EacRuInstAbilityRspBO eacRuInstAbilityRspBO = this.eacRuTaskAbilityService.suspensionApprove(eacRuInstAbilityReqBO);
        log.info("\u6d41\u7a0b\u4e2d\u5fc3\u6d41\u7a0b\u64a4\u9500\u5165\u53c2{},\u51fa\u53c2{}", (Object)JSONObject.toJSONString((Object)eacRuInstAbilityReqBO), (Object)JSONObject.toJSONString((Object)eacRuInstAbilityRspBO));
        if (!"0000".equals(eacRuInstAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException(eacRuInstAbilityRspBO.getRespDesc());
        }
    }

    private void updateApplyOrder(BcmSaasCancelApplyOrderFlowReqBO reqBO, Integer applyOrderStatus) {
        BcmUpdateBatchApplyCommodityOrderReqBO bcmUpdateBatchApplyCommodityOrderReqBO = new BcmUpdateBatchApplyCommodityOrderReqBO();
        bcmUpdateBatchApplyCommodityOrderReqBO.setApplyOrderIdList(Collections.singletonList(reqBO.getApplyOrderId()));
        bcmUpdateBatchApplyCommodityOrderReqBO.setUserId(reqBO.getUserId());
        bcmUpdateBatchApplyCommodityOrderReqBO.setUserName(reqBO.getName());
        bcmUpdateBatchApplyCommodityOrderReqBO.setApplyOrderStatus(applyOrderStatus);
        BcmUpdateBatchApplyCommodityOrderRspBO bcmUpdateBatchApplyCommodityOrderRspBO = this.bcmUpdateBatchApplyCommodityOrderService.updateBatch(bcmUpdateBatchApplyCommodityOrderReqBO);
        if (!"0000".equals(bcmUpdateBatchApplyCommodityOrderRspBO.getRespCode())) {
            throw new ZTBusinessException(bcmUpdateBatchApplyCommodityOrderRspBO.getRespDesc());
        }
    }

    private BcmQueryFlowInstanceRspBO getFlowInstance(Long objId) {
        BcmQueryFlowInstanceReqBO bcmQueryFlowInstanceReqBO = new BcmQueryFlowInstanceReqBO();
        bcmQueryFlowInstanceReqBO.setObjId(objId);
        bcmQueryFlowInstanceReqBO.setObjType(BcmPersonalFlowConstant.ObjType.APPLY_ORDER);
        bcmQueryFlowInstanceReqBO.setIsFinish(BcmPersonalFlowConstant.IsFinish.NO);
        bcmQueryFlowInstanceReqBO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        BcmQueryFlowInstanceRspBO bcmQueryFlowInstanceRspBO = this.bcmQueryFlowInstanceService.queryFlowInstance(bcmQueryFlowInstanceReqBO);
        if (!"0000".equals(bcmQueryFlowInstanceRspBO.getRespCode())) {
            throw new ZTBusinessException(bcmQueryFlowInstanceRspBO.getRespDesc());
        }
        if (StringUtils.isBlank((String)bcmQueryFlowInstanceRspBO.getFlowInstId())) {
            throw new ZTBusinessException("\u6d41\u7a0b\u5b9e\u4f8bid\u4e3anull");
        }
        return bcmQueryFlowInstanceRspBO;
    }

    private BcmQueryApplyOrderRspBO getApplyOrder(BcmSaasCancelApplyOrderFlowReqBO reqBO) {
        BcmQueryApplyOrderReqBO bcmQueryApplyOrderReqBO = new BcmQueryApplyOrderReqBO();
        bcmQueryApplyOrderReqBO.setApplyOrderId(reqBO.getApplyOrderId());
        BcmQueryApplyOrderRspBO bcmQueryApplyOrderRspBO = this.bcmQueryApplyOrderService.queryApplyOrder(bcmQueryApplyOrderReqBO);
        if (!"0000".equals(bcmQueryApplyOrderRspBO.getRespCode())) {
            throw new ZTBusinessException(bcmQueryApplyOrderRspBO.getRespDesc());
        }
        return bcmQueryApplyOrderRspBO;
    }
}

