/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.saas.personal.common.api.BcmSaasDealOrderBudgetOccupyResultService;
import com.tydic.bcm.saas.personal.common.bo.BcmSaasDealOrderBudgetOccupyResultReqBO;
import com.tydic.bcm.saas.personal.common.bo.BcmSaasDealOrderBudgetOccupyResultRspBO;
import com.tydic.bcm.saas.personal.utils.BcmSaasHttpUtil;
import com.tydic.bcm.saas.personal.utils.BcmSaasRuUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_SAAS_GROUP_DEV/3.0.0/com.tydic.bcm.saas.personal.common.api.BcmSaasDealOrderBudgetOccupyResultService"})
public class BcmSaasDealOrderBudgetOccupyResultServiceImpl
implements BcmSaasDealOrderBudgetOccupyResultService {
    private static final Logger log = LoggerFactory.getLogger(BcmSaasDealOrderBudgetOccupyResultServiceImpl.class);
    @Value(value="${DEAL_ORDER_BUDGET_OCCUPY_RESULT_URL:}")
    private String dealOrderBudgetOccupyResultUrl;
    @Value(value="${CANCEL_ORDER_BUDGET_URL:}")
    private String cancelOrderBudgetUrl;

    @Override
    @PostMapping(value={"dealOrderBudgetOccupyResult"})
    public BcmSaasDealOrderBudgetOccupyResultRspBO dealOrderBudgetOccupyResult(@RequestBody BcmSaasDealOrderBudgetOccupyResultReqBO reqBO) {
        this.verifyParam(reqBO);
        switch (reqBO.getOrderBudgetType()) {
            case "1": 
            case "2": {
                this.dealOrderBudget(reqBO);
                break;
            }
            case "3": 
            case "4": {
                this.cancelOrderBudget(reqBO);
                break;
            }
            default: {
                throw new ZTBusinessException("\u672a\u77e5\u7684\u8ba2\u5355\u9884\u7b97\u4ea4\u6613\u7c7b\u578b");
            }
        }
        return BcmSaasRuUtil.success(BcmSaasDealOrderBudgetOccupyResultRspBO.class);
    }

    private void verifyParam(BcmSaasDealOrderBudgetOccupyResultReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5904\u7406\u8ba2\u5355\u9884\u7b97\u5360\u7528\u7ed3\u679c\u5165\u53c2\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getOrderId())) {
            throw new ZTBusinessException("\u5165\u53c2\u5546\u57ce\u91c7\u8d2d\u8ba2\u5355id\u4e0d\u80fd\u4e3anull");
        }
        if (StringUtils.isBlank((String)reqBO.getResult())) {
            throw new ZTBusinessException("\u5165\u53c2\u5360\u7528\u7ed3\u679c\u4e0d\u80fd\u4e3anull");
        }
        if (StringUtils.isBlank((String)reqBO.getOrderBudgetType())) {
            throw new ZTBusinessException("\u5165\u53c2\u8ba2\u5355\u9884\u7b97\u4ea4\u6613\u7c7b\u578b\u4e0d\u80fd\u4e3anull");
        }
    }

    private void dealOrderBudget(BcmSaasDealOrderBudgetOccupyResultReqBO reqBO) {
        JSONObject req = new JSONObject();
        req.put("saleOrderId", (Object)reqBO.getOrderId());
        req.put("takeUpBudgetResult", (Object)this.getResult(reqBO.getResult()));
        req.put("payStatus", (Object)reqBO.getOrderBudgetType());
        log.info("\u8c03\u7528\u4ea7\u54c1\u5904\u7406\u8ba2\u5355\u9884\u7b97\u5360\u7528\u7ed3\u679c\u5165\u53c2\u4e3a\uff1a{}", (Object)req);
        String result = BcmSaasHttpUtil.doPost(this.dealOrderBudgetOccupyResultUrl, req.toJSONString());
        log.info("\u8c03\u7528\u4ea7\u54c1\u5904\u7406\u8ba2\u5355\u9884\u7b97\u5360\u7528\u7ed3\u679c\u51fa\u53c2\u4e3a\uff1a{}", (Object)result);
        if (StringUtils.isBlank((String)result)) {
            throw new ZTBusinessException("\u8c03\u7528\u4ea7\u54c1\u5904\u7406\u8ba2\u5355\u9884\u7b97\u5360\u7528\u7ed3\u679c\u62a5\u9519");
        }
        JSONObject rspJson = JSONObject.parseObject((String)result);
        if (!"0".equals(rspJson.getString("code"))) {
            throw new ZTBusinessException("\u8c03\u7528\u4ea7\u54c1\u5904\u7406\u8ba2\u5355\u9884\u7b97\u5360\u7528\u7ed3\u679c\u62a5\u9519:" + rspJson.getString("respDesc"));
        }
    }

    private void cancelOrderBudget(BcmSaasDealOrderBudgetOccupyResultReqBO reqBO) {
        JSONObject req = new JSONObject();
        req.put("saleOrderId", (Object)reqBO.getOrderId());
        req.put("cancelResult", (Object)this.getResult(reqBO.getResult()));
        if ("3".equals(reqBO.getOrderBudgetType())) {
            req.put("cancelResultType", (Object)"1");
        } else {
            req.put("cancelResultType", (Object)"2");
        }
        log.info("\u8c03\u7528\u4ea7\u54c1\u8ba2\u5355\u9884\u7b97\u53d6\u6d88\u5165\u53c2\u4e3a\uff1a{}", (Object)req);
        String result = BcmSaasHttpUtil.doPost(this.cancelOrderBudgetUrl, req.toJSONString());
        log.info("\u8c03\u7528\u4ea7\u54c1\u8ba2\u5355\u9884\u7b97\u53d6\u6d88\u51fa\u53c2\u4e3a\uff1a{}", (Object)result);
        if (StringUtils.isBlank((String)result)) {
            throw new ZTBusinessException("\u8c03\u7528\u4ea7\u54c1\u8ba2\u5355\u9884\u7b97\u53d6\u6d88\u62a5\u9519");
        }
        JSONObject rspJson = JSONObject.parseObject((String)result);
        if (!"0".equals(rspJson.getString("code"))) {
            throw new ZTBusinessException("\u8c03\u7528\u4ea7\u54c1\u8ba2\u5355\u9884\u7b97\u53d6\u6d88\u62a5\u9519:" + rspJson.getString("respDesc"));
        }
    }

    private Boolean getResult(String result) {
        return "success".equals(result);
    }
}

