/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.common.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmQueryAuditOrgListService;
import com.tydic.bcm.personal.common.bo.BcmAuditOrgBO;
import com.tydic.bcm.personal.common.bo.BcmQueryAuditOrgListReqBO;
import com.tydic.bcm.personal.common.bo.BcmQueryAuditOrgListRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.saas.personal.common.api.BcmSaasQueryAuditUserListService;
import com.tydic.bcm.saas.personal.common.bo.BcmSaasQueryAuditUserListReqBO;
import com.tydic.bcm.saas.personal.common.bo.BcmSaasQueryAuditUserListRspBO;
import com.tydic.bcm.saas.personal.utils.BcmSaasHttpUtil;
import com.tydic.bcm.saas.personal.utils.BcmSaasRuUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_SAAS_GROUP_DEV/3.0.0/com.tydic.bcm.saas.personal.common.api.BcmSaasQueryAuditUserListService"})
public class BcmSaasQueryAuditUserListServiceImpl
implements BcmSaasQueryAuditUserListService {
    @Autowired
    private BcmQueryAuditOrgListService bundleQueryAuditOrgListService;
    @Value(value="${QUERY_AUDIT_USER_URL:}")
    private String queryAuditUserUrl;

    @Override
    @PostMapping(value={"queryAuditUserList"})
    public BcmSaasQueryAuditUserListRspBO queryAuditUserList(@RequestBody BcmSaasQueryAuditUserListReqBO reqBO) {
        this.verifyParam(reqBO);
        JSONObject jsonObject = new JSONObject();
        switch (reqBO.getTabId()) {
            case 1001: {
                jsonObject.put("orgId", (Object)reqBO.getOrgId());
                break;
            }
            case 1002: {
                jsonObject.put("lvOrgIdList", this.getAuditOrgIdList());
                break;
            }
            case 1003: {
                List<BcmAuditOrgBO> auditOrgBOList = this.getAuditOrgList();
                jsonObject.put("lvOrgIdList", auditOrgBOList.stream().map(BcmAuditOrgBO::getOrgId).collect(Collectors.toList()));
                jsonObject.put("roleIdList", Collections.singletonList(auditOrgBOList.get(0).getRoleId()));
                break;
            }
            default: {
                throw new ZTBusinessException("\u672a\u77e5\u7684TabId");
            }
        }
        return this.queryAuditUserList(jsonObject);
    }

    private void verifyParam(BcmSaasQueryAuditUserListReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getTabId() == null) {
            throw new ZTBusinessException("\u5165\u53c2tabId\u4e0d\u80fd\u4e3anull");
        }
    }

    private BcmSaasQueryAuditUserListRspBO queryAuditUserList(JSONObject jsonObject) {
        jsonObject.put("levelFlag", (Object)2);
        jsonObject.put("returnRoleEnable", (Object)"1");
        jsonObject.put("pageNo", (Object)-1);
        jsonObject.put("pageSize", (Object)-1);
        String result = BcmSaasHttpUtil.doPost(this.queryAuditUserUrl, jsonObject.toJSONString());
        if (StringUtils.isBlank((String)result)) {
            throw new ZTBusinessException("\u8c03\u7528\u4ea7\u54c1\u67e5\u8be2\u5ba1\u6279\u4eba\u5217\u8868\u5931\u8d25");
        }
        JSONObject rspJson = JSONObject.parseObject((String)result);
        if (!"0".equals(rspJson.get((Object)"code"))) {
            throw new ZTBusinessException(rspJson.get((Object)"message").toString());
        }
        BcmSaasQueryAuditUserListRspBO rspBO = BcmSaasRuUtil.jss(rspJson.get((Object)"data").toString(), BcmSaasQueryAuditUserListRspBO.class);
        return rspBO;
    }

    private List<BcmAuditOrgBO> getAuditOrgList() {
        BcmQueryAuditOrgListReqBO bcmQueryAuditOrgListReqBO = new BcmQueryAuditOrgListReqBO();
        bcmQueryAuditOrgListReqBO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        bcmQueryAuditOrgListReqBO.setGroupBy("ORG_ID");
        BcmQueryAuditOrgListRspBO bcmQueryAuditOrgListRspBO = this.bundleQueryAuditOrgListService.queryAuditOrgList(bcmQueryAuditOrgListReqBO);
        if (!"0000".equals(bcmQueryAuditOrgListRspBO.getRespCode())) {
            throw new ZTBusinessException(bcmQueryAuditOrgListRspBO.getRespDesc());
        }
        if (CollectionUtil.isEmpty((Collection)bcmQueryAuditOrgListRspBO.getRows())) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u5ba1\u6279\u7ec4\u7ec7\u4fe1\u606f");
        }
        return bcmQueryAuditOrgListRspBO.getRows();
    }

    private List<Long> getAuditOrgIdList() {
        List<BcmAuditOrgBO> auditOrgList = this.getAuditOrgList();
        Set auditOrgIdSet = auditOrgList.stream().map(BcmAuditOrgBO::getOrgId).collect(Collectors.toSet());
        return new ArrayList<Long>(auditOrgIdSet);
    }
}

