/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.product.ext.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmQueryAuditOrgListService;
import com.tydic.bcm.personal.common.bo.BcmAuditOrgBO;
import com.tydic.bcm.personal.common.bo.BcmQueryAuditOrgListReqBO;
import com.tydic.bcm.personal.common.bo.BcmQueryAuditOrgListRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.constants.BcmPersonalCommonStatusEnum;
import com.tydic.bcm.saas.personal.constant.BcmSaasPersonalCommonConstant;
import com.tydic.bcm.saas.personal.product.ext.api.BcmUocOrderAuditService;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmRoleBO;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmUocOrderAuditInfoBO;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmUocOrderAuditReqBO;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmUocOrderAuditRspBO;
import com.tydic.bcm.saas.personal.utils.BcmSaasHttpUtil;
import com.tydic.bcm.saas.personal.utils.BcmSaasRuUtil;
import com.tydic.osworkflow.approve.ability.EacQueryOperationRecordsListAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacOperationRecordsInfoAbilityBO;
import com.tydic.osworkflow.approve.ability.bo.EacQueryOperationRecordsListAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacQueryOperationRecordsListAbilityRspBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_SAAS_GROUP_DEV/3.0.0/com.tydic.bcm.saas.personal.product.ext.api.BcmUocOrderAuditService"})
public class BcmUocOrderAuditServiceImpl
implements BcmUocOrderAuditService {
    private static final Logger log = LoggerFactory.getLogger(BcmUocOrderAuditServiceImpl.class);
    @Value(value="${DEAL_ORDER_AUDIT_URL:}")
    private String dealOrderAuditUrl;
    @Value(value="${AUDIT_ORDER_KEY:}")
    private String auditOrderKey;
    @Value(value="${QUERY_USER_URL:}")
    private String queryUserUrl;
    @Autowired
    private EacQueryOperationRecordsListAbilityService ecQueryOperationRecordsListAbilityService;
    @Autowired
    private BcmQueryAuditOrgListService bcmQueryAuditOrgListService;

    @Override
    @PostMapping(value={"dealOrderAudit"})
    public BcmUocOrderAuditRspBO dealOrderAudit(@RequestBody BcmUocOrderAuditReqBO reqBO) {
        log.info("\u8ba2\u5355\u5ba1\u6279\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)((Object)reqBO)));
        if (BcmPersonalCommonStatusEnum.YES.getStatus().equals(reqBO.getIsCountersign()) || BcmSaasPersonalCommonConstant.AuditResult.PASS.equals(reqBO.getAuditResult())) {
            return this.auditOrder(reqBO);
        }
        Long roleId = this.getRole();
        if (!reqBO.getRoleIdListIn().contains(roleId)) {
            HashMap<String, List> roleIdMap = new HashMap<String, List>();
            for (BcmUocOrderAuditInfoBO bcmUocOrderAuditInfo : reqBO.getOrderAuditInfoBos()) {
                EacQueryOperationRecordsListAbilityReqBO eacQueryOperationRecordsListAbilityReqBO = new EacQueryOperationRecordsListAbilityReqBO();
                eacQueryOperationRecordsListAbilityReqBO.setBusinessId(bcmUocOrderAuditInfo.getAuditOrderId());
                eacQueryOperationRecordsListAbilityReqBO.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
                eacQueryOperationRecordsListAbilityReqBO.setPageNo(Integer.valueOf(1));
                eacQueryOperationRecordsListAbilityReqBO.setProcDefKey(this.auditOrderKey);
                EacQueryOperationRecordsListAbilityRspBO eacQueryOperationRecordsListAbilityRspBO = this.ecQueryOperationRecordsListAbilityService.queryOperationRecordsList(eacQueryOperationRecordsListAbilityReqBO);
                log.info("\u8ba2\u5355\u64cd\u4f5c\u8bb0\u5f55\u67e5\u8be2\u5165\u53c2{}\u51fa\u53c2{}", (Object)JSONObject.toJSONString((Object)eacQueryOperationRecordsListAbilityReqBO), (Object)JSONObject.toJSONString((Object)eacQueryOperationRecordsListAbilityRspBO));
                if (!"0000".equals(eacQueryOperationRecordsListAbilityRspBO.getRespCode())) {
                    throw new ZTBusinessException(eacQueryOperationRecordsListAbilityRspBO.getRespDesc());
                }
                if (CollectionUtil.isEmpty((Collection)eacQueryOperationRecordsListAbilityRspBO.getRows())) {
                    throw new ZTBusinessException("\u9700\u8981\u6709\u5173\u952e\u5ba1\u6279\u4eba\u5ba1\u6279\u624d\u80fd\u901a\u8fc7");
                }
                boolean isCrux = false;
                for (EacOperationRecordsInfoAbilityBO bo : eacQueryOperationRecordsListAbilityRspBO.getRows()) {
                    List<Object> roleIdList;
                    if (StringUtils.isBlank((String)bo.getRoleId())) {
                        if (roleIdMap.containsKey(bo.getUserId())) {
                            roleIdList = (List<Long>)roleIdMap.get(bo.getUserId());
                        } else {
                            roleIdList = this.getRole(bo.getUserId());
                            if (!CollectionUtil.isEmpty((Collection)roleIdList)) {
                                roleIdMap.put(bo.getUserId(), roleIdList);
                            }
                        }
                        if (!roleIdList.contains(roleId)) continue;
                        isCrux = true;
                        break;
                    }
                    roleIdList = Arrays.asList(bo.getRoleId().split(","));
                    if (!roleIdList.contains(String.valueOf(roleId))) continue;
                    isCrux = true;
                    break;
                }
                if (isCrux) continue;
                throw new ZTBusinessException("\u8ba2\u5355" + bcmUocOrderAuditInfo.getOrderId() + "\u9700\u8981\u6709\u5173\u952e\u5ba1\u6279\u4eba\u5ba1\u6279\u624d\u80fd\u901a\u8fc7");
            }
        }
        return this.auditOrder(reqBO);
    }

    private BcmUocOrderAuditRspBO auditOrder(BcmUocOrderAuditReqBO reqBO) {
        String result = BcmSaasHttpUtil.doPost(this.dealOrderAuditUrl, JSONObject.toJSONString((Object)((Object)reqBO)));
        if (StringUtils.isBlank((String)result)) {
            throw new ZTBusinessException("\u8c03\u7528\u5546\u57ce\u8ba2\u5355\u5ba1\u6279\u5931\u8d25");
        }
        JSONObject rspJson = JSONObject.parseObject((String)result);
        if (!"0".equals(rspJson.get((Object)"code").toString())) {
            throw new ZTBusinessException(rspJson.get((Object)"message").toString());
        }
        BcmUocOrderAuditRspBO rspBO = BcmSaasRuUtil.jss(rspJson.get((Object)"data").toString(), BcmUocOrderAuditRspBO.class);
        return rspBO;
    }

    private Long getRole() {
        BcmQueryAuditOrgListReqBO bcmQueryAuditOrgListReqBO = new BcmQueryAuditOrgListReqBO();
        bcmQueryAuditOrgListReqBO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        bcmQueryAuditOrgListReqBO.setGroupBy("ROLE_ID");
        BcmQueryAuditOrgListRspBO bcmQueryAuditOrgListRspBO = this.bcmQueryAuditOrgListService.queryAuditOrgList(bcmQueryAuditOrgListReqBO);
        if (!"0000".equals(bcmQueryAuditOrgListRspBO.getRespCode())) {
            throw new ZTBusinessException(bcmQueryAuditOrgListRspBO.getRespDesc());
        }
        if (CollectionUtil.isEmpty((Collection)bcmQueryAuditOrgListRspBO.getRows())) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u5ba1\u6279\u7ec4\u7ec7\u4fe1\u606f");
        }
        return ((BcmAuditOrgBO)bcmQueryAuditOrgListRspBO.getRows().get(0)).getRoleId();
    }

    private List<Long> getRole(String userId) {
        JSONObject reqJSONObject = new JSONObject();
        reqJSONObject.put("memIdList", Collections.singletonList(userId));
        reqJSONObject.put("returnRoleEnable", (Object)"1");
        String result = BcmSaasHttpUtil.doPost(this.queryUserUrl, reqJSONObject.toJSONString());
        if (StringUtils.isEmpty((String)result)) {
            throw new ZTBusinessException("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        JSONObject rspJson = JSONObject.parseObject((String)result);
        if (!"0".equals(rspJson.getString("code"))) {
            throw new ZTBusinessException(rspJson.getString("message"));
        }
        List<BcmRoleBO> roleList = BcmSaasRuUtil.jsl(rspJson.getJSONObject("data").getJSONArray("rows").getJSONObject(0).getString("sysRoleBoList"), BcmRoleBO.class);
        if (CollectionUtil.isEmpty(roleList)) {
            return new ArrayList<Long>();
        }
        return roleList.stream().map(BcmRoleBO::getRoleId).collect(Collectors.toList());
    }
}

