/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.product.ext.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmOutSendEvaInfoToZcPlatformServiceReqBo;
import com.tydic.bcm.saas.personal.utils.BcmSaasHttpUtil;
import com.tydic.bcm.saas.personal.utils.BcmSaasRuUtil;
import com.tydic.dyc.base.bo.BaseRspBo;
import com.tydic.dyc.saas.uoc.api.DycSendEvaInfoToZcPlatformServiceExtPt;
import com.tydic.dyc.saas.uoc.bo.DycSendEvaInfoToZcPlatformServiceReqBo;
import com.tydic.dyc.saas.uoc.bo.DycSendEvaInfoToZcPlatformServiceRspBo;
import com.tydic.dyc.saas.uoc.bo.DycUocSaleOrderEvaObjInfoBO;
import com.tydic.dyc.saas.uoc.bo.DycUocSaleOrderEvaStarLevelBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.saas.uoc.api.DycSendEvaInfoToZcPlatformServiceExtPt"})
public class DycSendEvaInfoToZcPlatformServiceImpl
implements DycSendEvaInfoToZcPlatformServiceExtPt {
    private static final Logger log = LoggerFactory.getLogger(DycSendEvaInfoToZcPlatformServiceImpl.class);
    @Value(value="${ORDER_EVA_URL:url}")
    private String url;
    @Value(value="${QUERY_ORG_URL:}")
    private String queryOrgUrl;

    @PostMapping(value={"syncEvaInfo"})
    public DycSendEvaInfoToZcPlatformServiceRspBo syncEvaInfo(@RequestBody DycSendEvaInfoToZcPlatformServiceReqBo reqBo) {
        this.verifyParam(reqBo);
        this.toZcPlatform(reqBo);
        return BcmSaasRuUtil.success(DycSendEvaInfoToZcPlatformServiceRspBo.class);
    }

    private void toZcPlatform(DycSendEvaInfoToZcPlatformServiceReqBo reqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getObjInfoList())) {
            Map<Long, JSONObject> orgMap = this.getSupplierList(null);
            for (DycUocSaleOrderEvaObjInfoBO evaObjInfo : reqBO.getObjInfoList()) {
                BcmOutSendEvaInfoToZcPlatformServiceReqBo outSendEvaInfo = new BcmOutSendEvaInfoToZcPlatformServiceReqBo();
                outSendEvaInfo.setOrderNo(evaObjInfo.getObjId());
                JSONObject orgJson = orgMap.get(null);
                outSendEvaInfo.setBeEvaluatedUserId(orgJson.getString("creditNo"));
                outSendEvaInfo.setBeEvaluatedUserName(orgJson.getString("orgName"));
                if (!CollectionUtils.isEmpty((Collection)evaObjInfo.getStarLevelList())) {
                    BigDecimal sum = BigDecimal.ZERO;
                    for (DycUocSaleOrderEvaStarLevelBO evaStarLevel : evaObjInfo.getStarLevelList()) {
                        sum = sum.add(new BigDecimal(evaStarLevel.getLevelValue()));
                    }
                    outSendEvaInfo.setTotalScore(sum.divide(new BigDecimal(evaObjInfo.getStarLevelList().size()), RoundingMode.HALF_DOWN).toString());
                } else {
                    outSendEvaInfo.setTotalScore("0");
                }
                String body = JSONObject.toJSONString((Object)outSendEvaInfo);
                String result = BcmSaasHttpUtil.doPost(this.url, body);
                if (!StringUtils.isBlank((String)result)) {
                    BaseRspBo baseRspBo = BcmSaasRuUtil.jss(result, BaseRspBo.class);
                    if ("0".equals(baseRspBo.getCode())) continue;
                    log.error("\u8bc4\u4ef7\u4fe1\u606f\u540c\u6b65\u5230\u667a\u91c7\u5e73\u53f0\u5931\u8d25\u5165\u53c2{},\u51fa\u53c2{}", (Object)result, (Object)body);
                    throw new ZTBusinessException("\u8bc4\u4ef7\u4fe1\u606f\u540c\u6b65\u5230\u667a\u91c7\u5e73\u53f0\u5931\u8d25");
                }
                log.error("\u8bc4\u4ef7\u4fe1\u606f\u540c\u6b65\u5230\u667a\u91c7\u5e73\u53f0\u5931\u8d25\u5165\u53c2{}", (Object)body);
                throw new ZTBusinessException("\u8bc4\u4ef7\u4fe1\u606f\u540c\u6b65\u5230\u667a\u91c7\u5e73\u53f0\u5931\u8d25");
            }
        }
    }

    private void verifyParam(DycSendEvaInfoToZcPlatformServiceReqBo reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getObjInfoList())) {
            throw new ZTBusinessException("\u5165\u53c2\u9700\u8981\u540c\u6b65\u7684\u5355\u636e\u8bc4\u4ef7\u4fe1\u606f\u4e0d\u80fd\u4e3anull");
        }
        for (DycUocSaleOrderEvaObjInfoBO dycUocSaleOrderEvaObjInfoBO : reqBO.getObjInfoList()) {
            if (!StringUtils.isBlank((String)dycUocSaleOrderEvaObjInfoBO.getOrderId())) continue;
            throw new ZTBusinessException("\u5165\u53c2\u8ba2\u5355id\u4e0d\u80fd\u4e3anull");
        }
    }

    private Map<Long, JSONObject> getSupplierList(List<String> orgIdList) {
        JSONObject reqjsonObject = new JSONObject();
        reqjsonObject.put("orgIdList", orgIdList);
        String result = BcmSaasHttpUtil.doPost(this.queryOrgUrl, reqjsonObject.toJSONString());
        if (StringUtils.isEmpty((String)result)) {
            throw new ZTBusinessException("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
        }
        JSONObject rspJson = JSONObject.parseObject((String)result);
        if (!"0".equals(rspJson.getString("code"))) {
            throw new ZTBusinessException(rspJson.getString("message"));
        }
        List<JSONObject> umcOrgInfoExtBoList = BcmSaasRuUtil.jsl(rspJson.get((Object)"umcOrgInfoExtBoList"), JSONObject.class);
        if (CollectionUtils.isEmpty(umcOrgInfoExtBoList)) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u4fe1\u606f");
        }
        HashMap<Long, JSONObject> map = new HashMap<Long, JSONObject>();
        for (JSONObject data : umcOrgInfoExtBoList) {
            map.put(data.getLong("orgId"), data);
        }
        return map;
    }
}

