/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.product.ext.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.saas.personal.constant.BcmSaasPersonalCommonConstant;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmGetOutIdInfoByInnerIdRspBo;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmOrgInfoExtBo;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmUserInfoExtBo;
import com.tydic.bcm.saas.personal.utils.BcmSaasHttpUtil;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.saas.uoc.api.DycUocOrderTakeUpBudgetServiceExtPt;
import com.tydic.dyc.saas.uoc.bo.DycUocOrderTakeUpBudgetCommodityInfoBO;
import com.tydic.dyc.saas.uoc.bo.DycUocOrderTakeUpBudgetServiceExtReqBo;
import com.tydic.dyc.saas.uoc.bo.DycUocOrderTakeUpBudgetServiceExtRspBo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.saas.uoc.api.DycUocOrderTakeUpBudgetServiceExtPt"})
public class DycUocOrderTakeUpBudgetServiceExtPtImpl
implements DycUocOrderTakeUpBudgetServiceExtPt {
    private static final Logger log = LoggerFactory.getLogger(DycUocOrderTakeUpBudgetServiceExtPtImpl.class);
    @Value(value="${OCCUPY_BUDGET_URL:}")
    private String occupyBudgetUrl;
    @Value(value="${GET_OUT_INFO_URL:}")
    private String getOutInfoUrl;
    @Value(value="${takeUpBudget.verifyParam.switch:}")
    private Boolean verifyParamSwitch;
    @Value(value="${takeUpBudget.skipCode:}")
    private String skipCode;
    private static final String SUCCESS = "0";

    @PostMapping(value={"takeUpBudget"})
    public DycUocOrderTakeUpBudgetServiceExtRspBo takeUpBudget(@RequestBody DycUocOrderTakeUpBudgetServiceExtReqBo reqBO) {
        log.info("\u8ba2\u5355\u9884\u7b97\u91ca\u653e\u670d\u52a1API\u6269\u5c55\u5b9e\u73b0\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        if (this.verifyParamSwitch.booleanValue()) {
            log.info("\u6821\u9a8c\u53c2\u6570");
            this.verifyParam(reqBO);
        }
        DycUocOrderTakeUpBudgetServiceExtRspBo rspBo = new DycUocOrderTakeUpBudgetServiceExtRspBo();
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        ArrayList<String> extCustIdList = new ArrayList<String>();
        HashMap<String, BcmOrgInfoExtBo> orgMap = new HashMap();
        HashMap<String, BcmUserInfoExtBo> extCustToMap = new HashMap();
        BcmGetOutIdInfoByInnerIdRspBo innerIdRspBo = this.changeUmcData(reqBO, extCustIdList, orgIdList);
        if (ObjectUtil.isNotEmpty(innerIdRspBo.getUmcOrgInfoExtBoList())) {
            orgMap = innerIdRspBo.getUmcOrgInfoExtBoList().stream().collect(Collectors.toMap(item -> item.getOrgId() + "", Function.identity()));
        }
        if (ObjectUtil.isNotEmpty(innerIdRspBo.getUmcUserInfoExtBoList())) {
            extCustToMap = innerIdRspBo.getUmcUserInfoExtBoList().stream().collect(Collectors.toMap(BcmUserInfoExtBo::getExtCustId, Function.identity()));
        }
        log.info("orgMap:{},extCustToMap:{}", orgMap, extCustToMap);
        JSONObject reqStr = this.setReqStr(reqBO, orgMap, extCustToMap);
        log.info("\u8c03\u7528\u5916\u90e8\u7cfb\u7edf\u91ca\u653e\u8ba2\u5355\u9884\u7b97\u5165\u53c2\u4e3a\uff1a{}", (Object)reqStr);
        String rspStr = BcmSaasHttpUtil.doPost(this.occupyBudgetUrl, reqStr.toJSONString());
        log.info("\u8c03\u7528\u5916\u90e8\u7cfb\u7edf\u91ca\u653e\u8ba2\u5355\u9884\u7b97\u51fa\u53c2\u4e3a\uff1a{}", (Object)rspStr);
        JSONObject rspJson = JSON.parseObject((String)rspStr);
        if (!SUCCESS.equals(rspJson.getString("code"))) {
            throw new ZTBusinessException("\u8c03\u7528\u5916\u90e8\u7cfb\u7edf\u91ca\u653e\u8ba2\u5355\u9884\u7b97\u62a5\u9519:" + rspJson.getString("message"));
        }
        return rspBo;
    }

    private void verifyParam(DycUocOrderTakeUpBudgetServiceExtReqBo reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u9884\u7b97\u8c03\u6574\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getSaleOrderId())) {
            throw new ZTBusinessException("\u9884\u7b97\u8c03\u6574\u670d\u52a1\u5165\u53c2\u5546\u57ce\u91c7\u8d2d\u8ba2\u5355ID\u3010saleOrderId\u3011\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getFinancialOrgId())) {
            throw new ZTBusinessException("\u9884\u7b97\u8c03\u6574\u670d\u52a1\u5165\u53c2\u8d22\u52a1\u7ec4\u7ec7\u3010financialOrgId\u3011\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getPayStatus())) {
            throw new ZTBusinessException("\u9884\u7b97\u8c03\u6574\u670d\u52a1\u5165\u53c2\u4ea4\u6613\u7c7b\u578b\u3010payStatus\u3011\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getOrderSource())) {
            throw new ZTBusinessException("\u9884\u7b97\u8c03\u6574\u670d\u52a1\u5165\u53c2\u91c7\u8d2d\u4e8b\u9879\u3010orderSource\u3011\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getApplyDept())) {
            throw new ZTBusinessException("\u9884\u7b97\u8c03\u6574\u670d\u52a1\u5165\u53c2\u7533\u8bf7\u90e8\u95e8\u3010applyDept\u3011\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getExtCustId())) {
            throw new ZTBusinessException("\u9884\u7b97\u8c03\u6574\u670d\u52a1\u5165\u53c2\u7ecf\u529e\u4ebaID\u3010extCustId\u3011\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getCreateOperName())) {
            throw new ZTBusinessException("\u9884\u7b97\u8c03\u6574\u670d\u52a1\u5165\u53c2\u7ecf\u529e\u4eba\u540d\u79f0\u3010createOperName\u3011\u4e3a\u7a7a");
        }
        if ("1".equals(reqBO.getPayStatus()) || "2".equals(reqBO.getPayStatus())) {
            if (ObjectUtil.isEmpty((Object)reqBO.getBudgetProjectId())) {
                throw new ZTBusinessException("\u9884\u7b97\u8c03\u6574\u670d\u52a1\u5165\u53c2\u9884\u7b97\u9879\u76ee\u3010budgetProjectId\u3011\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBO.getCostCenterId())) {
                throw new ZTBusinessException("\u9884\u7b97\u8c03\u6574\u670d\u52a1\u5165\u53c2\u6210\u672c\u4e2d\u5fc3\u3010budgetProjectId\u3011\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBO.getSaleOrderItemList())) {
                throw new ZTBusinessException("\u9884\u7b97\u8c03\u6574\u670d\u52a1\u5165\u53c2\u660e\u7ec6\u5355\u884c\u3010saleOrderItemList\u3011\u4e3a\u7a7a");
            }
            reqBO.getSaleOrderItemList().forEach(item -> {
                if (ObjectUtil.isEmpty((Object)item.getSaleOrderItemId())) {
                    throw new ZTBusinessException("\u9884\u7b97\u8c03\u6574\u670d\u52a1\u5165\u53c2\u8ba2\u5355\u660e\u7ec6\u3010saleOrderItemList.saleOrderItemId\u3011\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)item.getSkuName())) {
                    throw new ZTBusinessException("\u9884\u7b97\u8c03\u6574\u670d\u52a1" + item.getSaleOrderItemId() + "\u5165\u53c2\u5546\u54c1\u540d\u79f0\u3010saleOrderItemList.skuName\u3011\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)item.getSkuCode())) {
                    throw new ZTBusinessException("\u9884\u7b97\u8c03\u6574\u670d\u52a1" + item.getSaleOrderItemId() + "\u5165\u53c2\u5546\u54c1\u7f16\u53f7\u3010saleOrderItemList.skuCode\u3011\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)item.getIncomeAndExpProjectId())) {
                    throw new ZTBusinessException("\u9884\u7b97\u8c03\u6574\u670d\u52a1" + item.getSaleOrderItemId() + "\u5165\u53c2\u6536\u652f\u9879\u76ee\u3010saleOrderItemList.incomeAndExpProjectId\u3011\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)item.getTax())) {
                    throw new ZTBusinessException("\u9884\u7b97\u8c03\u6574\u670d\u52a1" + item.getSaleOrderItemId() + "\u5165\u53c2\u4ef7\u7a0e\u5408\u8ba1\u3010saleOrderItemList.taxRate\u3011\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)item.getPurchasePrice())) {
                    throw new ZTBusinessException("\u9884\u7b97\u8c03\u6574\u670d\u52a1" + item.getSaleOrderItemId() + "\u5165\u53c2\u4ef7\u7a0e\u5408\u8ba1\u3010saleOrderItemList.purchasePrice\u3011\u4e3a\u7a7a");
                }
            });
        }
    }

    private BcmGetOutIdInfoByInnerIdRspBo changeUmcData(DycUocOrderTakeUpBudgetServiceExtReqBo reqBO, List<String> extCustIdList, List<Long> orgIdList) {
        if (ObjectUtil.isNotEmpty((Object)reqBO.getFinancialOrgId())) {
            orgIdList.add(Long.valueOf(reqBO.getFinancialOrgId()));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getApplyDept())) {
            orgIdList.add(Long.valueOf(reqBO.getApplyDept()));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getRelevantDeptId())) {
            orgIdList.add(Long.valueOf(reqBO.getRelevantDeptId()));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getExtCustId())) {
            extCustIdList.add(reqBO.getExtCustId());
        }
        JSONObject reqUmcStr = new JSONObject();
        reqUmcStr.put("orgIdList", orgIdList);
        reqUmcStr.put("extCustIdList", extCustIdList);
        log.info("\u8c03\u7528\u4f1a\u5458\u63a5\u53e3\u8f6c\u6362\u6570\u636e\u5165\u53c2\u4e3a\uff1a{}", (Object)reqUmcStr);
        String rspUmcStr = BcmSaasHttpUtil.doPost(this.getOutInfoUrl, reqUmcStr.toJSONString());
        log.info("\u8c03\u7528\u4f1a\u5458\u63a5\u53e3\u8f6c\u6362\u6570\u636e\u51fa\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)rspUmcStr));
        BcmGetOutIdInfoByInnerIdRspBo innerIdRspBo = (BcmGetOutIdInfoByInnerIdRspBo)((Object)JSON.parseObject((String)JSON.parseObject((String)rspUmcStr).get((Object)"data").toString(), BcmGetOutIdInfoByInnerIdRspBo.class));
        if (!SUCCESS.equals(innerIdRspBo.getCode())) {
            throw new ZTBusinessException(innerIdRspBo.getCode());
        }
        return innerIdRspBo;
    }

    private JSONObject setReqStr(DycUocOrderTakeUpBudgetServiceExtReqBo reqBo, Map<String, BcmOrgInfoExtBo> orgMap, Map<String, BcmUserInfoExtBo> extCustToMap) {
        JSONObject reqStr = new JSONObject();
        reqStr.put("id", (Object)reqBo.getSaleOrderId());
        if (orgMap.containsKey(reqBo.getFinancialOrgId())) {
            reqStr.put("pkOrg", (Object)orgMap.get(reqBo.getFinancialOrgId()).getExtOrgCode());
        }
        if (orgMap.containsKey(reqBo.getApplyDept())) {
            reqStr.put("applyDept", (Object)orgMap.get(reqBo.getApplyDept()).getExtOrgCode());
        }
        if (orgMap.containsKey(reqBo.getRelevantDeptId())) {
            reqStr.put("attributeDept", (Object)orgMap.get(reqBo.getRelevantDeptId()).getExtOrgCode());
        }
        reqStr.put("agentName", (Object)reqBo.getCreateOperName());
        if (extCustToMap.containsKey(reqBo.getExtCustId())) {
            reqStr.put("agentCode", (Object)this.getFileValue(extCustToMap.get(reqBo.getExtCustId()).getUserExtMapList(), "extUserCode"));
        }
        reqStr.put("orderType", (Object)reqBo.getPayStatus());
        reqStr.put("currency", (Object)"CNY");
        if (BcmSaasPersonalCommonConstant.SkuSource.AGREEMENT.equals(Integer.valueOf(reqBo.getOrderSource()))) {
            if (ObjectUtil.isNotEmpty((Object)reqBo.getCurrency())) {
                reqStr.put("currency", (Object)reqBo.getCurrency());
            }
            reqStr.put("purchaseType", (Object)"2");
        } else {
            reqStr.put("purchaseType", (Object)"1");
        }
        JSONArray payitemList = this.setOrderItem(reqBo);
        reqStr.put("payitemList", (Object)payitemList);
        return reqStr;
    }

    private static JSONObject setFile(DycUocOrderTakeUpBudgetServiceExtReqBo reqBo, DycUocOrderTakeUpBudgetCommodityInfoBO item) {
        JSONObject fileStr = new JSONObject();
        fileStr.put("ecmId", (Object)"");
        fileStr.put("fileName", (Object)"");
        fileStr.put("fileType", (Object)"");
        fileStr.put("fileLength", (Object)"");
        return fileStr;
    }

    private JSONArray setOrderItem(DycUocOrderTakeUpBudgetServiceExtReqBo reqBo) {
        JSONArray payItemList = new JSONArray();
        for (DycUocOrderTakeUpBudgetCommodityInfoBO item : reqBo.getSaleOrderItemList()) {
            JSONObject itemStr = new JSONObject();
            itemStr.put("idB", (Object)item.getSaleOrderItemId());
            itemStr.put("commodityName", (Object)item.getSkuName());
            itemStr.put("commodityCode", (Object)item.getSkuCode());
            if (BcmSaasPersonalCommonConstant.SkuSource.AGREEMENT.equals(Integer.valueOf(reqBo.getOrderSource()))) {
                itemStr.put("contractCode", (Object)reqBo.getRelCode());
                itemStr.put("contractName", (Object)reqBo.getRelName());
                itemStr.put("ipmpCode", (Object)item.getIpmpCode());
                itemStr.put("ipmpName", (Object)item.getIpmpName());
            }
            itemStr.put("pkInoutBusiclass", (Object)item.getIncomeAndExpProjectId());
            itemStr.put("budgetAccount", (Object)reqBo.getBudgetProjectId());
            itemStr.put("ccCode", (Object)reqBo.getCostCenterId());
            itemStr.put("paidAmount", (Object)item.getPurchaseFee());
            itemStr.put("taxRate", (Object)item.getTax());
            payItemList.add((Object)itemStr);
        }
        return payItemList;
    }

    private String getFileValue(List<BaseExtendFieldBo> extendFieldBoList, String code) {
        BaseExtendFieldBo extendFieldBo = extendFieldBoList.stream().filter(item -> code.equals(item.getFieldCode())).findFirst().orElse(null);
        if (extendFieldBo != null) {
            return extendFieldBo.getFieldValue();
        }
        if (this.verifyParamSwitch.booleanValue() && !Arrays.stream(this.skipCode.split(",")).collect(Collectors.toList()).contains(code)) {
            throw new ZTBusinessException("\u9884\u7b97\u5360\u7528\u5165\u53c2" + code + "\u4e0d\u5b58\u5728");
        }
        return null;
    }
}

