/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.product.ext.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.saas.personal.constant.BcmSaasPersonalCommonConstant;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmGetOutIdInfoByInnerIdRspBo;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmInspItemBO;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmOrgInfoExtBo;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmQueryOrderItemBO;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmUserInfoExtBo;
import com.tydic.bcm.saas.personal.utils.BcmSaasHttpUtil;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.ext.fsc.api.FscOrderInfoPushServiceExtPt;
import com.tydic.ext.fsc.bo.FscExtInvoiceBO;
import com.tydic.ext.fsc.bo.FscExtOrderItemBO;
import com.tydic.ext.fsc.bo.FscOrderInfoPushReqBO;
import com.tydic.ext.fsc.bo.FscOrderInfoPushRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_SAAS_GROUP_DEV/3.0.0/com.tydic.ext.fsc.api.FscOrderInfoPushServiceExtPt"})
public class FscOrderInfoPushServiceExtPtImpl
implements FscOrderInfoPushServiceExtPt {
    private static final Logger log = LoggerFactory.getLogger(FscOrderInfoPushServiceExtPtImpl.class);
    @Value(value="${ORDER_INFO_PUSH_URL:}")
    private String orderInfoPushUrl;
    @Value(value="${ORDER_ITEM_QUERY_URL:}")
    private String orderItemQueryUrl;
    @Value(value="${GET_OUT_INFO_URL:}")
    private String getOutInfoUrl;
    @Value(value="${pushFscOrder.verifyParam.switch:}")
    private Boolean verifyParamSwitch;
    @Value(value="${pushFscOrder.skipCode:}")
    private String skipCode;
    private static final String SUCCESS = "0";

    @PostMapping(value={"pushFscOrder"})
    public FscOrderInfoPushRspBO pushFscOrder(@RequestBody FscOrderInfoPushReqBO reqBO) {
        log.info("\u7ed3\u7b97\u5355\u4fe1\u606f\u63a8\u9001API\u6269\u5c55\u5b9e\u73b0\u5165\u53c2\u4e3a:{}", (Object)JSON.toJSONString((Object)reqBO));
        if (this.verifyParamSwitch.booleanValue()) {
            this.verifyParam(reqBO);
        }
        FscOrderInfoPushRspBO rspBO = new FscOrderInfoPushRspBO();
        ArrayList<Long> userIdList = new ArrayList<Long>();
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        ArrayList<String> extCustIdList = new ArrayList<String>();
        HashMap<Long, BcmOrgInfoExtBo> orgMap = new HashMap();
        HashMap<Long, BcmUserInfoExtBo> userMap = new HashMap();
        HashMap<String, BcmUserInfoExtBo> extCustToMap = new HashMap();
        Map<Long, BcmInspItemBO> inspItemBOMap = this.changeOrderItem(reqBO, orgIdList);
        BcmGetOutIdInfoByInnerIdRspBo innerIdRspBo = this.changeUmcData(reqBO, userIdList, extCustIdList, orgIdList);
        if (ObjectUtil.isNotEmpty(innerIdRspBo.getUmcOrgInfoExtBoList())) {
            orgMap = innerIdRspBo.getUmcOrgInfoExtBoList().stream().collect(Collectors.toMap(BcmOrgInfoExtBo::getOrgId, Function.identity()));
        }
        if (ObjectUtil.isNotEmpty(innerIdRspBo.getUmcUserInfoExtBoList())) {
            userMap = innerIdRspBo.getUmcUserInfoExtBoList().stream().collect(Collectors.toMap(BcmUserInfoExtBo::getUserId, Function.identity()));
            extCustToMap = innerIdRspBo.getUmcUserInfoExtBoList().stream().collect(Collectors.toMap(BcmUserInfoExtBo::getExtCustId, Function.identity()));
        }
        log.info("orgMap:{},extCustToMap:{},userMap:{}", new Object[]{orgMap, extCustToMap, userMap});
        JSONObject reqStr = this.setReqStr(reqBO, inspItemBOMap, orgMap, userMap, extCustToMap);
        log.info("\u8c03\u7528\u5916\u90e8\u7cfb\u7edf\u7ed3\u7b97\u5355\u4fe1\u606f\u63a8\u9001\u5165\u53c2\u4e3a\uff1a{}", (Object)reqStr);
        String rspStr = BcmSaasHttpUtil.doPost(this.orderInfoPushUrl, reqStr.toJSONString());
        log.info("\u8c03\u7528\u5916\u90e8\u7cfb\u7edf\u7ed3\u7b97\u5355\u4fe1\u606f\u63a8\u9001\u51fa\u53c2\u4e3a\uff1a{}", (Object)rspStr);
        JSONObject rspJson = JSON.parseObject((String)rspStr);
        if (!SUCCESS.equals(rspJson.getString("code"))) {
            throw new ZTBusinessException("\u8c03\u7528\u5916\u90e8\u7cfb\u7ed3\u7b97\u5355\u4fe1\u606f\u63a8\u9001\u62a5\u9519:" + rspJson.getString("message"));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void verifyParam(FscOrderInfoPushReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u7ed3\u7b97\u5355\u4fe1\u606f\u63a8\u9001\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getFscOrderId())) {
            throw new ZTBusinessException("\u7ed3\u7b97\u5355\u4fe1\u606f\u63a8\u9001\u5165\u53c2\u7ed3\u7b97\u5355ID\u3010fscOrderId\u3011\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getPurchaserId())) {
            throw new ZTBusinessException("\u7ed3\u7b97\u5355\u4fe1\u606f\u63a8\u9001\u5165\u53c2\u7ec4\u7ec7\u3010purchaserId\u3011\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getOrderSource())) {
            throw new ZTBusinessException("\u7ed3\u7b97\u5355\u4fe1\u606f\u63a8\u9001\u5165\u53c2\u91c7\u8d2d\u4e8b\u9879\u3010orderSource\u3011\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getCreateOperId())) {
            throw new ZTBusinessException("\u7ed3\u7b97\u5355\u4fe1\u606f\u63a8\u9001\u5165\u53c2\u7ecf\u529e\u4ebaID\u3010createOperId\u3011\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getCreateOperName())) {
            throw new ZTBusinessException("\u7ed3\u7b97\u5355\u4fe1\u606f\u63a8\u9001\u5165\u53c2\u7ecf\u529e\u4eba\u540d\u79f0\u3010createOperName\u3011\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getPurchaserId())) {
            throw new ZTBusinessException("\u7ed3\u7b97\u5355\u4fe1\u606f\u63a8\u9001\u5165\u53c2\u7ec4\u7ec7\u3010purchaserId\u3011\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getFscExtOrderItemBOList())) {
            throw new ZTBusinessException("\u7ed3\u7b97\u5355\u4fe1\u606f\u63a8\u9001\u5165\u53c2\u660e\u7ec6\u5355\u884c\u3010fscExtOrderItemBOList\u3011\u4e3a\u7a7a");
        }
    }

    private BcmGetOutIdInfoByInnerIdRspBo changeUmcData(FscOrderInfoPushReqBO reqBO, List<Long> userIdList, List<String> extCustIdList, List<Long> orgIdList) {
        userIdList.add(reqBO.getCreateOperId());
        extCustIdList.add(reqBO.getFscExtOrderExtFieldBo().getValue7());
        orgIdList.add(reqBO.getPurchaserId());
        JSONObject reqUmcStr = new JSONObject();
        reqUmcStr.put("userIdList", userIdList);
        reqUmcStr.put("orgIdList", orgIdList);
        reqUmcStr.put("extCustIdList", extCustIdList);
        log.info("\u8c03\u7528\u4f1a\u5458\u63a5\u53e3\u8f6c\u6362\u6570\u636e\u5165\u53c2\u4e3a\uff1a{}", (Object)reqUmcStr);
        String rspUmcStr = BcmSaasHttpUtil.doPost(this.getOutInfoUrl, reqUmcStr.toJSONString());
        log.info("\u8c03\u7528\u4f1a\u5458\u63a5\u53e3\u8f6c\u6362\u6570\u636e\u51fa\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)rspUmcStr));
        BcmGetOutIdInfoByInnerIdRspBo innerIdRspBo = (BcmGetOutIdInfoByInnerIdRspBo)((Object)JSON.parseObject((String)JSON.parseObject((String)rspUmcStr).get((Object)"data").toString(), BcmGetOutIdInfoByInnerIdRspBo.class));
        if (!SUCCESS.equals(innerIdRspBo.getCode())) {
            throw new ZTBusinessException(innerIdRspBo.getCode());
        }
        return innerIdRspBo;
    }

    private Map<Long, BcmInspItemBO> changeOrderItem(FscOrderInfoPushReqBO reqBO, List<Long> orgIdList) {
        List inspItemIdList = reqBO.getFscExtOrderItemBOList().stream().map(FscExtOrderItemBO::getOrderItemId).distinct().collect(Collectors.toList());
        JSONObject queryOrderItemReqBO = new JSONObject();
        queryOrderItemReqBO.put("inspItemIdList", inspItemIdList);
        log.info("\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)queryOrderItemReqBO.toJSONString());
        String queryOrderItemRspBO = BcmSaasHttpUtil.doPost(this.orderItemQueryUrl, queryOrderItemReqBO.toJSONString());
        log.info("\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2\u51fa\u53c2\uff1a{}", (Object)queryOrderItemRspBO);
        BcmQueryOrderItemBO orderItemBO = (BcmQueryOrderItemBO)((Object)JSON.parseObject((String)JSON.parseObject((String)queryOrderItemRspBO).get((Object)"data").toString(), BcmQueryOrderItemBO.class));
        if (!SUCCESS.equals(orderItemBO.getCode())) {
            throw new ZTBusinessException(orderItemBO.getMessage());
        }
        log.info("\u8f6c\u6362\u540e\u7684\u5bf9\u8c61\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)((Object)orderItemBO)));
        if (ObjectUtil.isEmpty(orderItemBO.getInspItemList())) {
            return null;
        }
        orgIdList.addAll(orderItemBO.getInspItemList().stream().map(BcmInspItemBO::getSupplierId).collect(Collectors.toList()));
        return orderItemBO.getInspItemList().stream().collect(Collectors.toMap(BcmInspItemBO::getInspOrderItemId, Function.identity()));
    }

    private JSONObject setReqStr(FscOrderInfoPushReqBO reqBO, Map<Long, BcmInspItemBO> inspItemBOMap, Map<Long, BcmOrgInfoExtBo> orgMap, Map<Long, BcmUserInfoExtBo> userMap, Map<String, BcmUserInfoExtBo> extCustToMap) {
        JSONObject reqStr = new JSONObject();
        reqStr.put("mallStatementId", (Object)reqBO.getFscOrderId());
        if (orgMap.containsKey(reqBO.getPurchaserId())) {
            reqStr.put("pkOrg", (Object)orgMap.get(reqBO.getPurchaserId()).getExtOrgCode());
        }
        reqStr.put("agentName", (Object)reqBO.getCreateOperName());
        if (userMap.containsKey(reqBO.getCreateOperId())) {
            reqStr.put("agentCode", (Object)this.getFileValue(userMap.get(reqBO.getCreateOperId()).getUserExtMapList(), "extUserCode"));
        }
        if (extCustToMap.containsKey(reqBO.getFscExtOrderExtFieldBo().getValue7())) {
            reqStr.put("billMake", (Object)this.getFileValue(extCustToMap.get(reqBO.getFscExtOrderExtFieldBo().getValue7()).getUserExtMapList(), "extUserCode"));
        }
        reqStr.put("currency", (Object)"CNY");
        if (BcmSaasPersonalCommonConstant.SkuSource.AGREEMENT.equals(reqBO.getOrderSource())) {
            if (ObjectUtil.isNotEmpty((Object)reqBO.getCurrency())) {
                reqStr.put("currency", (Object)reqBO.getCurrency());
            }
            reqStr.put("purchaseType", (Object)"2");
        } else {
            reqStr.put("purchaseType", (Object)"1");
        }
        JSONArray payitemList = this.setPayItem(reqBO, inspItemBOMap, orgMap);
        reqStr.put("payitemList", (Object)payitemList);
        JSONArray payInvoiceList = this.setPayInvoice(reqBO);
        reqStr.put("payInvoiceList", (Object)payInvoiceList);
        JSONArray fileList = this.setFile(reqBO);
        reqStr.put("fileList", (Object)fileList);
        return reqStr;
    }

    private JSONArray setFile(FscOrderInfoPushReqBO reqBO) {
        JSONArray fileList = new JSONArray();
        for (FscExtInvoiceBO invoiceBO : reqBO.getFscExtInvoiceBOList()) {
            List fileBOS = invoiceBO.getFscExtAttachmentBOList().stream().map(item -> {
                JSONObject file = new JSONObject();
                file.put("ecmId", (Object)invoiceBO.getInvoiceNo());
                file.put("fileName", (Object)item.getAttachmentName());
                file.put("fileType", (Object)item.getAttachmentType());
                return file;
            }).collect(Collectors.toList());
            fileList.addAll(fileBOS);
        }
        return fileList;
    }

    private JSONArray setPayInvoice(FscOrderInfoPushReqBO reqBO) {
        JSONArray payInvoiceList = new JSONArray();
        for (FscExtInvoiceBO invoiceItem : reqBO.getFscExtInvoiceBOList()) {
            JSONObject payInvoice = new JSONObject();
            payInvoice.put("invoiceCode", (Object)invoiceItem.getInvoiceCode());
            payInvoice.put("invoiceNo", (Object)invoiceItem.getInvoiceNo());
            payInvoice.put("invoiceDate", (Object)invoiceItem.getBillDate());
            payInvoice.put("noTaxMoney", (Object)invoiceItem.getAmt());
            payInvoice.put("incomeTax", (Object)invoiceItem.getTaxAmt());
            BigDecimal priceAndTax = invoiceItem.getAmt().add(invoiceItem.getTaxAmt());
            payInvoice.put("priceAndTax", (Object)priceAndTax);
            payInvoiceList.add((Object)payInvoice);
        }
        return payInvoiceList;
    }

    private JSONArray setPayItem(FscOrderInfoPushReqBO reqBO, Map<Long, BcmInspItemBO> inspItemBOMap, Map<Long, BcmOrgInfoExtBo> orgMap) {
        JSONArray payItemList = new JSONArray();
        if (ObjectUtil.isNotEmpty((Object)reqBO.getFscExtOrderItemBOList())) {
            for (FscExtOrderItemBO extOrderItemBO : reqBO.getFscExtOrderItemBOList()) {
                JSONObject payItem = new JSONObject();
                if (inspItemBOMap.containsKey(extOrderItemBO.getOrderItemId())) {
                    BcmInspItemBO bcmInspItemBO = inspItemBOMap.get(extOrderItemBO.getOrderItemId());
                    if (BcmSaasPersonalCommonConstant.SkuSource.AGREEMENT.equals(reqBO.getOrderSource())) {
                        payItem.put("contractCode", (Object)this.getFileValue(bcmInspItemBO.getSaleOrderRspBo().getExtFields(), "jhContractNo"));
                        payItem.put("contractName", (Object)this.getFileValue(bcmInspItemBO.getSaleOrderRspBo().getExtFields(), "jhContractName"));
                        payItem.put("ipmpCode", (Object)bcmInspItemBO.getSaleOrderItemRspBo().getAgrSrcCode());
                        payItem.put("ipmpName", (Object)bcmInspItemBO.getSaleOrderItemRspBo().getAgrSrcName());
                    }
                    payItem.put("idB", (Object)bcmInspItemBO.getSaleOrderItemRspBo().getSaleOrderItemId());
                    payItem.put("pkInoutBusiclass", (Object)this.getFileValue(bcmInspItemBO.getSaleOrderRspBo().getExtFields(), "incomeAndExpProjectId"));
                    payItem.put("budgetAccount", (Object)this.getFileValue(bcmInspItemBO.getSaleOrderRspBo().getExtFields(), "budgetProjectId"));
                    payItem.put("ccCode", (Object)this.getFileValue(bcmInspItemBO.getSaleOrderRspBo().getExtFields(), "costCenterId"));
                    payItem.put("fileId", (Object)this.getFileValue(bcmInspItemBO.getSaleOrderRspBo().getExtFields(), "financialId"));
                    payItem.put("amonut", (Object)bcmInspItemBO.getInspFee());
                    payItem.put("taxRate", (Object)bcmInspItemBO.getSaleOrderItemRspBo().getTax());
                    if (orgMap.containsKey(bcmInspItemBO.getSupplierId())) {
                        payItem.put("usci", (Object)orgMap.get(bcmInspItemBO.getSupplierId()).getCreditNo());
                    }
                }
                payItem.put("recAccount", (Object)reqBO.getFscExtOrderExtFieldBo().getValue5());
                payItem.put("inputTaxType", (Object)"\u8d39\u7528");
                payItemList.add((Object)payItem);
            }
        }
        return payItemList;
    }

    private String getFileValue(List<BaseExtendFieldBo> extendFieldBoList, String code) {
        BaseExtendFieldBo extendFieldBo = extendFieldBoList.stream().filter(item -> code.equals(item.getFieldCode())).findFirst().orElse(null);
        if (extendFieldBo != null) {
            return extendFieldBo.getFieldValue();
        }
        if (this.verifyParamSwitch.booleanValue() && !Arrays.stream(this.skipCode.split(",")).collect(Collectors.toList()).contains(code)) {
            throw new ZTBusinessException("\u63a8\u9001\u7ed3\u7b97\u5355\u5165\u53c2" + code + "\u4e0d\u5b58\u5728");
        }
        return null;
    }
}

