/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.task.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.bcm.personal.commodity.api.BcmQueryApplyCommodityOrderPageListService;
import com.tydic.bcm.personal.commodity.api.BcmUpdateStatusApplyCommodityOrderService;
import com.tydic.bcm.personal.commodity.bo.BcmApplyCommodityOrderPageBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyCommodityOrderPageListReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyCommodityOrderPageListRspBO;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateStatusApplyCommodityOrderReqBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityCancelTypeEnum;
import com.tydic.bcm.personal.constants.BooleanFlagEnum;
import com.tydic.bcm.personal.flow.api.BcmQueryFlowInstanceService;
import com.tydic.bcm.saas.personal.notice.BcmSaasSendNoticeService;
import com.tydic.bcm.saas.personal.notice.BcmSaasSendTodoService;
import com.tydic.bcm.saas.personal.task.api.BcmSaasApplyOrderTerminateReplyTimeTaskService;
import com.tydic.bcm.saas.personal.task.bo.BcmSaasTerminateApplyCommodityOrderReqBO;
import com.tydic.bcm.saas.personal.task.bo.BcmSaasTerminateApplyCommodityOrderRspBO;
import com.tydic.bcm.saas.personal.utils.BcmSaasHttpUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_SAAS_GROUP_DEV/3.0.0/com.tydic.bcm.saas.personal.task.api.BcmSaasApplyOrderTerminateReplyTimeTaskService"})
public class BcmSaasApplyOrderTerminateReplyTimeTaskServiceImpl
implements BcmSaasApplyOrderTerminateReplyTimeTaskService {
    private static final Logger log = LoggerFactory.getLogger(BcmSaasApplyOrderTerminateReplyTimeTaskServiceImpl.class);
    @Autowired
    private BcmQueryApplyCommodityOrderPageListService bcmQueryApplyCommodityOrderPageListService;
    @Autowired
    private BcmUpdateStatusApplyCommodityOrderService bcmUpdateStatusApplyCommodityOrderService;
    private final BcmSaasSendNoticeService bcmSaasSendNoticeService;
    @Value(value="${REPLY_SUPPLIER_NUM:2}")
    private Integer replySupplierNum;
    @Value(value="${DEAL_REPLY_COUNT:100}")
    private Integer dealReplyCount;
    @Value(value="${bcm.dyc.front.url}")
    private String frontUrl;
    @Autowired
    private BcmSaasSendTodoService bcmSaasSendTodoService;
    @Autowired
    private BcmQueryFlowInstanceService bcmQueryFlowInstanceService;
    @Value(value="${APPLY_ORDER_TODO_CODE:APPLY_COMMODITY_ORDER}")
    private String applyOrderTodoCode;
    @Value(value="${STOP_COMMODITY_POOL_URL:}")
    private String stopCommodityPoolUrl;

    @Override
    @PostMapping(value={"terminateApplyCommodityOrder"})
    public BcmSaasTerminateApplyCommodityOrderRspBO terminateApplyCommodityOrder(@RequestBody BcmSaasTerminateApplyCommodityOrderReqBO reqBO) {
        BcmSaasTerminateApplyCommodityOrderRspBO rspBO = new BcmSaasTerminateApplyCommodityOrderRspBO();
        BcmQueryApplyCommodityOrderPageListReqBO orderPageListReqBO = this.setOrderPageListReqBO();
        int initPageNo = orderPageListReqBO.getPageNo();
        while (true) {
            orderPageListReqBO.setPageNo(initPageNo);
            BcmQueryApplyCommodityOrderPageListRspBO orderPageListRspBO = this.bcmQueryApplyCommodityOrderPageListService.queryApplyCommodityOrderPageList(orderPageListReqBO);
            if (ObjectUtil.isEmpty((Object)orderPageListRspBO.getRows())) break;
            for (BcmApplyCommodityOrderPageBO item : orderPageListRspBO.getRows()) {
                BcmUpdateStatusApplyCommodityOrderReqBO updateOrderReqBO;
                if (ObjectUtil.isNotEmpty((Object)item.getReplySupplierNum()) && item.getReplySupplierNum() >= this.replySupplierNum) {
                    updateOrderReqBO = this.setInSelectReqBO(item);
                    this.bcmUpdateStatusApplyCommodityOrderService.updateStatusApplyCommodityOrder(updateOrderReqBO);
                    this.bcmSaasSendNoticeService.sendAsyncSelectNotice(item);
                    continue;
                }
                updateOrderReqBO = this.setTerminationReqBO(item);
                this.bcmUpdateStatusApplyCommodityOrderService.updateStatusApplyCommodityOrder(updateOrderReqBO);
                this.bcmSaasSendNoticeService.sendAsyncApplyOrderTerminateNotice(item.getApplyOrderId(), BcmPersonalCommodityCancelTypeEnum.REPLY_DEADLINE.getCancelDesc(), null, null);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("expand7", (Object)item.getApplyOrderId());
                String result = BcmSaasHttpUtil.doPost(this.stopCommodityPoolUrl, jsonObject.toJSONString());
                log.info("\u505c\u7528\u5b9a\u5236\u5546\u54c1\u6c60\u5165\u53c2{},\u51fa\u53c2{}", (Object)jsonObject.toJSONString(), (Object)result);
            }
            ++initPageNo;
        }
        return rspBO;
    }

    private BcmUpdateStatusApplyCommodityOrderReqBO setTerminationReqBO(BcmApplyCommodityOrderPageBO item) {
        BcmUpdateStatusApplyCommodityOrderReqBO updateOrderReqBO = new BcmUpdateStatusApplyCommodityOrderReqBO();
        updateOrderReqBO.setApplyOrderId(item.getApplyOrderId());
        updateOrderReqBO.setApplyOrderStatus(BcmPersonalApplyOrderStatusEnum.TERMINATION.getStatus());
        updateOrderReqBO.setCancelType(BcmPersonalCommodityCancelTypeEnum.REPLY_DEADLINE.getCancelType());
        updateOrderReqBO.setCancelReason(BcmPersonalCommodityCancelTypeEnum.REPLY_DEADLINE.getCancelDesc());
        updateOrderReqBO.setUpdateUserId(Long.valueOf(1L));
        updateOrderReqBO.setUpdateUserName("\u5b9a\u65f6\u4efb\u52a1");
        updateOrderReqBO.setUpdateTime(new Date());
        return updateOrderReqBO;
    }

    private BcmUpdateStatusApplyCommodityOrderReqBO setInSelectReqBO(BcmApplyCommodityOrderPageBO item) {
        BcmUpdateStatusApplyCommodityOrderReqBO updateOrderReqBO = new BcmUpdateStatusApplyCommodityOrderReqBO();
        updateOrderReqBO.setApplyOrderId(item.getApplyOrderId());
        updateOrderReqBO.setApplyOrderStatus(BcmPersonalApplyOrderStatusEnum.IN_SELECT.getStatus());
        updateOrderReqBO.setSelectDeadFlag(BooleanFlagEnum.YES.getFlag());
        updateOrderReqBO.setUpdateUserId(Long.valueOf(1L));
        updateOrderReqBO.setUpdateUserName("\u5b9a\u65f6\u4efb\u52a1");
        updateOrderReqBO.setUpdateTime(new Date());
        return updateOrderReqBO;
    }

    private BcmQueryApplyCommodityOrderPageListReqBO setOrderPageListReqBO() {
        BcmQueryApplyCommodityOrderPageListReqBO orderPageListReqBO = new BcmQueryApplyCommodityOrderPageListReqBO();
        orderPageListReqBO.setApplyOrderStatus(BcmPersonalApplyOrderStatusEnum.IN_REPLY.getStatus());
        orderPageListReqBO.setPageSize(this.dealReplyCount.intValue());
        orderPageListReqBO.setReplyDeadlineEndDate(new Date());
        orderPageListReqBO.setSumFlag(BooleanFlagEnum.YES.getFlag());
        return orderPageListReqBO;
    }

    public BcmSaasApplyOrderTerminateReplyTimeTaskServiceImpl(BcmSaasSendNoticeService bcmSaasSendNoticeService) {
        this.bcmSaasSendNoticeService = bcmSaasSendNoticeService;
    }
}

