/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.task.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.bcm.personal.common.api.BcmQueryJdHisOrderService;
import com.tydic.bcm.personal.common.bo.BcmQueryJdHisOrderTableReqBO;
import com.tydic.bcm.personal.common.bo.BcmQueryJdHisOrderTableRspBO;
import com.tydic.bcm.personal.task.api.BcmJdHisOrderSyncTaskService;
import com.tydic.bcm.personal.task.bo.BcmJdHisOrderSyncTaskReqBO;
import com.tydic.bcm.saas.personal.task.api.BcmSaasJdHisOrderSyncTaskService;
import com.tydic.bcm.saas.personal.task.bo.BcmSaasJdHisOrderSyncTaskReqBO;
import com.tydic.bcm.saas.personal.task.bo.BcmSaasJdHisOrderSyncTaskRspBO;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_SAAS_GROUP_DEV/3.0.0/com.tydic.bcm.saas.personal.task.api.BcmSaasJdHisOrderSyncTaskService"})
public class BcmSaasJdHisOrderSyncTaskServiceImpl
implements BcmSaasJdHisOrderSyncTaskService {
    private static final Logger log = LoggerFactory.getLogger(BcmSaasJdHisOrderSyncTaskServiceImpl.class);
    @Autowired
    private BcmJdHisOrderSyncTaskService bcmJdHisOrderSyncTaskService;
    @Autowired
    private BcmQueryJdHisOrderService bcmQueryJdHisOrderService;
    private static final Integer month = 12;
    private static final String SYNC_HIS_ORDER_KEY = "SYNC_HIS_ORDER_KEY";
    private static final String SYNC_HIS_ORDER_KEY_THREAD_COUNT = "SYNC_HIS_ORDER_KEY_THREAD_COUNT";
    private static final String SYNC_HIS_ORDER_KEY_SUP = "SYNC_HIS_ORDER_KEY_SUP";
    @Autowired
    private CacheClient cacheClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PostMapping(value={"syncJdHisOrder"})
    public BcmSaasJdHisOrderSyncTaskRspBO syncJdHisOrder(@RequestBody BcmSaasJdHisOrderSyncTaskReqBO reqBO) {
        int threadCount;
        BcmSaasJdHisOrderSyncTaskRspBO rspBO = new BcmSaasJdHisOrderSyncTaskRspBO();
        Long setnxThreadCountResult = this.cacheClient.setnx(SYNC_HIS_ORDER_KEY_THREAD_COUNT, (Object)reqBO.getSHARDING_SHARDNUM());
        if (setnxThreadCountResult < 1L && (threadCount = Integer.parseInt(this.cacheClient.get(SYNC_HIS_ORDER_KEY_THREAD_COUNT).toString())) != reqBO.getSHARDING_SHARDNUM()) {
            rspBO.setMessage("\u4e0a\u6b21\u53d1\u8d77\u7684\u4efb\u52a1\u672a\u5904\u7406\u5b8c\u6210\uff0c\u8bf7\u7a0d\u540e\u53d1\u8d77");
            return rspBO;
        }
        Long setnxThreadNumResult = this.cacheClient.setnx(SYNC_HIS_ORDER_KEY + reqBO.getSHARDING_PARAMETER(), (Object)reqBO.getSHARDING_PARAMETER());
        if (setnxThreadNumResult < 1L) {
            rspBO.setMessage("\u5206\u7247" + reqBO.getSHARDING_PARAMETER() + "\u6b63\u5728\u5904\u7406\uff0c\u8bf7\u52ff\u91cd\u590d\u53d1\u8d77");
            return rspBO;
        }
        try {
            BcmQueryJdHisOrderTableReqBO tableReqBO = new BcmQueryJdHisOrderTableReqBO();
            tableReqBO.setTableNamePrefix(reqBO.getSHARDING_PARAMETER());
            BcmQueryJdHisOrderTableRspBO tableRspBO = this.bcmQueryJdHisOrderService.queryJdHisOrder(tableReqBO);
            if (ObjectUtil.isNotEmpty((Object)tableRspBO.getTableNameList())) {
                for (String tableName : tableRspBO.getTableNameList()) {
                    BcmJdHisOrderSyncTaskReqBO syncTaskReqBO = new BcmJdHisOrderSyncTaskReqBO();
                    syncTaskReqBO.setTableName(tableName);
                    this.bcmJdHisOrderSyncTaskService.syncJdHisOrder(syncTaskReqBO);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            log.debug("\u4eac\u4e1c\u5386\u53f2\u8ba2\u5355\u540c\u6b65\u5b9a\u65f6\u4efb\u52a1\u5206\u7247" + reqBO.getSHARDING_PARAMETER() + "\u5904\u7406\u5b8c\u6210");
            this.dealRedisValue(reqBO);
            log.info("\u4eac\u4e1c\u5386\u53f2\u8ba2\u5355\u5b9a\u65f6\u4efb\u52a1\u5206\u7247\u6267\u884c\u5b8c\u6210" + reqBO.getSHARDING_PARAMETER() + "\u7f13\u5b58keys {}", (Object)this.cacheClient.getkeys("SYNC_HIS_ORDER_KEY*"));
        }
        return rspBO;
    }

    private void dealRedisValue(BcmSaasJdHisOrderSyncTaskReqBO reqBo) {
        this.cacheClient.setnx(SYNC_HIS_ORDER_KEY_SUP, (Object)reqBo.getSHARDING_SHARDNUM());
        int surplus = Integer.parseInt(this.cacheClient.get(SYNC_HIS_ORDER_KEY_SUP).toString());
        if (surplus == 1) {
            this.cacheClient.delete(SYNC_HIS_ORDER_KEY_SUP);
            this.cacheClient.delete(SYNC_HIS_ORDER_KEY_THREAD_COUNT);
            Set threadNumSet = this.cacheClient.getkeys("SYNC_HIS_ORDER_KEY*");
            if (!CollectionUtils.isEmpty((Collection)threadNumSet)) {
                threadNumSet.forEach(key -> this.cacheClient.delete(key));
            } else {
                log.error("redis\u7f13\u5b58\u6e05\u695a\u5931\u8d25\uff0c\u83b7\u53d6\u4e0d\u5230\u5bf9\u5e94key");
            }
        } else {
            this.cacheClient.set(SYNC_HIS_ORDER_KEY_SUP, (Object)(surplus - 1));
        }
    }
}

