/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.task.impl;

import cn.hutool.core.date.DateUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmQueryApplyCommodityOrderListService;
import com.tydic.bcm.personal.commodity.bo.BcmApplyCommodityOrderBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyCommodityOrderListReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyCommodityOrderListRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.personal.flow.api.BcmQueryFlowInstanceService;
import com.tydic.bcm.saas.personal.notice.BcmSaasSendNoticeService;
import com.tydic.bcm.saas.personal.notice.BcmSaasSendTodoService;
import com.tydic.bcm.saas.personal.task.api.BcmSaasSendMessageCutoffApplyOrderTaskService;
import com.tydic.bcm.saas.personal.task.bo.BcmSaasSendMessageCutoffApplyOrderTaskReqBO;
import com.tydic.bcm.saas.personal.task.bo.BcmSaasSendMessageCutoffApplyOrderTaskRspBO;
import com.tydic.bcm.saas.personal.utils.BcmSaasRuUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_SAAS_GROUP_DEV/3.0.0/com.tydic.bcm.saas.personal.task.api.BcmSaasSendMessageCutoffApplyOrderTaskService"})
public class BcmSaasSendMessageCutoffApplyOrderTaskServiceImpl
implements BcmSaasSendMessageCutoffApplyOrderTaskService {
    private static final Logger log = LoggerFactory.getLogger(BcmSaasSendMessageCutoffApplyOrderTaskServiceImpl.class);
    @Autowired
    private BcmQueryApplyCommodityOrderListService bcmQueryApplyCommodityOrderListService;
    private final BcmSaasSendNoticeService bcmSaasSendNoticeService;
    @Value(value="${bcm.dyc.front.url}")
    private String frontUrl;
    @Autowired
    private BcmSaasSendTodoService bcmSaasSendTodoService;
    @Autowired
    private BcmQueryFlowInstanceService bcmQueryFlowInstanceService;
    @Value(value="${APPLY_ORDER_TODO_CODE:APPLY_COMMODITY_ORDER}")
    private String applyOrderTodoCode;

    @Override
    @PostMapping(value={"sendMessageCutoffApplyOrder"})
    public BcmSaasSendMessageCutoffApplyOrderTaskRspBO sendMessageCutoffApplyOrder(@RequestBody BcmSaasSendMessageCutoffApplyOrderTaskReqBO reqBO) {
        BcmQueryApplyCommodityOrderListReqBO bcmQueryApplyCommodityOrderListReqBO = this.getBcmQueryApplyCommodityOrderListReqBO();
        BcmQueryApplyCommodityOrderListRspBO bcmQueryApplyCommodityOrderListRspBO = this.bcmQueryApplyCommodityOrderListService.getList(bcmQueryApplyCommodityOrderListReqBO);
        if (!"0000".equals(bcmQueryApplyCommodityOrderListRspBO.getRespCode())) {
            throw new ZTBusinessException(bcmQueryApplyCommodityOrderListRspBO.getRespDesc());
        }
        if (CollectionUtils.isNotEmpty((Collection)bcmQueryApplyCommodityOrderListRspBO.getList())) {
            for (BcmApplyCommodityOrderBO bo : bcmQueryApplyCommodityOrderListRspBO.getList()) {
                this.bcmSaasSendNoticeService.sendAsyncPendingSelect(bo);
            }
        }
        return BcmSaasRuUtil.success(BcmSaasSendMessageCutoffApplyOrderTaskRspBO.class);
    }

    private BcmQueryApplyCommodityOrderListReqBO getBcmQueryApplyCommodityOrderListReqBO() {
        BcmQueryApplyCommodityOrderListReqBO bcmQueryApplyCommodityOrderListReqBO = new BcmQueryApplyCommodityOrderListReqBO();
        bcmQueryApplyCommodityOrderListReqBO.setApplyOrderStatusList(Collections.singletonList(BcmPersonalApplyOrderStatusEnum.IN_SELECT.getStatus()));
        bcmQueryApplyCommodityOrderListReqBO.setSelectDeadlineStartDate((Date)DateUtil.offsetDay((Date)new Date(), (int)-1));
        return bcmQueryApplyCommodityOrderListReqBO;
    }

    public BcmSaasSendMessageCutoffApplyOrderTaskServiceImpl(BcmSaasSendNoticeService bcmSaasSendNoticeService) {
        this.bcmSaasSendNoticeService = bcmSaasSendNoticeService;
    }
}

