/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.base.utils;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkerUtils {
    private static final Logger log = LoggerFactory.getLogger(FreemarkerUtils.class);

    public static void exportToFile(Map dataMap, String templateName, String templateFilePath, String fileFullPath) {
        try {
            File file = new File(fileFullPath);
            FileUtils.forceMkdirParent((File)file);
            FileOutputStream outputStream = new FileOutputStream(file);
            FreemarkerUtils.exportToStream(dataMap, templateName, templateFilePath, outputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void exportToStream(Map dataMap, String templateName, String templateFilePath, OutputStream outputStream) {
        try {
            Template template = FreemarkerUtils.getTemplate(templateName, templateFilePath);
            OutputStreamWriter outputWriter = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
            BufferedWriter writer = new BufferedWriter(outputWriter);
            template.process((Object)dataMap, (Writer)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Template getTemplate(String templateName, String filePath) throws IOException {
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_23);
        configuration.setDefaultEncoding("UTF-8");
        configuration.setTemplateUpdateDelayMilliseconds(0L);
        configuration.setEncoding(Locale.CHINA, "UTF-8");
        configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        configuration.setClassForTemplateLoading(FreemarkerUtils.class, filePath);
        configuration.setOutputEncoding("UTF-8");
        return configuration.getTemplate(templateName, "UTF-8");
    }
}

