/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccSkuBatchDealRecordAddAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuBatchDealRecordAddAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuBatchDealRecordAddAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccSkuBatchDealRecordAddBusiService;
import com.tydic.commodity.common.busi.bo.UccSkuBatchDealRecordAddBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccSkuBatchDealRecordAddBusiRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuBatchDealRecordAddAbilityService"})
public class UccSkuBatchDealRecordAddAbilityServiceImpl
implements UccSkuBatchDealRecordAddAbilityService {
    @Autowired
    private UccSkuBatchDealRecordAddBusiService uccSkuBatchDealRecordAddBusiService;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @PostMapping(value={"addSkuBatchDealRecord"})
    public UccSkuBatchDealRecordAddAbilityRspBO addSkuBatchDealRecord(@RequestBody UccSkuBatchDealRecordAddAbilityReqBO abilityReqBO) {
        this.validReqParam(abilityReqBO);
        if (abilityReqBO.getSameLevel() != null && abilityReqBO.getSameLevel() == 1) {
            this.dealSameLevel(abilityReqBO);
        }
        UccSkuBatchDealRecordAddBusiReqBO uccSkuBatchDealRecordAddBusiReqBO = (UccSkuBatchDealRecordAddBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)abilityReqBO), UccSkuBatchDealRecordAddBusiReqBO.class));
        UccSkuBatchDealRecordAddBusiRspBO busiRspBO = this.uccSkuBatchDealRecordAddBusiService.addSkuBatchDealRecord(uccSkuBatchDealRecordAddBusiReqBO);
        UccSkuBatchDealRecordAddAbilityRspBO rspBO = (UccSkuBatchDealRecordAddAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiRspBO)), UccSkuBatchDealRecordAddAbilityRspBO.class);
        rspBO.setBatchNo(abilityReqBO.getBatchNo());
        return rspBO;
    }

    private void validReqParam(UccSkuBatchDealRecordAddAbilityReqBO abilityReqBO) {
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getBatchSkuList())) {
            throw new BusinessException("8888", "\u5165\u53c2batchSkuList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)abilityReqBO.getDealType())) {
            throw new BusinessException("8888", "\u5165\u53c2dealType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)abilityReqBO.getBatchNo())) {
            Long batchNo = Sequence.getInstance().nextId();
            abilityReqBO.setBatchNo(batchNo.toString());
        }
    }

    private void dealSameLevel(UccSkuBatchDealRecordAddAbilityReqBO reqBO) {
        List skus = reqBO.getBatchSkuList().stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
        ArrayList<Integer> skuStatus = new ArrayList<Integer>();
        if (UccConstants.SkuBatchDealType.AGR_PUT_ON.equals(reqBO.getDealType()) || UccConstants.SkuBatchDealType.SELF_PUT_ON.equals(reqBO.getDealType()) || UccConstants.SkuBatchDealType.ESTORE_PUT_ON.equals(reqBO.getDealType())) {
            skuStatus.add(ModelRuleConstant.SKU_STATUS_WAIT_SHELF);
        }
        if (UccConstants.SkuBatchDealType.AGR_PUT_DOWN.equals(reqBO.getDealType()) || UccConstants.SkuBatchDealType.SELF_PUT_DOWN.equals(reqBO.getDealType()) || UccConstants.SkuBatchDealType.ESTORE_PUT_DOWN.equals(reqBO.getDealType())) {
            skuStatus.add(ModelRuleConstant.SKU_STATUS_ON_SHELF);
        }
        if (UccConstants.SkuBatchDealType.AGR_FORCE_DOWN.equals(reqBO.getDealType()) || UccConstants.SkuBatchDealType.SELF_FORCE_DOWN.equals(reqBO.getDealType())) {
            skuStatus.add(ModelRuleConstant.SKU_STATUS_ON_SHELF);
        }
        if (UccConstants.SkuBatchDealType.AGR_RE_PUT_ON.equals(reqBO.getDealType()) || UccConstants.SkuBatchDealType.SELF_RE_PUT_ON.equals(reqBO.getDealType()) || UccConstants.SkuBatchDealType.ESTORE_RE_PUT_ON.equals(reqBO.getDealType())) {
            skuStatus.add(ModelRuleConstant.SKU_STATUS_FORCE_DOWN_SHELF);
            skuStatus.add(ModelRuleConstant.SKU_STATUS_DOWN_SHELF);
        }
        ArrayList<Integer> excludeApprovalStatus = new ArrayList<Integer>();
        excludeApprovalStatus.add(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_ON_SHELF_GO);
        excludeApprovalStatus.add(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_GO);
        excludeApprovalStatus.add(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_DOWN_GO);
        excludeApprovalStatus.add(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_PUSH_GO);
        excludeApprovalStatus.add(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_RECOVER_GO);
        List sameLevelOtrherSku = this.uccSkuMapper.queySameLevelOtrherSku(skus, null, skuStatus, null, excludeApprovalStatus);
        if (!CollectionUtils.isEmpty((Collection)sameLevelOtrherSku)) {
            sameLevelOtrherSku.stream().forEach(a -> {
                UccBatchSkuBO bo = new UccBatchSkuBO();
                bo.setSupplierShopId(a.getSupplierShopId());
                bo.setSkuId(a.getSkuId());
                reqBO.getBatchSkuList().add(bo);
            });
        }
    }
}

