/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.extension.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.extension.constant.UccConstants;
import com.tydic.commodity.common.extension.ability.api.BkUccQueryAssistChooseOrderListAbilityService;
import com.tydic.commodity.common.extension.ability.bo.BkUccAssistChooseOrderListInfoBo;
import com.tydic.commodity.common.extension.ability.bo.BkUccQueryAssistChooseOrderListAbilityReqBO;
import com.tydic.commodity.common.extension.ability.bo.BkUccQueryAssistChooseOrderListAbilityRspBO;
import com.tydic.commodity.extension.dao.BkUccAssistChooseOrderMapper;
import com.tydic.commodity.extension.po.BkUccAssistChooseOrderSupplierPO;
import com.tydic.commodity.extension.po.BkUccQueryAssistChooseOrderListPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/3.1.0/com.tydic.commodity.common.extension.ability.api.BkUccQueryAssistChooseOrderListAbilityService"})
public class BkUccQueryAssistChooseOrderListAbilityServiceImpl
implements BkUccQueryAssistChooseOrderListAbilityService {
    @Autowired
    private BkUccAssistChooseOrderMapper uccAssistChooseOrderMapper;

    @PostMapping(value={"queryAssistChooseOrderList"})
    public BkUccQueryAssistChooseOrderListAbilityRspBO queryAssistChooseOrderList(@RequestBody BkUccQueryAssistChooseOrderListAbilityReqBO reqBO) {
        BkUccQueryAssistChooseOrderListAbilityRspBO rspBO = this.checkReqBo(reqBO);
        if (!RspConstantEnums.SUCCESS.code().equals(rspBO.getRespCode())) {
            return rspBO;
        }
        BkUccQueryAssistChooseOrderListPO uccListPO = new BkUccQueryAssistChooseOrderListPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccListPO);
        uccListPO.setTabId(this.transferTabIdToStatus(reqBO.getTabId()));
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List uccAssistChooseOrderPOList = this.uccAssistChooseOrderMapper.queryAssistChooseOrderList(uccListPO, page);
        if (!CollectionUtils.isEmpty((Collection)uccAssistChooseOrderPOList)) {
            ArrayList uccAssistChooseOrderListInfoBOS = new ArrayList();
            uccAssistChooseOrderPOList.stream().forEach(po -> {
                BkUccAssistChooseOrderListInfoBo uccAssistChooseOrderListInfoBO = new BkUccAssistChooseOrderListInfoBo();
                BeanUtils.copyProperties((Object)po, (Object)uccAssistChooseOrderListInfoBO);
                BkUccAssistChooseOrderSupplierPO chooseOrderSupplierPO = po.getUccAssistChooseOrderSupplierPO();
                if (null != chooseOrderSupplierPO) {
                    uccAssistChooseOrderListInfoBO.setSupplierName(chooseOrderSupplierPO.getSupplierName());
                }
                uccAssistChooseOrderListInfoBO.setStatusStr(this.transferStatusToTabName(po.getStatus()));
                uccAssistChooseOrderListInfoBOS.add(uccAssistChooseOrderListInfoBO);
            });
            rspBO.setRows(uccAssistChooseOrderListInfoBOS);
        }
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }

    private BkUccQueryAssistChooseOrderListAbilityRspBO checkReqBo(BkUccQueryAssistChooseOrderListAbilityReqBO reqBO) {
        BkUccQueryAssistChooseOrderListAbilityRspBO rspBO = new BkUccQueryAssistChooseOrderListAbilityRspBO();
        if (null == reqBO) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getTabId())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u9875\u7b7eID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getProjectId()) && !"0".equals(reqBO.getIsProfessionalOrgExt())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        rspBO.setRespCode(RspConstantEnums.SUCCESS.code());
        rspBO.setRespDesc(RspConstantEnums.SUCCESS.message());
        return rspBO;
    }

    private String transferStatusToTabName(Integer status) {
        switch (String.valueOf(status)) {
            case "1": {
                return UccConstants.UccAssistChooseOrderEnum.ASSIST_CHOOSE_ORDER_STATUS_DRAFT.message();
            }
            case "2": {
                return UccConstants.UccAssistChooseOrderEnum.ASSIST_CHOOSE_ORDER_STATUS_NEED_REPLY.message();
            }
            case "3": {
                return UccConstants.UccAssistChooseOrderEnum.ASSIST_CHOOSE_ORDER_STATUS_HAS_REPLY.message();
            }
            case "4": {
                return UccConstants.UccAssistChooseOrderEnum.ASSIST_CHOOSE_ORDER_STATUS_HAS_FINISH.message();
            }
        }
        return null;
    }

    private String transferTabIdToStatus(String tabId) {
        switch (tabId) {
            case "1001": {
                return "1";
            }
            case "1002": {
                return "2";
            }
            case "1003": {
                return "3";
            }
            case "1004": {
                return "4";
            }
        }
        return null;
    }
}

