/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.common.ability.api.UccCommodityTypeCountQryService;
import com.tydic.commodity.common.ability.bo.UccCommodityTypeCountQryServiceReqBo;
import com.tydic.commodity.common.ability.bo.UccCommodityTypeCountQryServiceRspBo;
import com.tydic.commodity.common.ability.bo.UccCommodityTypeCountQryServiceRspCommodityBo;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.po.CommodityTypeCountQryCommodityPo;
import com.tydic.commodity.po.UccCommodityPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccCommodityTypeCountQryService"})
public class UccCommodityTypeCountQryServiceImpl
implements UccCommodityTypeCountQryService {
    private static final Logger log = LoggerFactory.getLogger(UccCommodityTypeCountQryServiceImpl.class);
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Value(value="${ucc.queryStatus:0,2,3,5}")
    private List<Integer> queryStatus;

    @PostMapping(value={"qryCommodityTypeCount"})
    public UccCommodityTypeCountQryServiceRspBo qryCommodityTypeCount(@RequestBody UccCommodityTypeCountQryServiceReqBo reqBo) {
        this.validateArg(reqBo);
        UccCommodityTypeCountQryServiceRspBo rspBo = new UccCommodityTypeCountQryServiceRspBo();
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        List listPage = this.uccCommodityMapper.getListPageByCommodityId(reqBo.getCommodityIdList(), page, this.queryStatus);
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        Map<Object, Object> commodityTypeMap = new HashMap();
        Boolean noNeedReturnCommodityIdList = reqBo.getNeedReturnCommodityIdList();
        if (noNeedReturnCommodityIdList.booleanValue()) {
            List uccCommodityPos = this.uccCommodityMapper.queryCommodityTypeByCommodityId(reqBo.getCommodityIdList(), this.queryStatus);
            commodityTypeMap = uccCommodityPos.stream().collect(Collectors.groupingBy(UccCommodityPo::getCommodityTypeId));
        }
        ArrayList<UccCommodityTypeCountQryServiceRspCommodityBo> rows = new ArrayList<UccCommodityTypeCountQryServiceRspCommodityBo>();
        rspBo.setRows(rows);
        for (CommodityTypeCountQryCommodityPo commodityTypeCountQryCommodityPo : listPage) {
            UccCommodityTypeCountQryServiceRspCommodityBo tmpBo = new UccCommodityTypeCountQryServiceRspCommodityBo();
            BeanUtils.copyProperties((Object)commodityTypeCountQryCommodityPo, (Object)tmpBo);
            rows.add(tmpBo);
            if (!noNeedReturnCommodityIdList.booleanValue() || commodityTypeMap.get(tmpBo.getCommodityTypeId()) == null) continue;
            tmpBo.setCommodityIdList(((List)commodityTypeMap.get(tmpBo.getCommodityTypeId())).stream().map(UccCommodityPo::getCommodityId).collect(Collectors.toList()));
        }
        rspBo.setDatasCount(Integer.valueOf(reqBo.getCommodityIdList().size()));
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void validateArg(UccCommodityTypeCountQryServiceReqBo reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getCommodityIdList())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61[commodityIdList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

