/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.extension.ability.impl;

import com.tydic.commodity.base.enumType.SkuEnum;
import com.tydic.commodity.base.extension.bo.BkLadderPriceBO;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.common.extension.ability.api.BkUccQrySkuBySpecAbilityService;
import com.tydic.commodity.common.extension.ability.bo.BkUccQeySkuBySpecForOrderInfoBO;
import com.tydic.commodity.common.extension.ability.bo.BkUccQrySkuBySpecAbilityReqBO;
import com.tydic.commodity.common.extension.ability.bo.BkUccQrySkuBySpecAbilityRspBO;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSmcsdkSkuStockInfoMapper;
import com.tydic.commodity.extension.dao.BkUccAreaPriceMapper;
import com.tydic.commodity.extension.dao.BkUccMallVendorMapper;
import com.tydic.commodity.extension.dao.BkUccParamsConfigExtMapper;
import com.tydic.commodity.extension.dao.BkUccSkuMapper;
import com.tydic.commodity.extension.po.BkUccAreaPricePo;
import com.tydic.commodity.extension.po.BkUccParamsConfigExtPO;
import com.tydic.commodity.extension.po.BkUccQrySkuSpecPO;
import com.tydic.commodity.extension.po.BkUccVendorPo;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.UccSkuPicPo;
import com.tydic.commodity.po.UccSmcsdkSkuStockInfoPO;
import com.tydic.commodity.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/3.1.0/com.tydic.commodity.common.extension.ability.api.BkUccQrySkuBySpecAbilityService"})
public class BkUccQrySkuBySpecAbilityServiceImpl
implements BkUccQrySkuBySpecAbilityService {
    private static final Logger log = LoggerFactory.getLogger(BkUccQrySkuBySpecAbilityServiceImpl.class);
    @Autowired
    private BkUccSkuMapper uccSkuMapper;
    @Autowired
    private UccBaseDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccSmcsdkSkuStockInfoMapper uccSmcsdkSkuStockInfoMapper;
    @Autowired
    private BkUccMallVendorMapper uccMallVendorMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private BkUccAreaPriceMapper uccAreaPriceMapper;
    @Autowired
    private BkUccParamsConfigExtMapper uccParamsConfigExtMapper;

    @PostMapping(value={"qrySkuSpec"})
    public BkUccQrySkuBySpecAbilityRspBO qrySkuSpec(@RequestBody BkUccQrySkuBySpecAbilityReqBO reqBO) {
        Long skuId;
        BkUccQrySkuBySpecAbilityRspBO rspBO = this.checkReqBo(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        Long commodityId = reqBO.getCommodityId();
        List uccQrySkuSpecPOList = this.uccSkuMapper.qrySkuInfoByCommodityIdAndSkuId(commodityId, skuId = reqBO.getSkuId());
        if (!CollectionUtils.isEmpty((Collection)uccQrySkuSpecPOList)) {
            BkUccQrySkuSpecPO uccQrySkuSpecPO = (BkUccQrySkuSpecPO)uccQrySkuSpecPOList.get(0);
            BeanUtils.copyProperties((Object)uccQrySkuSpecPO, (Object)rspBO);
            DicDictionaryPo dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(uccQrySkuSpecPO.getSkuStatus()), SkuEnum.SKU_STATUS.toString());
            if (null != dicDictionaryPo) {
                rspBO.setSkuStatusDesc(dicDictionaryPo.getTitle());
            }
            Long salePrice = uccQrySkuSpecPO.getSalePrice();
            Long agreementPrice = uccQrySkuSpecPO.getAgreementPrice();
            if (null != salePrice) {
                rspBO.setSalePrice(MoneyUtils.haoToYuan((Long)salePrice));
            }
            if ("2".equals(reqBO.getIsprofess()) && null != agreementPrice) {
                rspBO.setSalePrice(MoneyUtils.haoToYuan((Long)agreementPrice));
            }
            rspBO.setIsShowPrice(Integer.valueOf(1));
            if (rspBO.getAgrType() != null && rspBO.getAgrType() == 1) {
                if (rspBO.getAreaPrice() != null && rspBO.getAreaPrice() == 1) {
                    String orgPath = reqBO.getOrgPath();
                    log.debug("\u66ff\u6362\u4e13\u5c5e\u4ef7\u683c\u4f20\u5165orgPath\uff1a" + orgPath);
                    BkUccAreaPricePo uccAreaPricePo = new BkUccAreaPricePo();
                    uccAreaPricePo.setSkuId(rspBO.getSkuId());
                    uccAreaPricePo.setSupplierShopId(rspBO.getSupplierShopId());
                    if (!StringUtils.isEmpty((Object)reqBO.getOrgPath())) {
                        List orgIds = Arrays.stream(orgPath.split("-")).map(Long::valueOf).collect(Collectors.toList());
                        uccAreaPricePo.setOrgIds(orgIds);
                    } else {
                        uccAreaPricePo.setOrgId(reqBO.getOrgId());
                    }
                    List uccAreaPricePos = this.uccAreaPriceMapper.queryAreaPrice(uccAreaPricePo);
                    if (!CollectionUtils.isEmpty((Collection)uccAreaPricePos)) {
                        Map<Long, List<BkUccAreaPricePo>> orgIdMap = uccAreaPricePos.stream().collect(Collectors.groupingBy(BkUccAreaPricePo::getOrgId));
                        if (reqBO.getOrgId() != null) {
                            if (orgIdMap.get(reqBO.getOrgId()) != null) {
                                rspBO.setSalePrice(MoneyUtils.haoToYuan((Long)orgIdMap.get(reqBO.getOrgId()).get(0).getSalePrice()));
                            } else {
                                if (StringUtils.isEmpty((Object)reqBO.getOrgPath())) {
                                    orgPath = String.valueOf(reqBO.getOrgId());
                                }
                                List orgIds = Arrays.stream(orgPath.split("-")).map(Long::valueOf).collect(Collectors.toList());
                                for (int i = orgIds.size() - 1; i >= 0; --i) {
                                    Long parentOrgId = (Long)orgIds.get(i);
                                    rspBO.setIsShowPrice(Integer.valueOf(0));
                                    if (parentOrgId.equals(reqBO.getOrgId()) || orgIdMap.get(parentOrgId) == null) continue;
                                    rspBO.setSalePrice(MoneyUtils.haoToYuan((Long)orgIdMap.get(parentOrgId).get(0).getSalePrice()));
                                    rspBO.setIsShowPrice(Integer.valueOf(1));
                                    break;
                                }
                            }
                        } else {
                            rspBO.setIsShowPrice(Integer.valueOf(0));
                        }
                    } else {
                        rspBO.setIsShowPrice(Integer.valueOf(0));
                    }
                } else if (!Objects.isNull(reqBO.getMemUserType()) && reqBO.getMemUserType() == 2) {
                    rspBO.setIsShowPrice(Integer.valueOf(0));
                }
            } else if (uccQrySkuSpecPO.getAgreementPriceId() != null) {
                BkUccParamsConfigExtPO uccParamsConfigExtPO = new BkUccParamsConfigExtPO();
                uccParamsConfigExtPO.setConfigId(uccQrySkuSpecPO.getAgreementPriceId());
                List list = this.uccParamsConfigExtMapper.getList(uccParamsConfigExtPO);
                ArrayList<BkLadderPriceBO> ladderPrice = new ArrayList<BkLadderPriceBO>();
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    List collect = list.stream().filter(a -> a.getType() == 2).map(BkUccParamsConfigExtPO::getAmount).collect(Collectors.toList());
                    for (BkUccParamsConfigExtPO mallParamsConfigExtPO : list) {
                        BkLadderPriceBO uccMallLadderPriceBo = new BkLadderPriceBO();
                        if (mallParamsConfigExtPO.getType() == 4 && mallParamsConfigExtPO.getAmount() != -1L) {
                            uccMallLadderPriceBo.setStartPrice(new BigDecimal(0));
                            uccMallLadderPriceBo.setStopPrice(new BigDecimal(mallParamsConfigExtPO.getAmount()));
                            uccMallLadderPriceBo.setPrice(rspBO.getSalePrice().multiply(mallParamsConfigExtPO.getPriceRule()));
                            ladderPrice.add(uccMallLadderPriceBo);
                        }
                        if (mallParamsConfigExtPO.getAmount() != -1L) continue;
                        uccMallLadderPriceBo.setStartPrice(new BigDecimal((Long)collect.get(0)));
                        uccMallLadderPriceBo.setPrice(rspBO.getSalePrice().multiply(mallParamsConfigExtPO.getPriceRule()));
                        ladderPrice.add(uccMallLadderPriceBo);
                    }
                    rspBO.setLadderPrice(ladderPrice);
                }
            }
            List stockInfoPOList = this.uccSmcsdkSkuStockInfoMapper.getListBySku(Arrays.asList(uccQrySkuSpecPO.getSkuId()));
            if (CollectionUtils.isEmpty((Collection)stockInfoPOList)) {
                rspBO.setUnSaleNum(BigDecimal.ZERO);
            } else {
                rspBO.setUnSaleNum(MoneyUtils.haoToYuan((Long)((UccSmcsdkSkuStockInfoPO)stockInfoPOList.get(0)).getUnsaleNum()));
            }
            BkUccQeySkuBySpecForOrderInfoBO orderInfoBO = this.doGetForOrderInfo(uccQrySkuSpecPO.getSkuId(), commodityId, uccQrySkuSpecPO.getSupplierShopId());
            orderInfoBO.setAgrId(uccQrySkuSpecPO.getAgreementId());
            orderInfoBO.setOrderSource(String.valueOf(this.transferOrderSource(uccQrySkuSpecPO.getSkuSource())));
            orderInfoBO.setSkuName(uccQrySkuSpecPO.getSkuName());
            rspBO.setOrderInfoBO(orderInfoBO);
        }
        return rspBO;
    }

    private Integer transferOrderSource(Integer skuSource) {
        if (null == skuSource) {
            return 3;
        }
        switch (skuSource) {
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
        }
        return 3;
    }

    private BkUccQeySkuBySpecForOrderInfoBO doGetForOrderInfo(Long skuId, Long commodityId, Long supplierShopId) {
        BkUccVendorPo uccVendorPo;
        BkUccQeySkuBySpecForOrderInfoBO orderInfoBO = new BkUccQeySkuBySpecForOrderInfoBO();
        UccSkuPicPo queryPo = new UccSkuPicPo();
        queryPo.setSupplierShopId(supplierShopId);
        queryPo.setSkuId(skuId);
        queryPo.setCommodityPicType(Integer.valueOf(1));
        List uccSkuPicPos = this.uccSkuPicMapper.qeurySkuPic(queryPo);
        if (!CollectionUtils.isEmpty((Collection)uccSkuPicPos)) {
            orderInfoBO.setSkuMainPicUrl(((UccSkuPicPo)uccSkuPicPos.get(0)).getSkuPicUrl());
        }
        if (null != (uccVendorPo = this.uccMallVendorMapper.selectVendorByCommodityIdAndsupplierShopId(commodityId, supplierShopId))) {
            orderInfoBO.setGoodsSupplierId(String.valueOf(uccVendorPo.getVendorId()));
            orderInfoBO.setSkuSupplierName(uccVendorPo.getVendorName());
        }
        orderInfoBO.setPurchType(Integer.valueOf(1));
        return orderInfoBO;
    }

    private BkUccQrySkuBySpecAbilityRspBO checkReqBo(BkUccQrySkuBySpecAbilityReqBO reqBO) {
        BkUccQrySkuBySpecAbilityRspBO rspBO = new BkUccQrySkuBySpecAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (null == reqBO) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (null == reqBO.getCommodityId()) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        return rspBO;
    }
}

