/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.tydic.commodity.common.ability.api.UccQueryMaterialClassifyService;
import com.tydic.commodity.common.ability.bo.UccQueryMaterialClassifyReqBO;
import com.tydic.commodity.common.ability.bo.UccQueryMaterialClassifyRspBO;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.po.CnncUccMaterialClassifyPO;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccQueryMaterialClassifyService"})
public class UccQueryMaterialClassifyServiceImpl
implements UccQueryMaterialClassifyService {
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;

    @PostMapping(value={"queryMaterialClassify"})
    public UccQueryMaterialClassifyRspBO queryMaterialClassify(@RequestBody UccQueryMaterialClassifyReqBO reqBO) {
        UccQueryMaterialClassifyRspBO rspBO = new UccQueryMaterialClassifyRspBO();
        if (reqBO.getCommodityTypeId() == null || reqBO.getCommodityTypeId() == 0L) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5546\u54c1\u7c7b\u578bid\u4e3a\u7a7a");
            return rspBO;
        }
        UccCommodityTypePo uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(reqBO.getCommodityTypeId());
        if (uccCommodityTypePo == null) {
            rspBO.setRespCode("0002");
            rspBO.setRespDesc("\u8be5\u5546\u54c1\u7c7b\u578b\u4e0d\u5b58\u5728");
            return rspBO;
        }
        if (uccCommodityTypePo.getCommodityTypeStatus() == 0) {
            rspBO.setRespCode("0002");
            rspBO.setRespDesc("\u8be5\u5546\u54c1\u7c7b\u578b\u5df2\u505c\u7528");
            return rspBO;
        }
        CnncUccMaterialClassifyPO cnncUccMaterialClassifyPO = this.uccEMdmCatalogMapper.queryCatalogByCommodityType(reqBO.getCommodityTypeId());
        if (cnncUccMaterialClassifyPO != null) {
            if (cnncUccMaterialClassifyPO.getCatalogId() == null) {
                rspBO.setRespCode("0002");
                rspBO.setRespDesc("\u8be5\u5546\u54c1\u7c7b\u578b\u6ca1\u6709\u5173\u8054\u7269\u6599\u5206\u7c7b");
                return rspBO;
            }
            if (cnncUccMaterialClassifyPO.getFreezeFlag() == 1) {
                rspBO.setFreezeFlag(Integer.valueOf(1));
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u8be5\u5546\u54c1\u7c7b\u578b\u5173\u8054\u7684\u7269\u6599\u5206\u7c7b\u5df2\u505c\u7528");
                return rspBO;
            }
            rspBO.setFreezeFlag(Integer.valueOf(0));
            List<UccEMdmCatalogPO> poList = this.findParent(cnncUccMaterialClassifyPO.getCatalogId());
            if (!CollectionUtils.isEmpty(poList)) {
                Collections.sort(poList, new Comparator<UccEMdmCatalogPO>(){

                    @Override
                    public int compare(UccEMdmCatalogPO o1, UccEMdmCatalogPO o2) {
                        return o1.getCatalogLevel() - o2.getCatalogLevel();
                    }
                });
                StringBuilder sb = new StringBuilder("");
                poList.stream().forEach(a -> {
                    if (!"".equals(sb.toString())) {
                        sb.append("-");
                    }
                    sb.append(a.getCatalogName());
                });
                rspBO.setCatalogName(sb.toString());
            }
            rspBO.setCatalogId(cnncUccMaterialClassifyPO.getCatalogId());
            rspBO.setCatalogCode(cnncUccMaterialClassifyPO.getCatalogCode());
            rspBO.setCommodityTypeName(cnncUccMaterialClassifyPO.getCommodityTypeName());
            rspBO.setTaxCatCode(cnncUccMaterialClassifyPO.getTaxCatCode());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        rspBO.setRespCode("0002");
        rspBO.setRespDesc("\u8be5\u5546\u54c1\u7c7b\u578b\u6ca1\u6709\u5173\u8054\u7269\u6599\u5206\u7c7b");
        return rspBO;
    }

    List<UccEMdmCatalogPO> findParent(Long catalogId) {
        ArrayList<UccEMdmCatalogPO> poList = new ArrayList<UccEMdmCatalogPO>();
        UccEMdmCatalogPO po = this.uccEMdmCatalogMapper.queryById(catalogId);
        if (po == null) {
            return poList;
        }
        poList.add(po);
        if (po.getCatalogLevel() == 1) {
            return poList;
        }
        List<UccEMdmCatalogPO> parent = this.findParent(po.getParentCatalogId());
        poList.addAll(parent);
        return poList;
    }
}

