/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.busibase.comb.api.UccCodegenerationCombService;
import com.tydic.commodity.busibase.comb.bo.UccCodegenerationCombReqBO;
import com.tydic.commodity.busibase.comb.bo.UccCodegenerationCombRspBO;
import com.tydic.commodity.common.ability.bo.ApplyForSaleSkuInfoBO;
import com.tydic.commodity.common.busi.api.UccApplyForSaleSubmitBusiService;
import com.tydic.commodity.common.busi.bo.UccApplyForSaleSubmitBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccApplyForSaleSubmitBusiRspBO;
import com.tydic.commodity.dao.UccApplyForListItemMapper;
import com.tydic.commodity.dao.UccApplyForListMapper;
import com.tydic.commodity.dao.UccDicDictionaryMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.UccApplyForListItemPo;
import com.tydic.commodity.po.UccApplyForListPo;
import com.tydic.osworkflow.ability.OsworkflowStartProcAbilityService;
import com.tydic.osworkflow.ability.bo.StartWithInstanceReqBO;
import com.tydic.osworkflow.ability.bo.StartWithInstanceRespBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UccApplyForSaleSubmitBusiServiceImpl
implements UccApplyForSaleSubmitBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccApplyForSaleSubmitBusiServiceImpl.class);
    @Autowired
    private UccApplyForListMapper uccApplyForListMapper;
    @Autowired
    private UccApplyForListItemMapper uccApplyForListItemMapper;
    @Autowired
    private UccDicDictionaryMapper uccDicDictionaryMapper;
    @Autowired
    private OsworkflowStartProcAbilityService osworkflowStartProcAbilityService;
    @Value(value="WOC_APPLY_ON_SHELVES")
    private String procDefKey;
    @Value(value="${process.sysCode:DYC}")
    private String SYS_CODE;
    private static final String P_CODE = "WORK_ORDER_STATE";
    @Autowired
    private UccCodegenerationCombService uccCodegenerationCombService;

    @Override
    public UccApplyForSaleSubmitBusiRspBO applyForSaleAdd(UccApplyForSaleSubmitBusiReqBO reqBO) {
        UccApplyForSaleSubmitBusiRspBO rspBO = new UccApplyForSaleSubmitBusiRspBO();
        try {
            Long applyId = this.createAppply(reqBO);
            this.startWorkFlow(reqBO, applyId);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Long createAppply(UccApplyForSaleSubmitBusiReqBO reqBO) {
        UccApplyForListPo recordV = new UccApplyForListPo();
        Long applyId = Sequence.getInstance().nextId();
        recordV.setWorkOrderId(applyId);
        UccCodegenerationCombReqBO uccCodegenerationCombReqBO = new UccCodegenerationCombReqBO();
        uccCodegenerationCombReqBO.setCodeType("18");
        uccCodegenerationCombReqBO.setCount(Integer.valueOf(1));
        UccCodegenerationCombRspBO uccCodegenerationCombRspBO = this.uccCodegenerationCombService.dealUccCodegeneration(uccCodegenerationCombReqBO);
        if (!"0000".equals(uccCodegenerationCombRspBO.getRespCode())) {
            throw new ZTBusinessException(uccCodegenerationCombRspBO.getRespDesc());
        }
        recordV.setWorkOrderCode((String)uccCodegenerationCombRspBO.getCodeList().get(0));
        recordV.setSupplierId(reqBO.getSupplierId());
        recordV.setSupplierName(reqBO.getSupplierName());
        recordV.setApplicantTel(reqBO.getCellphone());
        recordV.setApplicantOrgId(reqBO.getOrgId().toString());
        recordV.setApplicantOrgName(reqBO.getOrgName());
        recordV.setApplicantId(reqBO.getUserId().toString());
        recordV.setApplicantName(reqBO.getName());
        recordV.setApplicantTime(new Date());
        recordV.setRemark(reqBO.getRemark());
        recordV.setWorkOrderState(UccConstants.WorkOrderState.TO_BE_ACCEPTED.toString());
        DicDictionaryPo dictionaryPo = this.uccDicDictionaryMapper.selectdictionaryByCodeAndCode(UccConstants.WorkOrderState.TO_BE_ACCEPTED.toString(), P_CODE);
        if (ObjectUtil.isEmpty((Object)dictionaryPo)) {
            throw new ZTBusinessException("\u7533\u8bf7\u4e0a\u67b6\u670d\u52a1\u5355\u72b6\u6001\u5b57\u5178\u503c\u672a\u914d\u7f6e");
        }
        recordV.setWorkOrderStateDesc(dictionaryPo.getTitle());
        recordV.setCreateTime(new Date());
        ArrayList<Long> tempList = new ArrayList<Long>();
        tempList.add(reqBO.getOrgId());
        if (!reqBO.getOrgId().toString().equals(reqBO.getSupplierOrgId())) {
            tempList.add(Long.parseLong(reqBO.getSupplierOrgId()));
        }
        String str = JSONObject.toJSONString(tempList);
        recordV.setProcessorOrgIdGroup(str);
        this.uccApplyForListMapper.insertSelective(recordV);
        for (ApplyForSaleSkuInfoBO each : reqBO.getRuWoBusinessReqBOList()) {
            UccApplyForListItemPo itemPo = new UccApplyForListItemPo();
            itemPo.setWorkOrderItemId(Long.valueOf(Sequence.getInstance().nextId()));
            itemPo.setWorkOrderId(applyId);
            itemPo.setWorkOrderCode(reqBO.getBusinessCode());
            itemPo.setSkuName(each.getName());
            itemPo.setCommodityTypeName(each.getType());
            itemPo.setCommodityTypeCode(each.getCode());
            itemPo.setSpec(each.getSpec());
            itemPo.setModel(each.getModel());
            itemPo.setDemandNum(each.getNum());
            itemPo.setExpectTime(each.getDate());
            itemPo.setRemark(each.getRemark());
            itemPo.setCreateTime(new Date());
            itemPo.setReferLink(each.getReferLink());
            itemPo.setReferPicture(JSON.toJSONString((Object)each.getReferPictureList()));
            this.uccApplyForListItemMapper.insertSelective(itemPo);
        }
        return applyId;
    }

    private void startWorkFlow(UccApplyForSaleSubmitBusiReqBO reqBO, Long applyId) {
        StartWithInstanceReqBO instanceReqBO = new StartWithInstanceReqBO();
        HashMap<String, String> variables = new HashMap<String, String>();
        ArrayList<Long> tempList = new ArrayList<Long>();
        tempList.add(reqBO.getOrgId());
        if (!reqBO.getOrgId().toString().equals(reqBO.getSupplierOrgId())) {
            tempList.add(Long.parseLong(reqBO.getSupplierOrgId()));
        }
        String str = JSONObject.toJSONString(tempList);
        variables.put("processorOrgIdGroup", str);
        variables.put("applicantId", reqBO.getUserId().toString());
        variables.put("applicantName", reqBO.getName());
        variables.put("applicantTel", reqBO.getCellphone());
        variables.put("applicantOrgId", reqBO.getOrgId().toString());
        variables.put("applicantOrgName", reqBO.getOrgName());
        instanceReqBO.setProcDefKey(this.procDefKey);
        instanceReqBO.setVariables(variables);
        instanceReqBO.setPartitonKey(applyId.toString());
        instanceReqBO.setSysCode(this.SYS_CODE);
        instanceReqBO.setBusinessId(applyId.toString());
        StartWithInstanceRespBO instanceRespBO = null;
        try {
            log.info("\u8c03\u7528\u6d41\u7a0b\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)instanceReqBO));
            instanceRespBO = this.osworkflowStartProcAbilityService.startWithInstanceByMq(instanceReqBO);
            log.info("\u8c03\u7528\u6d41\u7a0b\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)instanceRespBO));
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u8c03\u7528\u65b0\u6d41\u7a0b\u4e2d\u5fc3\u62a5\u9519\uff1a" + e.getMessage());
        }
        if (!"0000".equals(instanceRespBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u65b0\u6d41\u7a0b\u4e2d\u5fc3\u62a5\u9519\uff1a" + instanceRespBO.getRespDesc());
        }
    }
}

