/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.extension.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.enumType.GuideCatalogEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.base.extension.constant.UccConstants;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.busi.impl.UccCatalogAddBusiServiceImpl;
import com.tydic.commodity.common.extension.ability.bo.BkUccCatalogAddReqBO;
import com.tydic.commodity.common.extension.ability.bo.BkUccCatalogAddRspBO;
import com.tydic.commodity.common.extension.busi.api.BkUccCatalogAddBusiService;
import com.tydic.commodity.dao.UccCatRCommdTypeMapper;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.po.UccCatalogConnectCommdTypeDealPO;
import com.tydic.commodity.po.UccCatalogDealPO;
import com.tydic.commodity.po.UccCommodityTypePo;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BkUccCatalogAddBusiServiceImpl
implements BkUccCatalogAddBusiService {
    @Autowired
    private UccCatalogDealMapper mapper;
    private Sequence uccBrandSequence = Sequence.getInstance();
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccCatRCommdTypeMapper uccCatRCommdTypeMapper;
    BkUccCatalogAddRspBO rspBO = new BkUccCatalogAddRspBO();
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCatalogAddBusiServiceImpl.class);

    @Override
    public BkUccCatalogAddRspBO addCatalog(BkUccCatalogAddReqBO reqBO) {
        if (!this.judge(reqBO)) {
            this.rspBO.setRespCode("8888");
            return this.rspBO;
        }
        this.dealOrder(reqBO);
        this.rspBO = new BkUccCatalogAddRspBO();
        UccCatalogDealPO catalogDealPO = new UccCatalogDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)catalogDealPO);
        int result = 0;
        try {
            long id = this.uccBrandSequence.nextId();
            catalogDealPO.setGuideCatalogId(Long.valueOf(id));
            result = this.mapper.addCatalog(catalogDealPO);
            if (reqBO.getCatalogLevel() == 3) {
                UccCommodityTypePo uccCommodityTypePo = new UccCommodityTypePo();
                uccCommodityTypePo.setCommodityTypeId(Long.valueOf(id));
                uccCommodityTypePo.setCommodityTypeName(reqBO.getCatalogName());
                uccCommodityTypePo.setCommodityTypeStatus(UccConstants.COMMODITY_TYPE_STATUS_START);
                uccCommodityTypePo.setCreateOperId(reqBO.getUsername());
                uccCommodityTypePo.setCreateTime(new Date());
                this.uccCommodityTypeMapper.addCommdType(uccCommodityTypePo);
                UccCatalogConnectCommdTypeDealPO po = new UccCatalogConnectCommdTypeDealPO();
                po.setCommodityTypeId(Long.valueOf(id));
                po.setGuideCatalogId(Long.valueOf(id));
                po.setRelId(Long.valueOf(this.uccBrandSequence.nextId()));
                po.setCreateOperId(reqBO.getUsername());
                this.uccCatRCommdTypeMapper.addData(po);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u6570\u636e\u5e93\u6dfb\u52a0\u5f02\u5e38");
        }
        if (result > 0) {
            this.rspBO.setRespCode("0000");
            this.rspBO.setRespDesc("\u63d2\u5165\u7c7b\u76ee\u6210\u529f");
            this.rspBO.setGuideCatalogId(catalogDealPO.getGuideCatalogId());
        } else {
            this.rspBO.setRespCode("8888");
            this.rspBO.setRespDesc("\u63d2\u5165\u7c7b\u76ee\u5931\u8d25");
        }
        return this.rspBO;
    }

    public boolean judge(BkUccCatalogAddReqBO reqBO) {
        Map<String, String> map = null;
        if (reqBO.getCatalogName() == null || reqBO.getCatalogName().equals("")) {
            this.rspBO.setRespDesc("\u63d2\u5165\u7c7b\u76ee\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        List uccCatalogDealPOS = this.mapper.queryByCatalogName2(reqBO.getCatalogName());
        if (!CollectionUtils.isEmpty((Collection)uccCatalogDealPOS)) {
            this.rspBO.setRespDesc("\u60a8\u6240\u8f93\u5165\u7684\u5546\u54c1\u7c7b\u76ee\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5");
            return false;
        }
        if (reqBO.getCatalogLevel() != null) {
            map = this.uccDictionaryAtomService.queryBypCodeBackMap(GuideCatalogEnum.GUIDE_CATALOG_LEVEL.toString());
            if (!map.containsKey(String.valueOf(reqBO.getCatalogLevel()))) {
                this.rspBO.setRespDesc("\u7c7b\u76ee\u7b49\u7ea7\u8f93\u5165\u9519\u8bef");
                return false;
            }
            if (reqBO.getCatalogLevel() == 1) {
                reqBO.setUpperCatalogId(Long.valueOf(0L));
            } else if (reqBO.getUpperCatalogId() == null) {
                this.rspBO.setRespDesc("\u8bf7\u9009\u62e9\u4e0a\u7ea7\u7c7b\u76ee");
                this.rspBO.setGuideCatalogId(null);
                return false;
            }
        } else {
            this.rspBO.setRespDesc("\u7c7b\u76ee\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (reqBO.getCatalogCode() == null || reqBO.getCatalogCode().equals("")) {
            this.rspBO.setRespDesc("\u7c7b\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (reqBO.getShopCatalogType() == null) {
            this.rspBO.setRespDesc("\u7c7b\u76ee\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (reqBO.getCatalogStatus() == null) {
            this.rspBO.setRespDesc("\u7c7b\u76ee\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        map = this.uccDictionaryAtomService.queryBypCodeBackMap(GuideCatalogEnum.GUIDE_CATALOG_STATUS.toString());
        if (!map.containsKey(String.valueOf(reqBO.getCatalogStatus()))) {
            this.rspBO.setRespDesc("\u7c7b\u76ee\u72b6\u6001\u8f93\u5165\u9519\u8bef");
            return false;
        }
        if (reqBO.getViewOrder() == null) {
            this.rspBO.setRespDesc("\u7c7b\u76ee\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        return true;
    }

    private void dealOrder(BkUccCatalogAddReqBO reqBO) {
        UccCatalogDealPO uccCatalogDealPO = new UccCatalogDealPO();
        uccCatalogDealPO.setUpperCatalogId(reqBO.getUpperCatalogId());
        uccCatalogDealPO.setOrderStr("VIEW_ORDER");
        uccCatalogDealPO.setChannelId(reqBO.getChannelId());
        List uccCatalogDealPOList = this.mapper.queryCatalog(uccCatalogDealPO);
        if (uccCatalogDealPOList == null || uccCatalogDealPOList.size() == 0) {
            reqBO.setViewOrder(Integer.valueOf(0));
            return;
        }
        if (uccCatalogDealPOList != null && uccCatalogDealPOList.size() > 0) {
            Integer maxOrder = ((UccCatalogDealPO)uccCatalogDealPOList.get(uccCatalogDealPOList.size() - 1)).getViewOrder();
            if (maxOrder == null) {
                return;
            }
            if (reqBO.getOrderConfSolution() != null) {
                if (reqBO.getOrderConfSolution() == 0) {
                    uccCatalogDealPO.setViewOrder(reqBO.getViewOrder());
                    this.mapper.modifyOrder(uccCatalogDealPO);
                } else if (reqBO.getOrderConfSolution() == 1) {
                    maxOrder = maxOrder + 1;
                    this.mapper.modifyOrderByViewOrder(reqBO.getViewOrder(), maxOrder, uccCatalogDealPO);
                } else if (reqBO.getOrderConfSolution() == 2) {
                    uccCatalogDealPO.setViewOrder(Integer.valueOf(reqBO.getViewOrder() + 1));
                    this.mapper.modifyOrder(uccCatalogDealPO);
                    reqBO.setViewOrder(Integer.valueOf(reqBO.getViewOrder() + 1));
                } else {
                    reqBO.setViewOrder(Integer.valueOf(maxOrder + 1));
                }
            } else {
                reqBO.setViewOrder(Integer.valueOf(maxOrder + 1));
            }
        }
    }
}

