/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.UccEMdmMaterialBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.common.ability.api.UccThematerialsearchAbilityService;
import com.tydic.commodity.common.ability.bo.UccThematerialsearchAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccThematerialsearchAbilityRspBO;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.dao.UccAssignCodeApplyMapper;
import com.tydic.commodity.dao.UccCommodityMeasureMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccAssignCodeApplyPO;
import com.tydic.commodity.po.UccCommodityMeasurePo;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccThematerialsearchAbilityService"})
public class UccThematerialsearchAbilityServiceImpl
implements UccThematerialsearchAbilityService {
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccAssignCodeApplyMapper uccAssignCodeApplyMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMeasureMapper uccCommodityMeasureMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    @PostMapping(value={"dealUccThematerialsearch"})
    public UccThematerialsearchAbilityRspBO dealUccThematerialsearch(@RequestBody UccThematerialsearchAbilityReqBO reqBO) {
        List poList;
        UccThematerialsearchAbilityRspBO rspBO = new UccThematerialsearchAbilityRspBO();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UccEMdmMaterialPO po = new UccEMdmMaterialPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        if (po.getIsDelete() == null) {
            po.setIsDelete(Integer.valueOf(0));
        }
        if (CollectionUtils.isEmpty((Collection)(poList = this.uccEMdmMaterialMapper.searchMaterial(po, page)))) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        for (UccEMdmMaterialPO each : poList) {
            if (StringUtils.isEmpty((Object)each.getMeasure())) continue;
            UccCommodityMeasurePo temp = new UccCommodityMeasurePo();
            temp.setMeasureNameExactly(each.getMeasure());
            List uccCommodityMeasurePos = this.uccCommodityMeasureMapper.queryMeasureByPO(temp);
            if (CollectionUtils.isEmpty((Collection)uccCommodityMeasurePos)) {
                each.setMeasure(null);
                continue;
            }
            each.setMeasureId(((UccCommodityMeasurePo)uccCommodityMeasurePos.get(0)).getMeasureId());
        }
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(reqBO.getPageNo());
        List uccEMdmMaterialBOS = JSONObject.parseArray((String)JSONObject.toJSONString((Object)poList), UccEMdmMaterialBO.class);
        List<UccEMdmMaterialBO> returnList = this.getAssignCodeApplyInfo(uccEMdmMaterialBOS);
        this.getSkuCodes(returnList);
        Map<String, String> isDeleteMap = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_E_MDM_MATERIAL_IS_DELETE");
        Map<String, String> freezbMap = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_E_MDM_MATERIAL_FREEZE_FLAG");
        Map<String, String> sourceMap = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_E_MDM_MATERIAL_SOURCE");
        Map<String, String> ooocCleanMap = this.uccDictionaryAtomService.queryBypCodeBackMap("OOOC_CLEAN");
        for (UccEMdmMaterialBO each : returnList) {
            if (isDeleteMap != null && isDeleteMap.containsKey(each.getIsDelete().toString())) {
                each.setIsDeleteDesc(isDeleteMap.get(each.getIsDelete().toString()));
            }
            if (freezbMap != null && freezbMap.containsKey(each.getFreezeFlag().toString())) {
                each.setFreezeFlagDesc(freezbMap.get(each.getFreezeFlag().toString()));
            }
            if (sourceMap == null || !sourceMap.containsKey(each.getSource().toString())) continue;
            each.setSourceDesc(sourceMap.get(each.getSource().toString()));
        }
        rspBO.setRows(returnList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void getSkuCodes(List<UccEMdmMaterialBO> uccEMdmMaterialBOS) {
        if (!CollectionUtils.isEmpty(uccEMdmMaterialBOS)) {
            uccEMdmMaterialBOS.forEach(uccEMdmMaterialBO -> {
                UccSkuPo uccSkuPo = new UccSkuPo();
                uccSkuPo.setMaterialId(uccEMdmMaterialBO.getMaterialId() + "");
                uccSkuPo.setSkuType(ModelRuleConstant.SKU_TYPE_STANDARD);
                UccSkuPo getUccSkuPoStandard = this.uccSkuMapper.qerySkuCodesByMaterialId(uccSkuPo);
                if (ObjectUtil.isNotEmpty((Object)getUccSkuPoStandard)) {
                    ArrayList<String> stdSkuCodes = new ArrayList<String>();
                    stdSkuCodes.add(getUccSkuPoStandard.getSkuCode());
                    uccEMdmMaterialBO.setStdSkuCodes(stdSkuCodes);
                }
                uccSkuPo.setSkuType(ModelRuleConstant.SKU_TYPE_NORMAL);
                UccSkuPo getUccSkuPoNormal = this.uccSkuMapper.qerySkuCodesByMaterialId(uccSkuPo);
                if (ObjectUtil.isNotEmpty((Object)getUccSkuPoNormal)) {
                    ArrayList<String> skuCodes = new ArrayList<String>();
                    skuCodes.add(getUccSkuPoNormal.getSkuCode());
                    uccEMdmMaterialBO.setSkuCodes(skuCodes);
                }
            });
        }
    }

    private List<UccEMdmMaterialBO> getAssignCodeApplyInfo(List<UccEMdmMaterialBO> uccEMdmMaterialBOS) {
        ArrayList<UccEMdmMaterialBO> returnList = new ArrayList<UccEMdmMaterialBO>();
        if (!CollectionUtils.isEmpty(uccEMdmMaterialBOS)) {
            uccEMdmMaterialBOS.forEach(uccEMdmMaterialBO -> {
                UccAssignCodeApplyPO uccAssignCodeApplyPO = (UccAssignCodeApplyPO)JSONObject.parseObject((String)JSON.toJSONString((Object)uccEMdmMaterialBO), UccAssignCodeApplyPO.class);
                UccAssignCodeApplyPO modelByMaterialIdPO = this.uccAssignCodeApplyMapper.getModelBy(uccAssignCodeApplyPO);
                if (modelByMaterialIdPO != null) {
                    uccEMdmMaterialBO.setApplyId(modelByMaterialIdPO.getId());
                    uccEMdmMaterialBO.setApplyNo(modelByMaterialIdPO.getApplyNo());
                    returnList.add((UccEMdmMaterialBO)uccEMdmMaterialBO);
                }
            });
        }
        if (CollectionUtils.isEmpty(returnList)) {
            return uccEMdmMaterialBOS;
        }
        return returnList;
    }
}

