/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.extension.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.base.extension.bo.BkUccBatchSkuBO;
import com.tydic.commodity.base.extension.enumType.BkSkuStatusEnum;
import com.tydic.commodity.common.extension.ability.bo.BkUccCatalogDeleteReqBO;
import com.tydic.commodity.common.extension.ability.bo.BkUccCatalogDeleteRspBO;
import com.tydic.commodity.common.extension.busi.api.BkUccCatalogDeleteBusiService;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.extension.dao.BkUccCatalogDealMapper;
import com.tydic.commodity.po.UccCatalogDealPO;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BkUccCatalogDeleteBusiServiceImpl
implements BkUccCatalogDeleteBusiService {
    @Autowired
    private UccCatalogDealMapper mapper;
    @Autowired
    private BkUccCatalogDealMapper bkUccCatalogDealMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;

    @Override
    public BkUccCatalogDeleteRspBO deleteCatalog(BkUccCatalogDeleteReqBO reqBO) {
        int result;
        BkUccCatalogDeleteRspBO rspBO = new BkUccCatalogDeleteRspBO();
        if (reqBO.getGuideCatalogId() == null) {
            rspBO.setRespDesc("\u7c7b\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
            rspBO.setRespCode("8888");
            return rspBO;
        }
        UccCatalogDealPO po = new UccCatalogDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        if (this.mapper.selectCatalogById(po) == null) {
            rspBO.setRespDesc("\u7c7b\u76eeID\u4e0d\u5b58\u5728");
            rspBO.setRespCode("8888");
            return rspBO;
        }
        Integer count = this.mapper.selectCountById(reqBO.getGuideCatalogId());
        if (0 != count) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6b64\u7c7b\u76ee\u5b58\u5728\u5b50\u7c7b\u76ee\uff0c\u65e0\u6cd5\u5220\u9664");
            return rspBO;
        }
        ArrayList<BkUccBatchSkuBO> batchSkuList = new ArrayList<BkUccBatchSkuBO>();
        Long commodityTypeId = this.bkUccCatalogDealMapper.queryCommdTypeId(reqBO.getGuideCatalogId());
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(commodityTypeId);
        List skuList = this.uccSkuMapper.querySkuByCommTypeIds(list);
        if (!CollectionUtil.isEmpty((Collection)skuList)) {
            List ecDelSku = skuList.stream().filter(uccSkuPo -> uccSkuPo.getSkuSource() == ModelRuleConstant.SKU_SOURCE_COMMERCE_IMPORT && uccSkuPo.getSkuStatus() != BkSkuStatusEnum.DOWN_FRAME_STATUS.getStatus() && uccSkuPo.getSkuStatus() != BkSkuStatusEnum.EC_DOWN_STATUS.getStatus() && uccSkuPo.getSkuStatus() != BkSkuStatusEnum.DELETE_STATUS.getStatus() && uccSkuPo.getSkuStatus() != BkSkuStatusEnum.WARN_DOWN_STATUS.getStatus()).collect(Collectors.toList());
            List agrDownSku = skuList.stream().filter(uccSkuPo -> uccSkuPo.getSkuSource() == ModelRuleConstant.SKU_SOURCE_PROTOCOL_GENERATION && uccSkuPo.getSkuStatus() != BkSkuStatusEnum.DELETE_STATUS.getStatus() && uccSkuPo.getSkuStatus() != BkSkuStatusEnum.AGR_DELETE_STATUS.getStatus()).collect(Collectors.toList());
            if (!CollectionUtil.isEmpty(ecDelSku) || !CollectionUtil.isEmpty(agrDownSku)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u534f\u8bae\u5546\u54c1\u672a\u5220\u9664\u6216\u7535\u5546\u5546\u54c1\u672a\u4e0b\u67b6\uff0c\u8bf7\u6838\u67e5\u5546\u54c1\u6570\u636e");
                return rspBO;
            }
            List commodityIds = skuList.stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList());
            this.uccSkuMapper.batchDeleteSku(commodityIds);
            this.uccCommodityMapper.batchDeleteCommodity(commodityIds);
            for (UccSkuPo uccSkuPo2 : skuList) {
                BkUccBatchSkuBO bo = new BkUccBatchSkuBO();
                bo.setSupplierShopId(uccSkuPo2.getSupplierShopId());
                bo.setSkuId(uccSkuPo2.getSkuId());
                batchSkuList.add(bo);
            }
            rspBO.setBatchSkuList(batchSkuList);
        }
        UccCatalogDealPO uccCatalogDealPO = new UccCatalogDealPO();
        uccCatalogDealPO.setGuideCatalogId(reqBO.getGuideCatalogId());
        try {
            result = this.mapper.deleteCatalog(uccCatalogDealPO);
            UccCommodityTypePo uccCommodityTypePo = new UccCommodityTypePo();
            uccCommodityTypePo.setCommodityTypeId(reqBO.getGuideCatalogId());
            this.uccCommodityTypeMapper.deleteCommdType(uccCommodityTypePo);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u5220\u9664\u5bfc\u8d2d\u7c7b\u76ee\u5f02\u5e38");
        }
        if (result > 0) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5220\u9664\u7c7b\u76ee\u6210\u529f");
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5220\u9664\u7c7b\u76ee\u5931\u8d25");
        }
        return rspBO;
    }
}

