/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.extension.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.common.extension.ability.bo.BkUccMdmMaterialSyncBo;
import com.tydic.commodity.common.extension.busi.api.BkUccMdmMaterialSyncBusiService;
import com.tydic.commodity.common.extension.busi.bo.BkUccMdmMaterialSyncBusiReqBo;
import com.tydic.commodity.common.extension.busi.bo.BkUccMdmMaterialSyncBusiRspBo;
import com.tydic.commodity.extension.dao.BkUccEMdmCatalogMapper;
import com.tydic.commodity.extension.dao.BkUccEMdmMaterialMapper;
import com.tydic.commodity.extension.po.BkUccEMdmCatalogPO;
import com.tydic.commodity.extension.po.BkUccEMdmMaterialPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BkUccMdmMaterialSyncBusiServiceImpl
implements BkUccMdmMaterialSyncBusiService {
    @Autowired
    private BkUccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private BkUccEMdmCatalogMapper uccEMdmCatalogMapper;
    private static final Long DEFAULT_OPER_ID = 1L;

    @Override
    public BkUccMdmMaterialSyncBusiRspBo syncMdmMaterial(BkUccMdmMaterialSyncBusiReqBo reqBo) {
        BkUccMdmMaterialSyncBusiRspBo rspBo = new BkUccMdmMaterialSyncBusiRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty(reqBo.getUccMdmMaterialSyncBoList())) {
            return rspBo;
        }
        List<BkUccMdmMaterialSyncBo> uccMdmMaterialSyncBoList = reqBo.getUccMdmMaterialSyncBoList();
        List materialCodeList = uccMdmMaterialSyncBoList.stream().map(BkUccMdmMaterialSyncBo::getMaterialCode).distinct().collect(Collectors.toList());
        List catalogCodeList = uccMdmMaterialSyncBoList.stream().map(BkUccMdmMaterialSyncBo::getCatalogCode).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(materialCodeList)) {
            List uccEMdmMaterialPOS = this.uccEMdmMaterialMapper.batchQryByMaterialCodes(materialCodeList);
            List uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.getParentListByCodes(catalogCodeList);
            ConcurrentMap<String, BkUccEMdmMaterialPO> uuidMaterialMap = uccEMdmMaterialPOS.stream().collect(Collectors.toConcurrentMap(BkUccEMdmMaterialPO::getMaterialCode, o -> o));
            ConcurrentMap<String, Long> catalogCodeMap = null;
            if (!CollectionUtils.isEmpty((Collection)uccEMdmCatalogPOS)) {
                catalogCodeMap = uccEMdmCatalogPOS.stream().collect(Collectors.toConcurrentMap(BkUccEMdmCatalogPO::getCatalogCode, BkUccEMdmCatalogPO::getCatalogId, (old, cur) -> old));
            }
            ArrayList<BkUccEMdmMaterialPO> updatePoList = new ArrayList<BkUccEMdmMaterialPO>();
            ArrayList<BkUccEMdmMaterialPO> addPoList = new ArrayList<BkUccEMdmMaterialPO>();
            for (BkUccMdmMaterialSyncBo uccMdmMaterialSyncBo : uccMdmMaterialSyncBoList) {
                BkUccEMdmMaterialPO uccEMdmMaterialPO2 = (BkUccEMdmMaterialPO)uuidMaterialMap.get(uccMdmMaterialSyncBo.getMaterialCode());
                if (null != uccEMdmMaterialPO2) {
                    uccEMdmMaterialPO2.setMaterialName(uccMdmMaterialSyncBo.getMaterialName());
                    uccEMdmMaterialPO2.setLongDesc(uccMdmMaterialSyncBo.getLongDesc());
                    uccEMdmMaterialPO2.setBrandName(uccMdmMaterialSyncBo.getBrandName());
                    uccEMdmMaterialPO2.setMaterialCode(uccMdmMaterialSyncBo.getMaterialCode());
                    uccEMdmMaterialPO2.setShortDesc(uccMdmMaterialSyncBo.getShortDesc());
                    uccEMdmMaterialPO2.setTexture(uccMdmMaterialSyncBo.getTexture());
                    uccEMdmMaterialPO2.setFigure(uccMdmMaterialSyncBo.getFigure());
                    uccEMdmMaterialPO2.setModel(uccMdmMaterialSyncBo.getModel());
                    uccEMdmMaterialPO2.setSpec(uccMdmMaterialSyncBo.getSpec());
                    uccEMdmMaterialPO2.setMainModel(uccMdmMaterialSyncBo.getMainModel());
                    uccEMdmMaterialPO2.setManufacturer(uccMdmMaterialSyncBo.getManufacturer());
                    uccEMdmMaterialPO2.setMeasureCode(uccMdmMaterialSyncBo.getMeasure());
                    uccEMdmMaterialPO2.setRemark(uccMdmMaterialSyncBo.getRemark());
                    uccEMdmMaterialPO2.setUpdateTime(new Date());
                    if (null != uccMdmMaterialSyncBo.getUpdateLoginId()) {
                        uccEMdmMaterialPO2.setUpdateLoginId(uccMdmMaterialSyncBo.getUpdateLoginId());
                    } else {
                        uccEMdmMaterialPO2.setUpdateLoginId(DEFAULT_OPER_ID);
                    }
                    if (null != catalogCodeMap) {
                        uccEMdmMaterialPO2.setCatalogId((Long)catalogCodeMap.get(uccMdmMaterialSyncBo.getCatalogCode()));
                    }
                    uccEMdmMaterialPO2.setCatalogCode(uccMdmMaterialSyncBo.getCatalogCode());
                    updatePoList.add(uccEMdmMaterialPO2);
                    continue;
                }
                uccEMdmMaterialPO2 = (BkUccEMdmMaterialPO)JSON.parseObject((String)JSON.toJSONString((Object)uccMdmMaterialSyncBo), BkUccEMdmMaterialPO.class);
                uccEMdmMaterialPO2.setMaterialId(Long.valueOf(Sequence.getInstance().nextId()));
                uccEMdmMaterialPO2.setMeasureCode(uccMdmMaterialSyncBo.getMeasure());
                if (null != uccMdmMaterialSyncBo.getCreateTime()) {
                    uccEMdmMaterialPO2.setCreateTime(uccMdmMaterialSyncBo.getCreateTime());
                } else {
                    uccEMdmMaterialPO2.setCreateTime(new Date());
                }
                if (null != uccMdmMaterialSyncBo.getCreateLoginId()) {
                    uccEMdmMaterialPO2.setCreateLoginId(uccMdmMaterialSyncBo.getUpdateLoginId());
                } else {
                    uccEMdmMaterialPO2.setCreateLoginId(DEFAULT_OPER_ID);
                }
                if (null != catalogCodeMap) {
                    uccEMdmMaterialPO2.setCatalogId((Long)catalogCodeMap.get(uccMdmMaterialSyncBo.getCatalogCode()));
                }
                uccEMdmMaterialPO2.setCatalogCode(uccMdmMaterialSyncBo.getCatalogCode());
                addPoList.add(uccEMdmMaterialPO2);
            }
            if (!CollectionUtils.isEmpty(addPoList)) {
                this.uccEMdmMaterialMapper.batchInsert(addPoList);
            }
            if (!CollectionUtils.isEmpty(updatePoList)) {
                updatePoList.forEach(uccEMdmMaterialPO -> this.uccEMdmMaterialMapper.updateByPrimaryKeySelective(uccEMdmMaterialPO));
            }
        }
        return rspBo;
    }
}

