/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.busi.api.UccDefaultAddCoefficientEditBusiService;
import com.tydic.commodity.common.busi.bo.UccDefaultAddCoefficientEditBusiServiceReqBO;
import com.tydic.commodity.common.busi.bo.UccDefaultAddCoefficientEditBusiServiceRspBO;
import com.tydic.commodity.dao.UccDefaultAddCoefficientLogMapper;
import com.tydic.commodity.dao.UccParamsConfigDetailMapper;
import com.tydic.commodity.dao.UccParamsConfigMapper;
import com.tydic.commodity.po.UccDefaultAddCoefficientLogPO;
import com.tydic.commodity.po.UccParamsConfigDetailPO;
import com.tydic.commodity.po.UccParamsConfigPO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccDefaultAddCoefficientEditBusiServiceImpl
implements UccDefaultAddCoefficientEditBusiService {
    @Autowired
    private UccDefaultAddCoefficientLogMapper uccDefaultAddCoefficientLogMapper;
    @Autowired
    private UccParamsConfigDetailMapper uccParamsConfigDetailMapper;
    @Autowired
    private UccParamsConfigMapper uccParamsConfigMapper;

    @Override
    public UccDefaultAddCoefficientEditBusiServiceRspBO editDefaultCoefficient(UccDefaultAddCoefficientEditBusiServiceReqBO reqBo) {
        this.var(reqBo);
        Date now = new Date();
        UccParamsConfigPO uccParamsConfigPO = new UccParamsConfigPO();
        uccParamsConfigPO.setParamsCode("ESTORE_DEFAULT_COEFFICIENT");
        uccParamsConfigPO = this.uccParamsConfigMapper.getModelBy(uccParamsConfigPO);
        if (uccParamsConfigPO != null) {
            this.updateCoefficient(reqBo, now, uccParamsConfigPO);
            this.createChanegeLog(reqBo, now);
        }
        UccDefaultAddCoefficientEditBusiServiceRspBO rspBO = new UccDefaultAddCoefficientEditBusiServiceRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void createChanegeLog(UccDefaultAddCoefficientEditBusiServiceReqBO reqBo, Date now) {
        UccDefaultAddCoefficientLogPO uccDefaultAddCoefficientLogPO = new UccDefaultAddCoefficientLogPO();
        uccDefaultAddCoefficientLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        uccDefaultAddCoefficientLogPO.setAddCoefficient(reqBo.getAddCoefficient());
        uccDefaultAddCoefficientLogPO.setAllowMarketPrice(reqBo.getAllowMarketPrice());
        uccDefaultAddCoefficientLogPO.setEffTime(now);
        uccDefaultAddCoefficientLogPO.setUpdateTime(now);
        uccDefaultAddCoefficientLogPO.setCreateTime(now);
        uccDefaultAddCoefficientLogPO.setUpdateOperId(Convert.toStr((Object)reqBo.getUserId()));
        uccDefaultAddCoefficientLogPO.setUpdateOperName(reqBo.getUsername());
        uccDefaultAddCoefficientLogPO.setAccountNumber(reqBo.getName());
        this.uccDefaultAddCoefficientLogMapper.insert(uccDefaultAddCoefficientLogPO);
    }

    private void updateCoefficient(UccDefaultAddCoefficientEditBusiServiceReqBO reqBo, Date now, UccParamsConfigPO uccParamsConfigPO) {
        UccParamsConfigDetailPO uccParamsConfigDetailPO = new UccParamsConfigDetailPO();
        uccParamsConfigDetailPO.setParamsId(uccParamsConfigPO.getParamsId());
        List configDetailMapperList = this.uccParamsConfigDetailMapper.getList(uccParamsConfigDetailPO);
        for (UccParamsConfigDetailPO paramsConfigDetailPO : configDetailMapperList) {
            if ("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT_STATE".equals(paramsConfigDetailPO.getCode())) {
                if (UccConstants.UccAddCoefficientDealState.DEALING.equals(Convert.toInt((Object)paramsConfigDetailPO.getRule()))) {
                    throw new BusinessException("8888", "\u7535\u5546\u5546\u54c1\u9ed8\u8ba4\u52a0\u4ef7\u7cfb\u6570\u8fd8\u672a\u4fee\u6539\u5b8c\u6210\uff0c\u4e0d\u80fd\u91cd\u590d\u4fee\u6539\u3002");
                }
                UccParamsConfigDetailPO updateState = new UccParamsConfigDetailPO();
                updateState.setId(paramsConfigDetailPO.getId());
                updateState.setRule(Convert.toStr((Object)UccConstants.UccAddCoefficientDealState.DEALING));
                this.uccParamsConfigDetailMapper.updateById(updateState);
            }
            if ("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT".equals(paramsConfigDetailPO.getCode())) {
                UccParamsConfigDetailPO updateCoefficient = new UccParamsConfigDetailPO();
                updateCoefficient.setId(paramsConfigDetailPO.getId());
                updateCoefficient.setRule(Convert.toStr((Object)reqBo.getAddCoefficient()));
                this.uccParamsConfigDetailMapper.updateById(updateCoefficient);
            }
            if ("ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT_ALLOW_MARKET".equals(paramsConfigDetailPO.getCode())) {
                UccParamsConfigDetailPO updateAllowMarket = new UccParamsConfigDetailPO();
                updateAllowMarket.setId(paramsConfigDetailPO.getId());
                updateAllowMarket.setRule(Convert.toStr((Object)reqBo.getAllowMarketPrice()));
                this.uccParamsConfigDetailMapper.updateById(updateAllowMarket);
            }
            if (!"ESTORE_DEFAULT_COEFFICIENT_COEFFICIENT_DATE".equals(paramsConfigDetailPO.getCode())) continue;
            UccParamsConfigDetailPO updateDate = new UccParamsConfigDetailPO();
            updateDate.setId(paramsConfigDetailPO.getId());
            updateDate.setRule(DateUtil.formatDateTime((Date)now));
            this.uccParamsConfigDetailMapper.updateById(updateDate);
        }
    }

    private void var(UccDefaultAddCoefficientEditBusiServiceReqBO reqBo) {
        if (null == reqBo.getAddCoefficient() || BigDecimal.ZERO.compareTo(reqBo.getAddCoefficient()) > 0) {
            throw new BusinessException("8888", "\u52a0\u4ef7\u7cfb\u6570\u4e3a\u7a7a\u6216\u6709\u8bef");
        }
        if (reqBo.getAddCoefficient().scale() > 4) {
            throw new BusinessException("8888", "\u52a0\u4ef7\u7cfb\u6570\u6700\u591a\u652f\u63014\u4f4d\u5c0f\u6570");
        }
        if (null == reqBo.getAllowMarketPrice()) {
            throw new BusinessException("8888", "\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u5e02\u573a\u4ef7\u4e3a\u7a7a");
        }
    }
}

