/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.extension.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.extension.ability.bo.BkUccEMdmCatalogBo;
import com.tydic.commodity.common.extension.busi.api.BkUccEMdmCatalogSyncBusiService;
import com.tydic.commodity.common.extension.busi.bo.BkUccEMdmCatalogSyncBusiReqBO;
import com.tydic.commodity.common.extension.busi.bo.BkUccEMdmCatalogSyncBusiRspBO;
import com.tydic.commodity.extension.dao.BkUccEMdmCatalogExtMapper;
import com.tydic.commodity.extension.dao.BkUccEMdmCatalogMapper;
import com.tydic.commodity.extension.po.BkUccEMdmCatalogExtPO;
import com.tydic.commodity.extension.po.BkUccEMdmCatalogPO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BkUccEMdmCatalogSyncBusiServiceImpl
implements BkUccEMdmCatalogSyncBusiService {
    @Autowired
    private BkUccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private BkUccEMdmCatalogExtMapper bkUccEMdmCatalogExtMapper;

    @Override
    public BkUccEMdmCatalogSyncBusiRspBO syncEMdmCatalog(BkUccEMdmCatalogSyncBusiReqBO reqBO) {
        List uccEMdmCatalogMapperListByCodes = this.uccEMdmCatalogMapper.getListByCodes(reqBO.getCatalogs().stream().map(BkUccEMdmCatalogBo::getCatalogCode).collect(Collectors.toList()));
        Map<String, BkUccEMdmCatalogPO> uccEMdmCatalogPOMap = uccEMdmCatalogMapperListByCodes.stream().collect(Collectors.toMap(BkUccEMdmCatalogPO::getCatalogCode, o -> o, (old, cur) -> old));
        for (BkUccEMdmCatalogBo uccEMdmCatalogBo : reqBO.getCatalogs()) {
            this.valCatalog(uccEMdmCatalogBo);
            if (!uccEMdmCatalogPOMap.containsKey(uccEMdmCatalogBo.getCatalogCode())) {
                this.add(uccEMdmCatalogBo);
                continue;
            }
            this.update(uccEMdmCatalogBo, uccEMdmCatalogPOMap.get(uccEMdmCatalogBo.getCatalogCode()));
        }
        BkUccEMdmCatalogSyncBusiRspBO rspBO = new BkUccEMdmCatalogSyncBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void update(BkUccEMdmCatalogBo uccEMdmCatalogBo, BkUccEMdmCatalogPO existCatalogPo) {
        BkUccEMdmCatalogPO uccEMdmCatalogPO = new BkUccEMdmCatalogPO();
        uccEMdmCatalogPO.setSysId(uccEMdmCatalogBo.getSysId());
        uccEMdmCatalogPO.setCatalogId(existCatalogPo.getCatalogId());
        uccEMdmCatalogPO.setCatalogName(uccEMdmCatalogBo.getCatalogName());
        uccEMdmCatalogPO.setCatalogCode(uccEMdmCatalogBo.getCatalogCode());
        uccEMdmCatalogPO.setCatalogVer(uccEMdmCatalogBo.getCatalogVer());
        uccEMdmCatalogPO.setCatalogDesc(uccEMdmCatalogBo.getCatalogDesc());
        uccEMdmCatalogPO.setParentCatalogCode(uccEMdmCatalogBo.getParentCatalogCode());
        uccEMdmCatalogPO.setUuid(uccEMdmCatalogBo.getCatalogCode());
        uccEMdmCatalogPO.setFreezeFlag(uccEMdmCatalogBo.getFreezeFlag());
        uccEMdmCatalogPO.setUpdateLoginId(Long.valueOf(1L));
        uccEMdmCatalogPO.setUpdateTime(new Date());
        uccEMdmCatalogPO.setRemark(uccEMdmCatalogBo.getRemark());
        this.uccEMdmCatalogMapper.updateById(uccEMdmCatalogPO);
        BkUccEMdmCatalogExtPO bkUccEMdmCatalogExtPO = new BkUccEMdmCatalogExtPO();
        bkUccEMdmCatalogExtPO.setCatalogCode(uccEMdmCatalogBo.getCatalogCode());
        bkUccEMdmCatalogExtPO.setDesc1(uccEMdmCatalogBo.getMeasureCode());
        this.bkUccEMdmCatalogExtMapper.updateById(bkUccEMdmCatalogExtPO);
        if (!StringUtils.isBlank((CharSequence)uccEMdmCatalogBo.getParentCatalogCode()) && !uccEMdmCatalogBo.getParentCatalogCode().equals(existCatalogPo.getParentCatalogCode())) {
            BkUccEMdmCatalogPO uccEMdmCatalog = new BkUccEMdmCatalogPO();
            uccEMdmCatalog.setCatalogCode(uccEMdmCatalogBo.getParentCatalogCode());
            BkUccEMdmCatalogPO edmCatalog = this.uccEMdmCatalogMapper.getModelBy(uccEMdmCatalog);
            if (null != edmCatalog) {
                BkUccEMdmCatalogPO updateCurrent = new BkUccEMdmCatalogPO();
                updateCurrent.setCatalogId(uccEMdmCatalogPO.getCatalogId());
                updateCurrent.setParentCatalogId(edmCatalog.getCatalogId());
                updateCurrent.setCatalogLevel(Integer.valueOf(edmCatalog.getCatalogLevel() + 1));
                updateCurrent.setLastLevel(Integer.valueOf(0));
                this.uccEMdmCatalogMapper.updateById(updateCurrent);
                this.updateNotLast(edmCatalog.getCatalogId());
                BkUccEMdmCatalogPO eMdmCatalog = new BkUccEMdmCatalogPO();
                eMdmCatalog.setParentCatalogCode(uccEMdmCatalogBo.getCatalogCode());
                List eMdmCatalogMapperList = this.uccEMdmCatalogMapper.getList(eMdmCatalog);
                if (CollectionUtils.isNotEmpty((Collection)eMdmCatalogMapperList)) {
                    this.updateChildLevel(eMdmCatalogMapperList, edmCatalog.getCatalogLevel() + 1, uccEMdmCatalogPO.getCatalogId());
                }
            }
        }
    }

    private void add(BkUccEMdmCatalogBo uccEMdmCatalogBo) {
        BkUccEMdmCatalogPO uccEMdmCatalogPO = new BkUccEMdmCatalogPO();
        uccEMdmCatalogPO.setSysId(uccEMdmCatalogBo.getSysId());
        long catalogId = Sequence.getInstance().nextId();
        uccEMdmCatalogPO.setCatalogId(Long.valueOf(catalogId));
        uccEMdmCatalogPO.setCatalogName(uccEMdmCatalogBo.getCatalogName());
        uccEMdmCatalogPO.setCatalogCode(uccEMdmCatalogBo.getCatalogCode());
        uccEMdmCatalogPO.setCatalogVer(uccEMdmCatalogBo.getCatalogVer());
        uccEMdmCatalogPO.setCatalogDesc(uccEMdmCatalogBo.getCatalogDesc());
        uccEMdmCatalogPO.setParentCatalogCode(uccEMdmCatalogBo.getParentCatalogCode());
        uccEMdmCatalogPO.setParentCatalogId(Long.valueOf(0L));
        uccEMdmCatalogPO.setUuid(uccEMdmCatalogBo.getCatalogCode());
        uccEMdmCatalogPO.setFreezeFlag(uccEMdmCatalogBo.getFreezeFlag());
        uccEMdmCatalogPO.setCreateLoginId(Long.valueOf(1L));
        uccEMdmCatalogPO.setCreateTime(new Date());
        uccEMdmCatalogPO.setRemark(uccEMdmCatalogBo.getRemark());
        uccEMdmCatalogPO.setLastLevel(Integer.valueOf(2));
        uccEMdmCatalogPO.setCatalogLevel(Integer.valueOf(1));
        int currentLevel = uccEMdmCatalogPO.getCatalogLevel();
        if (!StringUtils.isBlank((CharSequence)uccEMdmCatalogBo.getParentCatalogCode())) {
            BkUccEMdmCatalogPO uccEMdmCatalog = new BkUccEMdmCatalogPO();
            uccEMdmCatalog.setCatalogCode(uccEMdmCatalogBo.getParentCatalogCode());
            BkUccEMdmCatalogPO edmCatalog = this.uccEMdmCatalogMapper.getModelBy(uccEMdmCatalog);
            if (null != edmCatalog) {
                uccEMdmCatalogPO.setParentCatalogId(edmCatalog.getCatalogId());
                uccEMdmCatalogPO.setCatalogLevel(Integer.valueOf(edmCatalog.getCatalogLevel() + 1));
                currentLevel = edmCatalog.getCatalogLevel() + 1;
                this.updateNotLast(edmCatalog.getCatalogId());
            }
        }
        this.uccEMdmCatalogMapper.insert(uccEMdmCatalogPO);
        BkUccEMdmCatalogExtPO bkUccEMdmCatalogExtPO = new BkUccEMdmCatalogExtPO();
        bkUccEMdmCatalogExtPO.setSysId(uccEMdmCatalogBo.getSysId());
        bkUccEMdmCatalogExtPO.setCatalogId(Long.valueOf(catalogId));
        bkUccEMdmCatalogExtPO.setCatalogCode(uccEMdmCatalogBo.getCatalogCode());
        bkUccEMdmCatalogExtPO.setDesc1(uccEMdmCatalogBo.getMeasureCode());
        this.bkUccEMdmCatalogExtMapper.insert(bkUccEMdmCatalogExtPO);
        BkUccEMdmCatalogPO uccEMdmCatalog = new BkUccEMdmCatalogPO();
        uccEMdmCatalog.setParentCatalogCode(uccEMdmCatalogBo.getCatalogCode());
        List eMdmCatalogPOS = this.uccEMdmCatalogMapper.getList(uccEMdmCatalog);
        if (CollectionUtils.isNotEmpty((Collection)eMdmCatalogPOS)) {
            this.updateNotLast(uccEMdmCatalogPO.getCatalogId());
            this.updateChildLevel(eMdmCatalogPOS, currentLevel, uccEMdmCatalogPO.getCatalogId());
        }
    }

    private void updateNotLast(Long catalogId) {
        BkUccEMdmCatalogPO update = new BkUccEMdmCatalogPO();
        update.setCatalogId(catalogId);
        update.setLastLevel(Integer.valueOf(0));
        this.uccEMdmCatalogMapper.updateById(update);
    }

    private void updateChildLevel(List<BkUccEMdmCatalogPO> edmCatalogs, int currentLevel, Long parentId) {
        for (BkUccEMdmCatalogPO edmCatalog : edmCatalogs) {
            BkUccEMdmCatalogPO updateChild = new BkUccEMdmCatalogPO();
            updateChild.setCatalogId(edmCatalog.getCatalogId());
            updateChild.setCatalogLevel(Integer.valueOf(currentLevel + 1));
            updateChild.setParentCatalogId(parentId);
            this.uccEMdmCatalogMapper.updateById(updateChild);
            BkUccEMdmCatalogPO uccEMdmCatalogPO = new BkUccEMdmCatalogPO();
            uccEMdmCatalogPO.setParentCatalogId(edmCatalog.getCatalogId());
            List uccEMdmCatalogMapperList = this.uccEMdmCatalogMapper.getList(uccEMdmCatalogPO);
            if (!CollectionUtils.isNotEmpty((Collection)uccEMdmCatalogMapperList)) continue;
            this.updateChildLevel(uccEMdmCatalogMapperList, currentLevel + 1, edmCatalog.getCatalogId());
        }
    }

    private void valCatalog(BkUccEMdmCatalogBo uccEMdmCatalogBo) {
        if (null == uccEMdmCatalogBo.getParentCatalogCode()) {
            throw new BusinessException("0001", "\u7236\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)uccEMdmCatalogBo.getCatalogName())) {
            throw new BusinessException("0001", "\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)uccEMdmCatalogBo.getCatalogCode())) {
            throw new BusinessException("0001", "\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == uccEMdmCatalogBo.getFreezeFlag()) {
            throw new BusinessException("0001", "\u505c\u7528\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

