/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.extension.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.enumType.SkuEnum;
import com.tydic.commodity.base.extension.constant.BkMoneyUtils;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.common.extension.ability.bo.BkUccQeySkuBySpecForOrderInfoBO;
import com.tydic.commodity.common.extension.ability.bo.BkUccQrySkuBySpecAbilityReqBO;
import com.tydic.commodity.common.extension.ability.bo.BkUccQrySkuBySpecAbilityRspBO;
import com.tydic.commodity.common.extension.ability.bo.BkUccQrySkuBySpecPriceBO;
import com.tydic.commodity.common.extension.ability.bo.BkUccReplacePriceSkuBO;
import com.tydic.commodity.common.extension.busi.api.BkUccQrySkuBySpecBusiService;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSmcsdkSkuStockInfoMapper;
import com.tydic.commodity.extension.busibase.busi.api.BkUccReplacePriceQryBusiService;
import com.tydic.commodity.extension.busibase.busi.bo.BkUccReplacePriceQryBusiBO;
import com.tydic.commodity.extension.busibase.busi.bo.BkUccReplacePriceQryBusiReqBO;
import com.tydic.commodity.extension.busibase.busi.bo.BkUccReplacePriceQryBusiRspBO;
import com.tydic.commodity.extension.dao.BkUccMallVendorMapper;
import com.tydic.commodity.extension.dao.BkUccPriceVersionInfoMapper;
import com.tydic.commodity.extension.dao.BkUccSkuMapper;
import com.tydic.commodity.extension.po.BkUccPriceVersionInfoAndLibraryPO;
import com.tydic.commodity.extension.po.BkUccQrySkuSpecPO;
import com.tydic.commodity.extension.po.BkUccSkuAndMaterialPo;
import com.tydic.commodity.extension.po.BkUccVendorPo;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.UccSkuPicPo;
import com.tydic.commodity.po.UccSmcsdkSkuStockInfoPO;
import com.tydic.commodity.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BkUccQrySkuBySpecBusiServiceImpl
implements BkUccQrySkuBySpecBusiService {
    private static final Logger log = LoggerFactory.getLogger(BkUccQrySkuBySpecBusiServiceImpl.class);
    @Autowired
    private BkUccSkuMapper uccSkuMapper;
    @Autowired
    private UccBaseDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccSmcsdkSkuStockInfoMapper uccSmcsdkSkuStockInfoMapper;
    @Autowired
    private BkUccMallVendorMapper uccMallVendorMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private BkUccReplacePriceQryBusiService bkUccReplacePriceQryBusiService;
    @Autowired
    private BkUccSkuMapper bkUccSkuMapper;
    @Autowired
    private BkUccPriceVersionInfoMapper bkUccPriceVersionInfoMapper;

    @Override
    public BkUccQrySkuBySpecAbilityRspBO qrySkuSpec(BkUccQrySkuBySpecAbilityReqBO reqBO) {
        Long skuId;
        BkUccQrySkuBySpecAbilityRspBO rspBO = this.checkReqBo(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        Long commodityId = reqBO.getCommodityId();
        List uccQrySkuSpecPOList = this.uccSkuMapper.qrySkuInfoByCommodityIdAndSkuId(commodityId, skuId = reqBO.getSkuId());
        if (!CollectionUtils.isEmpty((Collection)uccQrySkuSpecPOList)) {
            BkUccQrySkuSpecPO uccQrySkuSpecPO = (BkUccQrySkuSpecPO)uccQrySkuSpecPOList.get(0);
            BeanUtils.copyProperties((Object)uccQrySkuSpecPO, (Object)rspBO);
            DicDictionaryPo dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(uccQrySkuSpecPO.getSkuStatus()), SkuEnum.SKU_STATUS.toString());
            if (null != dicDictionaryPo) {
                rspBO.setSkuStatusDesc(dicDictionaryPo.getTitle());
            }
            if (reqBO.getIsMall() == null || reqBO.getIsMall() != 1) {
                List<BkUccReplacePriceQryBusiBO> unifyPriceList = this.getUnifyPrice(reqBO);
                if (!CollectionUtils.isEmpty(unifyPriceList)) {
                    BkUccReplacePriceQryBusiBO bkUccReplacePriceQryBusiBO = unifyPriceList.get(0);
                    BkUccQrySkuBySpecPriceBO bkUccQrySkuBySpecPriceBO = (BkUccQrySkuBySpecPriceBO)JSON.parseObject((String)JSON.toJSONString((Object)bkUccReplacePriceQryBusiBO), BkUccQrySkuBySpecPriceBO.class);
                    rspBO.setBkUccQrySkuBySpecPriceBO(bkUccQrySkuBySpecPriceBO);
                    rspBO.setIsShowPrice(Integer.valueOf(bkUccReplacePriceQryBusiBO.getIsAvailable().equals(1) ? 1 : 0));
                } else {
                    rspBO.setIsShowPrice(Integer.valueOf(0));
                }
            } else {
                BkUccReplacePriceQryBusiReqBO bkUccReplacePriceQryBusiReqBO = (BkUccReplacePriceQryBusiReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), BkUccReplacePriceQryBusiReqBO.class);
                BkUccReplacePriceQryBusiRspBO bkUccReplacePriceQryBusiRspBO = this.bkUccReplacePriceQryBusiService.replacePrice(bkUccReplacePriceQryBusiReqBO);
                if (!"0000".equals(bkUccReplacePriceQryBusiRspBO.getRespCode())) {
                    throw new ZTBusinessException("\u67e5\u8be2\u4ef7\u683c\u5f02\u5e38");
                }
                if (!CollectionUtils.isEmpty((Collection)bkUccReplacePriceQryBusiRspBO.getPriceList())) {
                    BkUccReplacePriceQryBusiBO bkUccReplacePriceQryBusiBO = (BkUccReplacePriceQryBusiBO)bkUccReplacePriceQryBusiRspBO.getPriceList().get(0);
                    BkUccQrySkuBySpecPriceBO bkUccQrySkuBySpecPriceBO = (BkUccQrySkuBySpecPriceBO)JSON.parseObject((String)JSON.toJSONString((Object)bkUccReplacePriceQryBusiBO), BkUccQrySkuBySpecPriceBO.class);
                    rspBO.setBkUccQrySkuBySpecPriceBO(bkUccQrySkuBySpecPriceBO);
                    rspBO.setIsShowPrice(Integer.valueOf(bkUccReplacePriceQryBusiBO.getIsAvailable().equals(1) ? 1 : 0));
                } else {
                    rspBO.setIsShowPrice(Integer.valueOf(0));
                }
            }
            List stockInfoPOList = this.uccSmcsdkSkuStockInfoMapper.getListBySku(Arrays.asList(uccQrySkuSpecPO.getSkuId()));
            if (CollectionUtils.isEmpty((Collection)stockInfoPOList)) {
                rspBO.setUnSaleNum(BigDecimal.ZERO);
            } else {
                rspBO.setUnSaleNum(MoneyUtils.haoToYuan((Long)((UccSmcsdkSkuStockInfoPO)stockInfoPOList.get(0)).getUnsaleNum()));
            }
            BkUccQeySkuBySpecForOrderInfoBO orderInfoBO = this.doGetForOrderInfo(uccQrySkuSpecPO.getSkuId(), commodityId, uccQrySkuSpecPO.getSupplierShopId());
            orderInfoBO.setAgrId(uccQrySkuSpecPO.getAgreementId());
            orderInfoBO.setOrderSource(String.valueOf(this.transferOrderSource(uccQrySkuSpecPO.getSkuSource())));
            orderInfoBO.setSkuName(uccQrySkuSpecPO.getSkuName());
            rspBO.setOrderInfoBO(orderInfoBO);
        }
        return rspBO;
    }

    private List<BkUccReplacePriceQryBusiBO> getUnifyPrice(BkUccQrySkuBySpecAbilityReqBO reqBO) {
        List skuIdList = reqBO.getSkuList().stream().map(BkUccReplacePriceSkuBO::getSkuId).distinct().collect(Collectors.toList());
        ArrayList<BkUccReplacePriceQryBusiBO> priceList = new ArrayList<BkUccReplacePriceQryBusiBO>();
        List bkUccSkuAndMaterialPos = this.bkUccSkuMapper.qrySkuAndMaterialList(skuIdList);
        if (CollectionUtils.isEmpty((Collection)bkUccSkuAndMaterialPos)) {
            return priceList;
        }
        Map<Long, List<BkUccSkuAndMaterialPo>> skuIdMap = bkUccSkuAndMaterialPos.stream().collect(Collectors.groupingBy(BkUccSkuAndMaterialPo::getSkuId));
        for (BkUccReplacePriceSkuBO skuBO : reqBO.getSkuList()) {
            BkUccReplacePriceQryBusiBO bkUccReplacePriceQryBusiBO = new BkUccReplacePriceQryBusiBO();
            bkUccReplacePriceQryBusiBO.setSkuId(skuBO.getSkuId());
            bkUccReplacePriceQryBusiBO.setIsAvailable(Integer.valueOf(1));
            BkUccSkuAndMaterialPo bkUccSkuAndMaterialPo = skuIdMap.get(skuBO.getSkuId()).get(0);
            Integer agrType = bkUccSkuAndMaterialPo.getAgrType();
            bkUccReplacePriceQryBusiBO.setAgrType(agrType);
            String materialCode = bkUccSkuAndMaterialPo.getMaterialCode();
            List bkUccPriceVersionInfoAndLibraryPOS = this.bkUccPriceVersionInfoMapper.qryPriceVersionInfoAndLibrary(skuBO.getAgrCode(), materialCode);
            if (CollectionUtils.isEmpty((Collection)bkUccPriceVersionInfoAndLibraryPOS)) {
                bkUccReplacePriceQryBusiBO.setIsAvailable(Integer.valueOf(0));
                priceList.add(bkUccReplacePriceQryBusiBO);
                continue;
            }
            Map<Integer, List<BkUccPriceVersionInfoAndLibraryPO>> priceLibraryMap = bkUccPriceVersionInfoAndLibraryPOS.stream().collect(Collectors.groupingBy(BkUccPriceVersionInfoAndLibraryPO::getPriceMod));
            List<BkUccPriceVersionInfoAndLibraryPO> unifyAgrPriceList = priceLibraryMap.get(1);
            String agrPriceVersionCode = ((BkUccPriceVersionInfoAndLibraryPO)bkUccPriceVersionInfoAndLibraryPOS.get(0)).getPriceVersionCode();
            List bkUccSalePriceVersionInfoAndLibraryList = this.bkUccPriceVersionInfoMapper.qrySalePriceVersionInfoAndLibrary(agrPriceVersionCode, materialCode);
            if (CollectionUtils.isEmpty((Collection)bkUccSalePriceVersionInfoAndLibraryList)) {
                bkUccReplacePriceQryBusiBO.setIsAvailable(Integer.valueOf(0));
                priceList.add(bkUccReplacePriceQryBusiBO);
                continue;
            }
            Map<Integer, List<BkUccPriceVersionInfoAndLibraryPO>> salePriceLibraryMap = bkUccSalePriceVersionInfoAndLibraryList.stream().collect(Collectors.groupingBy(BkUccPriceVersionInfoAndLibraryPO::getPriceMod));
            List<BkUccPriceVersionInfoAndLibraryPO> unifySalePriceList = salePriceLibraryMap.get(1);
            if (agrType == 1) {
                if (CollectionUtils.isEmpty(unifySalePriceList)) {
                    bkUccReplacePriceQryBusiBO.setIsAvailable(Integer.valueOf(0));
                } else {
                    bkUccReplacePriceQryBusiBO.setSalePrice(unifySalePriceList.get(0).getPrice());
                }
            } else if (CollectionUtils.isEmpty(unifyAgrPriceList)) {
                bkUccReplacePriceQryBusiBO.setIsAvailable(Integer.valueOf(0));
            } else {
                bkUccReplacePriceQryBusiBO.setAgrPrice(unifyAgrPriceList.get(0).getPrice());
            }
            this.unitConvertPrice(bkUccReplacePriceQryBusiBO);
            priceList.add(bkUccReplacePriceQryBusiBO);
        }
        return priceList;
    }

    private void unitConvertPrice(BkUccReplacePriceQryBusiBO priceBo) {
        if (!Objects.isNull(priceBo.getAgrPrice())) {
            BigDecimal agrPrice = BkMoneyUtils.unitConvertPrice((BigDecimal)priceBo.getAgrPrice());
            priceBo.setAgrPrice(agrPrice);
        }
        if (!Objects.isNull(priceBo.getSalePrice())) {
            BigDecimal salePrice = BkMoneyUtils.unitConvertPrice((BigDecimal)priceBo.getSalePrice());
            priceBo.setSalePrice(salePrice);
        }
    }

    private Integer transferOrderSource(Integer skuSource) {
        if (null == skuSource) {
            return 3;
        }
        switch (skuSource) {
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
        }
        return 3;
    }

    private BkUccQeySkuBySpecForOrderInfoBO doGetForOrderInfo(Long skuId, Long commodityId, Long supplierShopId) {
        BkUccVendorPo uccVendorPo;
        BkUccQeySkuBySpecForOrderInfoBO orderInfoBO = new BkUccQeySkuBySpecForOrderInfoBO();
        UccSkuPicPo queryPo = new UccSkuPicPo();
        queryPo.setSupplierShopId(supplierShopId);
        queryPo.setSkuId(skuId);
        queryPo.setCommodityPicType(Integer.valueOf(1));
        List uccSkuPicPos = this.uccSkuPicMapper.qeurySkuPic(queryPo);
        if (!CollectionUtils.isEmpty((Collection)uccSkuPicPos)) {
            orderInfoBO.setSkuMainPicUrl(((UccSkuPicPo)uccSkuPicPos.get(0)).getSkuPicUrl());
        }
        if (null != (uccVendorPo = this.uccMallVendorMapper.selectVendorByCommodityIdAndsupplierShopId(commodityId, supplierShopId))) {
            orderInfoBO.setGoodsSupplierId(String.valueOf(uccVendorPo.getVendorId()));
            orderInfoBO.setSkuSupplierName(uccVendorPo.getVendorName());
        }
        orderInfoBO.setPurchType(Integer.valueOf(1));
        return orderInfoBO;
    }

    private BkUccQrySkuBySpecAbilityRspBO checkReqBo(BkUccQrySkuBySpecAbilityReqBO reqBO) {
        BkUccQrySkuBySpecAbilityRspBO rspBO = new BkUccQrySkuBySpecAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (null == reqBO) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (null == reqBO.getCommodityId()) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        return rspBO;
    }
}

