/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.extension.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccBatchSaveGoodImagesBO;
import com.tydic.commodity.common.ability.bo.UccBatchSaveGoodImagesFailReason;
import com.tydic.commodity.common.ability.bo.UccBatchSaveGoodImagesReqBO;
import com.tydic.commodity.common.ability.bo.UccBatchSaveGoodImagesRspBO;
import com.tydic.commodity.common.extension.ability.api.BkUccBatchSaveGoodImagesAbilityService;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuPicPo;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.extension.ability.api.BkUccBatchSaveGoodImagesAbilityService"})
public class BkUccBatchSaveGoodImagesAbilityServiceImpl
implements BkUccBatchSaveGoodImagesAbilityService {
    private static final Logger log = LoggerFactory.getLogger(BkUccBatchSaveGoodImagesAbilityServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Resource(name="lmBkSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmBkSyncCommodityMqServiceProvider;
    @Value(value="${LM_UCC_SYNC_TOPIC_BK}")
    private String lmUccSyncTopic;
    @Value(value="${LM_UCC_SYNC_TAG}")
    private String lmUccSyncTag;
    private static final String IMAGE_NAME_REGEX = "^[\\d]*_[12345]{1}.((jpg)|(png))$";

    @PostMapping(value={"dealBatchSaveGoodImages"})
    public UccBatchSaveGoodImagesRspBO dealBatchSaveGoodImages(@RequestBody UccBatchSaveGoodImagesReqBO reqBO) {
        this.validate(reqBO);
        UccBatchSaveGoodImagesRspBO rspBO = new UccBatchSaveGoodImagesRspBO();
        ArrayList<UccBatchSaveGoodImagesFailReason> failReasonList = new ArrayList<UccBatchSaveGoodImagesFailReason>();
        UccBatchSaveGoodImagesFailReason failReason = new UccBatchSaveGoodImagesFailReason();
        AtomicBoolean flag = new AtomicBoolean(false);
        HashMap<Long, Map> skuImagesMap = new HashMap<Long, Map>();
        HashMap skuCommodityPicTypeMap = new HashMap();
        HashMap<String, Map<Integer, String>> skuImageAddressMap = new HashMap<String, Map<Integer, String>>();
        List<UccBatchSaveGoodImagesBO> collect = reqBO.getSkuImagesList().stream().sorted(Comparator.comparing(UccBatchSaveGoodImagesBO::getSkuImageName)).collect(Collectors.toList());
        this.valSkuImagesInfo(collect, flag, failReason, failReasonList, skuImageAddressMap);
        if (flag.get()) {
            rspBO.setFailReasonList(failReasonList.stream().distinct().collect(Collectors.toList()));
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        List skuCodeList = reqBO.getSkuImagesList().stream().map(e -> {
            String skuImageName = e.getSkuImageName();
            return skuImageName.substring(0, skuImageName.indexOf("_"));
        }).distinct().collect(Collectors.toList());
        Map<Long, String> skuIdCodeMap = this.uccSkuMapper.querySkuIdByCode(skuCodeList).stream().collect(Collectors.toMap(UccSkuPo::getSkuId, UccSkuPo::getSkuCode, (k1, k2) -> k2));
        List<Object> skuIdList = new ArrayList();
        List uccSkuPos = this.uccSkuMapper.querySkuByCode(skuCodeList);
        skuIdList = uccSkuPos.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
        List uccSkuPicPoList = this.uccSkuPicMapper.qeurySkuPicBySkuIdList(skuIdList);
        Map<Long, List<UccSkuPicPo>> uccSkuPicListPoMap = uccSkuPicPoList.stream().collect(Collectors.groupingBy(UccSkuPicPo::getSkuId));
        List uccSkuPoList = this.uccSkuMapper.batchQrySku(skuIdList, null);
        Map<Long, Long> skuIdVsCommodityIdMap = uccSkuPoList.stream().collect(Collectors.toMap(UccSkuPo::getSkuId, UccSkuPo::getCommodityId, (k1, k2) -> k2));
        List commodityIds = uccSkuPoList.stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList());
        List uccCommodityPoList = this.uccCommodityMapper.qeryBatchCommdity(commodityIds);
        Map<Long, Integer> commodityIdVsApprovalStatusMap = uccCommodityPoList.stream().filter(o -> null != o.getApprovalStatus()).collect(Collectors.toMap(UccCommodityPo::getCommodityId, UccCommodityPo::getApprovalStatus, (k1, k2) -> k2));
        uccSkuPicListPoMap.forEach((skuId, uccSkuPicPos) -> {
            for (int i = 0; i < uccSkuPicPos.size(); ++i) {
                UccSkuPicPo picPo = (UccSkuPicPo)uccSkuPicPos.get(i);
                String skuCode = (String)skuIdCodeMap.get(picPo.getSkuId());
                Integer imageNameSuffix = i + 1;
                Map stringMap = (Map)skuImageAddressMap.get(skuCode);
                if (!ObjectUtil.isNotEmpty((Object)stringMap) || !stringMap.containsKey(imageNameSuffix)) continue;
                String skuImageAddress = (String)stringMap.get(imageNameSuffix);
                if (!skuCommodityPicTypeMap.containsKey(skuId)) {
                    HashMap<Integer, ArrayList> map = new HashMap<Integer, ArrayList>();
                    map.put(imageNameSuffix, Lists.newArrayList((Object[])new String[]{skuImageAddress}));
                    skuCommodityPicTypeMap.put(skuId, map);
                } else {
                    Map commodityPicTypeMap = (Map)skuCommodityPicTypeMap.get(skuId);
                    if (commodityPicTypeMap.containsKey(imageNameSuffix)) {
                        ((List)commodityPicTypeMap.get(imageNameSuffix)).add(skuImageAddress);
                    } else {
                        commodityPicTypeMap.put(imageNameSuffix, Lists.newArrayList((Object[])new String[]{skuImageAddress}));
                    }
                }
                List skuPicPos = null;
                if (ObjectUtil.isNotEmpty((Object)skuIdVsCommodityIdMap) && ObjectUtil.isNotEmpty((Object)commodityIdVsApprovalStatusMap) && (Integer)commodityIdVsApprovalStatusMap.get(skuIdVsCommodityIdMap.get(skuId)) == 31) {
                    flag.set(true);
                    failReason.setFailReason("\u5355\u54c1\u7f16\u7801\uff1a" + skuCode + "\u5546\u54c1\u6b63\u5728\u7f16\u8f91\u5ba1\u6838\u4e2d\uff0c\u4e0d\u80fd\u6279\u91cf\u7ef4\u62a4\u56fe\u7247");
                    failReasonList.add(failReason);
                    continue;
                }
                if (!skuImagesMap.containsKey(skuId)) {
                    if (ObjectUtil.isEmpty(uccSkuPicListPoMap.get(skuId)) && ObjectUtil.isEmpty(skuPicPos)) {
                        flag.set(true);
                        failReason.setFailReason("\u5355\u54c1ID\uff1a" + skuId + "\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5355\u54c1\u56fe\u7247\u6570\u636e");
                        failReasonList.add(failReason);
                        break;
                    }
                    skuPicPos = (List)uccSkuPicListPoMap.get(skuId);
                    HashMap<Integer, ArrayList> tmpMap = new HashMap<Integer, ArrayList>();
                    tmpMap.put(imageNameSuffix, Lists.newArrayList((Object[])new UccSkuPicPo[]{(UccSkuPicPo)skuPicPos.get(imageNameSuffix - 1)}));
                    skuImagesMap.put((Long)skuId, tmpMap);
                    continue;
                }
                Map imagesMap = (Map)skuImagesMap.get(skuId);
                if (imagesMap.containsKey(imageNameSuffix)) continue;
                if (ObjectUtil.isEmpty(uccSkuPicListPoMap.get(skuId)) && ObjectUtil.isEmpty((Object)skuPicPos)) {
                    flag.set(true);
                    failReason.setFailReason("\u5355\u54c1ID\uff1a" + skuId + "\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5355\u54c1\u56fe\u7247\u6570\u636e");
                    failReasonList.add(failReason);
                    break;
                }
                skuPicPos = (List)uccSkuPicListPoMap.get(skuId);
                imagesMap.put(imageNameSuffix, Lists.newArrayList((Object[])new UccSkuPicPo[]{(UccSkuPicPo)skuPicPos.get(imageNameSuffix - 1)}));
            }
        });
        skuImagesMap.forEach((skuId, tmpMap) -> {
            if (tmpMap.containsKey(1) && !ObjectUtils.isEmpty(tmpMap.get(1)) && ((List)tmpMap.get(1)).size() > 1) {
                flag.set(true);
                failReason.setFailReason("\u5355\u54c1\u56fe\u7247\u4e3b\u56fe\u4e0d\u552f\u4e00");
                failReasonList.add(failReason);
            }
        });
        if (flag.get()) {
            rspBO.setFailReasonList(failReasonList.stream().distinct().collect(Collectors.toList()));
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        ArrayList updateUccSkuPicPoList = new ArrayList();
        skuImagesMap.forEach((skuId, tmpMap) -> {
            if (skuCommodityPicTypeMap.containsKey(skuId)) {
                Map commodityPicTypeMap = (Map)skuCommodityPicTypeMap.get(skuId);
                tmpMap.forEach((commodityPicType, uccSkuPicList) -> {
                    if (commodityPicTypeMap.containsKey(commodityPicType) && !ObjectUtils.isEmpty((Object)uccSkuPicList)) {
                        UccSkuPicPo skuPicPo = (UccSkuPicPo)uccSkuPicList.get(0);
                        skuPicPo.setSkuPicUrl((String)((List)commodityPicTypeMap.get(commodityPicType)).get(0));
                        updateUccSkuPicPoList.add(skuPicPo);
                    }
                });
            }
        });
        if (ObjectUtil.isNotEmpty(updateUccSkuPicPoList)) {
            for (UccSkuPicPo picPo : updateUccSkuPicPoList) {
                this.uccSkuPicMapper.updateSkuPic(picPo);
            }
        }
        this.syncEs(uccSkuPoList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setFailReasonList(failReasonList.stream().distinct().collect(Collectors.toList()));
        return rspBO;
    }

    private void syncEs(List<UccSkuPo> uccSkuPoList) {
        Map<Long, List<UccSkuPo>> mapSku = uccSkuPoList.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
        for (Long supplierShopId : mapSku.keySet()) {
            List skus = mapSku.get(supplierShopId).stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
            if (skus.size() > 200) {
                int increment = 200;
                int times = skus.size() % increment == 0 ? skus.size() / increment : skus.size() / increment + 1;
                int startIndex = 0;
                int endIndex = increment;
                for (int i = 1; i <= times; ++i) {
                    List skuPos = skus.subList(startIndex, i == times ? skus.size() : endIndex);
                    SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                    syncSceneCommodityToEsReqBO.setSkuIds(skuPos);
                    syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                    syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                    syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                    syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                    try {
                        this.lmBkSyncCommodityMqServiceProvider.send(new ProxyMessage(this.lmUccSyncTopic, this.lmUccSyncTag, JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                    }
                    catch (Exception e) {
                        log.error("\u540c\u6b65\u5546\u54c1\u6570\u636e\u5931\u8d25 \uff1a" + e);
                        throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
                    }
                    startIndex += increment;
                    endIndex += increment;
                }
                continue;
            }
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds(skus);
            syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            try {
                this.lmBkSyncCommodityMqServiceProvider.send(new ProxyMessage(this.lmUccSyncTopic, this.lmUccSyncTag, JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u5546\u54c1\u6570\u636e\u5931\u8d25 \uff1a" + e);
                throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
            }
        }
    }

    private void valSkuImagesInfo(List<UccBatchSaveGoodImagesBO> skuImagesList, AtomicBoolean flag, UccBatchSaveGoodImagesFailReason failReason, List<UccBatchSaveGoodImagesFailReason> failReasonList, Map<String, Map<Integer, String>> skuImageAddressMap) {
        HashSet<String> imageNameSet = new HashSet<String>();
        HashMap<String, Integer> imageCountMap = new HashMap<String, Integer>();
        ArrayList<String> skuCodeList = new ArrayList<String>();
        HashMap<Integer, String> skuCodeImageAddressMap = new HashMap<Integer, String>();
        for (UccBatchSaveGoodImagesBO bo : skuImagesList) {
            String skuImageName = bo.getSkuImageName();
            Integer imageNameSuffix = Integer.valueOf(skuImageName.substring(skuImageName.indexOf("_") + 1, skuImageName.indexOf(".")));
            if (!Pattern.matches(IMAGE_NAME_REGEX, skuImageName)) {
                flag.set(true);
                failReason.setFailReason(skuImageName + "\uff1a\u56fe\u7247\u547d\u540d\u4e0d\u7b26\u5408\u8981\u6c42(\u201c\u5355\u54c1\u7f16\u7801_xxx.\u56fe\u7247\u540e\u7f00\u201d\uff08xxx\u4e3a\u5e8f\u53f7\uff0c\u4ece1\u5f00\u59cb\uff09");
                failReasonList.add(failReason);
                break;
            }
            if (imageNameSet.contains(skuImageName)) {
                flag.set(true);
                failReason.setFailReason(skuImageName + "\uff1a\u56fe\u7247\u540d\u79f0\u91cd\u590d,\u8bf7\u91cd\u65b0\u4e0a\u4f20");
                failReasonList.add(failReason);
            }
            imageNameSet.add(skuImageName);
            String skuCode = skuImageName.substring(0, skuImageName.indexOf("_"));
            skuCodeList.add(skuCode);
            if (imageCountMap.containsKey(skuCode)) {
                imageCountMap.put(skuCode, (Integer)imageCountMap.get(skuCode) + 1);
                if ((Integer)imageCountMap.get(skuCode) > 5) {
                    flag.set(true);
                    failReason.setFailReason("\u5355\u54c1\u56fe\u7247\u6570\u91cf\u8d85\u8fc7\u4e0a\u9650\uff0c\u6700\u591a\u4e0a\u4f205\u5f20");
                    failReasonList.add(failReason);
                }
            } else {
                imageCountMap.put(skuCode, 1);
            }
            if (!skuImageAddressMap.containsKey(skuCode)) {
                skuCodeImageAddressMap = new HashMap();
                skuCodeImageAddressMap.put(imageNameSuffix, bo.getSkuImageAddress());
                skuImageAddressMap.put(skuCode, skuCodeImageAddressMap);
                continue;
            }
            skuCodeImageAddressMap.put(imageNameSuffix, bo.getSkuImageAddress());
            skuImageAddressMap.put(skuCode, skuCodeImageAddressMap);
        }
        List skuCodeExistsList = this.uccSkuMapper.querySkuCodeExists(skuCodeList);
        List skuCodeNoExistsList = skuCodeList.stream().filter(e -> !skuCodeExistsList.contains(e)).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(skuCodeNoExistsList)) {
            flag.set(true);
            for (String skuCode : skuCodeNoExistsList) {
                failReason.setFailReason("\u5355\u54c1\u7f16\u7801\uff1a" + skuCode + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u547d\u540d\u56fe\u7247\u540d\u79f0\uff01");
                failReasonList.add(failReason);
            }
        }
    }

    private void validate(UccBatchSaveGoodImagesReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuImagesList())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61[skuImagesList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UccBatchSaveGoodImagesBO bo : reqBO.getSkuImagesList()) {
            if (StringUtil.isEmpty((String)bo.getSkuImageName())) {
                throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61[skuImagesList]\u7684[skuImageName]\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtil.isEmpty((String)bo.getSkuImageAddress())) continue;
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61[skuImagesList]\u7684[skuImageAddress]\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

