/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.extension.ability.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.extension.bo.BkSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.extension.bo.BkSyncSceneCommodityToEsRspBO;
import com.tydic.commodity.common.busi.bo.SynEsInfoThreadBo;
import com.tydic.commodity.common.extension.ability.api.BkUccSyncSceneCommodityToEsAbilityService;
import com.tydic.commodity.common.extension.ability.bo.BkSyncAllCommodityToEsReqBO;
import com.tydic.commodity.common.extension.busi.api.BkSyncSceneCommodityToEsBusiService;
import com.tydic.commodity.common.extension.busi.impl.BkSynEsInfoThread;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.po.UccCommodityPo;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.extension.ability.api.BkUccSyncSceneCommodityToEsAbilityService"})
public class BkUccSyncSceneCommodityToEsAbilityServiceImpl
implements BkUccSyncSceneCommodityToEsAbilityService {
    private static final Logger log = LoggerFactory.getLogger(BkUccSyncSceneCommodityToEsAbilityServiceImpl.class);
    @Autowired
    private BkSyncSceneCommodityToEsBusiService syncSceneCommodityToEsBusiService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    private Integer syncSpuSize = 100;

    @PostMapping(value={"syncSceneCommodityToEs"})
    public BkSyncSceneCommodityToEsRspBO syncSceneCommodityToEs(@RequestBody BkSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO) {
        return this.syncSceneCommodityToEsBusiService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
    }

    @PostMapping(value={"syncAlllCommodityToEs"})
    public BkSyncSceneCommodityToEsRspBO syncAlllCommodityToEs(@RequestBody BkSyncAllCommodityToEsReqBO reqBO) {
        BkSyncSceneCommodityToEsRspBO rspBO = new BkSyncSceneCommodityToEsRspBO();
        long star = System.currentTimeMillis();
        if (reqBO.getSupplierId() != null) {
            return this.syncToEsImpl(reqBO);
        }
        List countShopIds = this.uccCommodityMapper.countShopIds();
        if (CollectionUtils.isEmpty((Collection)countShopIds)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u65e0\u540c\u6b65\u6570\u636e");
            return rspBO;
        }
        BkSyncAllCommodityToEsReqBO syncAllCommodityToEsReqBO = null;
        if (countShopIds.size() > 1) {
            for (Long each : countShopIds) {
                syncAllCommodityToEsReqBO = new BkSyncAllCommodityToEsReqBO();
                syncAllCommodityToEsReqBO.setSupplierId(each);
                int total = this.uccCommodityMapper.countCommodity(reqBO.getSupplierId());
                syncAllCommodityToEsReqBO.setTotal(total);
                syncAllCommodityToEsReqBO.setSupplierId(each);
                rspBO = this.run(syncAllCommodityToEsReqBO);
                if ("0000".equals(rspBO.getRespCode())) continue;
                return rspBO;
            }
        } else {
            syncAllCommodityToEsReqBO.setSupplierId((Long)countShopIds.get(0));
            rspBO = this.syncToEsImpl(syncAllCommodityToEsReqBO);
            if (!"0000".equals(rspBO.getRespCode())) {
                return rspBO;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("\u5546\u54c1\u66f4\u65b0\u7ed3\u675f\uff0c\u603b\u8017\u65f6\uff1a " + (System.currentTimeMillis() - star));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private BkSyncSceneCommodityToEsRspBO syncToEsImpl(BkSyncAllCommodityToEsReqBO reqBO) {
        int cycle;
        BkSyncSceneCommodityToEsRspBO rspBO = new BkSyncSceneCommodityToEsRspBO();
        int total = this.uccCommodityMapper.countCommodity(reqBO.getSupplierId());
        if (total == 0) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5e97\u94fa\u4e0b\u65e0\u540c\u6b65\u6570\u636e");
            return rspBO;
        }
        int n = cycle = total % this.syncSpuSize == 0 ? total / this.syncSpuSize : total / this.syncSpuSize + 1;
        if (cycle > 100) {
            reqBO.setTotal(total);
            this.run(reqBO);
        } else {
            BkSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = null;
            UccCommodityPo po = new UccCommodityPo();
            po.setSupplierShopId(reqBO.getSupplierId());
            Page page = new Page();
            for (int i = 1; i < cycle + 1; ++i) {
                page.setPageNo(i);
                page.setPageSize(reqBO.getSize());
                List comds = this.uccCommodityMapper.queryCommodityList(po, page);
                if (CollectionUtils.isEmpty((Collection)comds)) continue;
                syncSceneCommodityToEsReqBO = new BkSyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setCommodityIds(comds);
                syncSceneCommodityToEsReqBO.setSyncType(Integer.valueOf(0));
                syncSceneCommodityToEsReqBO.setOperType(Integer.valueOf(0));
                syncSceneCommodityToEsReqBO.setSupplierId(reqBO.getSupplierId());
                rspBO = this.syncSceneCommodityToEsBusiService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
                if ("0000".equals(rspBO.getRespCode())) continue;
                return rspBO;
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private BkSyncSceneCommodityToEsRspBO run(BkSyncAllCommodityToEsReqBO reqBO) {
        BkSyncSceneCommodityToEsRspBO rspBO = new BkSyncSceneCommodityToEsRspBO();
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("thread-call-runner-%d").build();
        ThreadPoolExecutor fixedThreadPool = new ThreadPoolExecutor(10, 50, 2000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
        if (log.isDebugEnabled()) {
            log.debug(reqBO.getSupplierId() + "\u5546\u54c1\u540c\u6b65es\u5f00\u59cb");
        }
        long start = System.currentTimeMillis();
        int cycle = reqBO.getTotal() % this.syncSpuSize == 0 ? reqBO.getTotal() / this.syncSpuSize : reqBO.getTotal() / this.syncSpuSize + 1;
        for (int i = 0; i < cycle; ++i) {
            SynEsInfoThreadBo synEsInfoThreadBo = new SynEsInfoThreadBo();
            synEsInfoThreadBo.setSupplierId(reqBO.getSupplierId());
            synEsInfoThreadBo.setStar(i * this.syncSpuSize);
            synEsInfoThreadBo.setEnd((i + 1) * this.syncSpuSize);
            synEsInfoThreadBo.setTotal(this.syncSpuSize);
            synEsInfoThreadBo.setSize(reqBO.getSize());
            synEsInfoThreadBo.setSize(this.syncSpuSize);
            if (synEsInfoThreadBo.getStar() > reqBO.getTotal()) continue;
            BkSynEsInfoThread synInfoThread = new BkSynEsInfoThread();
            synInfoThread.setUccCommodityMapper(this.uccCommodityMapper);
            synInfoThread.setSyncSceneCommodityToEsBusiService(this.syncSceneCommodityToEsBusiService);
            synInfoThread.setSynEsInfoThreadBo(synEsInfoThreadBo);
            fixedThreadPool.submit(synInfoThread);
        }
        fixedThreadPool.shutdown();
        while (true) {
            if (fixedThreadPool.isTerminated()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5546\u54c1\u66f4\u65b0\u7ed3\u675f");
        long end = System.currentTimeMillis();
        long l = (end - start) / 1000L;
        if (log.isDebugEnabled()) {
            log.debug("\u5546\u54c1\u66f4\u65b0\u7ed3\u675f\u8017\u65f6\uff1a " + l);
        }
        return rspBO;
    }
}

