/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.extension.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.extension.bo.BkSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.extension.bo.BkSyncSceneCommodityToEsRspBO;
import com.tydic.commodity.common.extension.ability.bo.BkUccMdmMaterialSyncBo;
import com.tydic.commodity.common.extension.busi.api.BkUccMdmMaterialSyncBusiService;
import com.tydic.commodity.common.extension.busi.bo.BkUccMdmMaterialSyncBusiReqBo;
import com.tydic.commodity.common.extension.busi.bo.BkUccMdmMaterialSyncBusiRspBo;
import com.tydic.commodity.extension.busibase.atom.api.BkSyncSceneCommodityToEsAtomService;
import com.tydic.commodity.extension.dao.BkUccEMdmCatalogMapper;
import com.tydic.commodity.extension.dao.BkUccEMdmMaterialMapper;
import com.tydic.commodity.extension.po.BkUccEMdmCatalogPO;
import com.tydic.commodity.extension.po.BkUccEMdmMaterialPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BkUccMdmMaterialSyncBusiServiceImpl
implements BkUccMdmMaterialSyncBusiService {
    private static final Logger log = LoggerFactory.getLogger(BkUccMdmMaterialSyncBusiServiceImpl.class);
    @Autowired
    private BkUccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private BkUccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private BkSyncSceneCommodityToEsAtomService bkSyncSceneCommodityToEsAtomService;
    private static final Long DEFAULT_OPER_ID = 1L;

    @Override
    public BkUccMdmMaterialSyncBusiRspBo syncMdmMaterial(BkUccMdmMaterialSyncBusiReqBo reqBo) {
        BkUccMdmMaterialSyncBusiRspBo rspBo = new BkUccMdmMaterialSyncBusiRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty(reqBo.getUccMdmMaterialSyncBoList())) {
            return rspBo;
        }
        List<BkUccMdmMaterialSyncBo> uccMdmMaterialSyncBoList = reqBo.getUccMdmMaterialSyncBoList();
        List materialCodeList = uccMdmMaterialSyncBoList.stream().map(BkUccMdmMaterialSyncBo::getMaterialCode).distinct().collect(Collectors.toList());
        List catalogCodeList = uccMdmMaterialSyncBoList.stream().map(BkUccMdmMaterialSyncBo::getCatalogCode).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(materialCodeList)) {
            List bkUccEMdmMaterialPOS;
            List uccEMdmMaterialPOS = this.uccEMdmMaterialMapper.batchQryByMaterialCodes(materialCodeList);
            List uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.getParentListByCodes(catalogCodeList);
            ConcurrentMap<String, BkUccEMdmMaterialPO> uuidMaterialMap = uccEMdmMaterialPOS.stream().collect(Collectors.toConcurrentMap(BkUccEMdmMaterialPO::getMaterialCode, o -> o));
            ConcurrentMap<String, Long> catalogCodeMap = null;
            if (!CollectionUtils.isEmpty((Collection)uccEMdmCatalogPOS)) {
                catalogCodeMap = uccEMdmCatalogPOS.stream().collect(Collectors.toConcurrentMap(BkUccEMdmCatalogPO::getCatalogCode, BkUccEMdmCatalogPO::getCatalogId, (old, cur) -> old));
            }
            ArrayList<BkUccEMdmMaterialPO> updatePoList = new ArrayList<BkUccEMdmMaterialPO>();
            ArrayList<BkUccEMdmMaterialPO> addPoList = new ArrayList<BkUccEMdmMaterialPO>();
            ArrayList<String> needUpdateCatalogList = new ArrayList<String>();
            for (BkUccMdmMaterialSyncBo uccMdmMaterialSyncBo : uccMdmMaterialSyncBoList) {
                BkUccEMdmMaterialPO uccEMdmMaterialPO2 = (BkUccEMdmMaterialPO)uuidMaterialMap.get(uccMdmMaterialSyncBo.getMaterialCode());
                String catalogCode = uccMdmMaterialSyncBo.getCatalogCode();
                String spec = uccMdmMaterialSyncBo.getSpec();
                if ("\u662f".equals(spec)) {
                    needUpdateCatalogList.add(catalogCode);
                }
                if (null != uccEMdmMaterialPO2) {
                    uccEMdmMaterialPO2.setMaterialName(uccMdmMaterialSyncBo.getMaterialName());
                    uccEMdmMaterialPO2.setLongDesc(uccMdmMaterialSyncBo.getLongDesc());
                    uccEMdmMaterialPO2.setBrandName(uccMdmMaterialSyncBo.getBrandName());
                    uccEMdmMaterialPO2.setMaterialCode(uccMdmMaterialSyncBo.getMaterialCode());
                    uccEMdmMaterialPO2.setShortDesc(uccMdmMaterialSyncBo.getShortDesc());
                    uccEMdmMaterialPO2.setTexture(uccMdmMaterialSyncBo.getTexture());
                    uccEMdmMaterialPO2.setFigure(uccMdmMaterialSyncBo.getFigure());
                    uccEMdmMaterialPO2.setModel(uccMdmMaterialSyncBo.getModel());
                    uccEMdmMaterialPO2.setSpec(uccMdmMaterialSyncBo.getSpec());
                    uccEMdmMaterialPO2.setMainModel(uccMdmMaterialSyncBo.getMainModel());
                    uccEMdmMaterialPO2.setManufacturer(uccMdmMaterialSyncBo.getManufacturer());
                    uccEMdmMaterialPO2.setMeasureCode(uccMdmMaterialSyncBo.getMeasure());
                    uccEMdmMaterialPO2.setRemark(uccMdmMaterialSyncBo.getRemark());
                    uccEMdmMaterialPO2.setUpdateTime(new Date());
                    if (null != uccMdmMaterialSyncBo.getUpdateLoginId()) {
                        uccEMdmMaterialPO2.setUpdateLoginId(uccMdmMaterialSyncBo.getUpdateLoginId());
                    } else {
                        uccEMdmMaterialPO2.setUpdateLoginId(DEFAULT_OPER_ID);
                    }
                    if (null != catalogCodeMap) {
                        uccEMdmMaterialPO2.setCatalogId((Long)catalogCodeMap.get(uccMdmMaterialSyncBo.getCatalogCode()));
                    }
                    if (null != uccMdmMaterialSyncBo.getMaterialId()) {
                        uccEMdmMaterialPO2.setMaterialId(uccMdmMaterialSyncBo.getMaterialId());
                    }
                    if (!StringUtils.isEmpty((Object)uccMdmMaterialSyncBo.getMeasureCode())) {
                        uccEMdmMaterialPO2.setMeasureCode(uccMdmMaterialSyncBo.getMeasureCode());
                    }
                    if (!StringUtils.isEmpty((Object)uccMdmMaterialSyncBo.getMeasure())) {
                        uccEMdmMaterialPO2.setMeasure(uccMdmMaterialSyncBo.getMeasure());
                    }
                    if (uccMdmMaterialSyncBo.getFreezeFlag() != null) {
                        uccEMdmMaterialPO2.setFreezeFlag(uccMdmMaterialSyncBo.getFreezeFlag());
                    }
                    uccEMdmMaterialPO2.setCatalogCode(uccMdmMaterialSyncBo.getCatalogCode());
                    updatePoList.add(uccEMdmMaterialPO2);
                    continue;
                }
                uccEMdmMaterialPO2 = (BkUccEMdmMaterialPO)JSON.parseObject((String)JSON.toJSONString((Object)uccMdmMaterialSyncBo), BkUccEMdmMaterialPO.class);
                uccEMdmMaterialPO2.setMaterialId(Long.valueOf(Sequence.getInstance().nextId()));
                uccEMdmMaterialPO2.setMeasureCode(uccMdmMaterialSyncBo.getMeasure());
                if (null != uccMdmMaterialSyncBo.getCreateTime()) {
                    uccEMdmMaterialPO2.setCreateTime(uccMdmMaterialSyncBo.getCreateTime());
                } else {
                    uccEMdmMaterialPO2.setCreateTime(new Date());
                }
                if (null != uccMdmMaterialSyncBo.getCreateLoginId()) {
                    uccEMdmMaterialPO2.setCreateLoginId(uccMdmMaterialSyncBo.getUpdateLoginId());
                } else {
                    uccEMdmMaterialPO2.setCreateLoginId(DEFAULT_OPER_ID);
                }
                if (null != catalogCodeMap) {
                    uccEMdmMaterialPO2.setCatalogId((Long)catalogCodeMap.get(uccMdmMaterialSyncBo.getCatalogCode()));
                }
                uccEMdmMaterialPO2.setCatalogCode(uccMdmMaterialSyncBo.getCatalogCode());
                addPoList.add(uccEMdmMaterialPO2);
            }
            if (ObjectUtil.isNotEmpty(needUpdateCatalogList)) {
                log.info("\u7269\u6599\u53d8\u66f4\uff0c\u9700\u8981\u5168\u90e8\u9ed8\u8ba4\u7535\u5546\u7269\u6599\u66f4\u65b0\u6210\u5426\u7684\u7269\u6599\u5206\u7c7b\u7f16\u7801\u5217\u8868\uff1a{}", (Object)JSON.toJSONString(needUpdateCatalogList));
                this.uccEMdmMaterialMapper.updateByCatalogCodeList(needUpdateCatalogList);
            }
            if (!CollectionUtils.isEmpty(addPoList)) {
                this.uccEMdmMaterialMapper.batchInsert(addPoList);
            }
            if (!CollectionUtils.isEmpty(updatePoList)) {
                updatePoList.forEach(uccEMdmMaterialPO -> this.uccEMdmMaterialMapper.updateByPrimaryKeySelective(uccEMdmMaterialPO));
            }
            if (ObjectUtil.isNotEmpty((Object)(bkUccEMdmMaterialPOS = this.uccEMdmMaterialMapper.qryDefaultMaterialByCodeList(materialCodeList)))) {
                Set catalogSet = bkUccEMdmMaterialPOS.stream().map(BkUccEMdmMaterialPO::getCatalogId).collect(Collectors.toSet());
                BkSyncSceneCommodityToEsReqBO syncReqBo = new BkSyncSceneCommodityToEsReqBO();
                syncReqBo.setOperType(Integer.valueOf(2));
                syncReqBo.setSyncType(Integer.valueOf(1));
                syncReqBo.setCategoryIds(new ArrayList(catalogSet));
                syncReqBo.setSingleType(0);
                log.info("\u7269\u6599\u53d8\u66f4\uff0c\u540c\u6b65es\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)syncReqBo));
                BkSyncSceneCommodityToEsRspBO bkSyncSceneCommodityToEsRspBO = this.bkSyncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncReqBo);
                log.info("\u7269\u6599\u53d8\u66f4\uff0c\u540c\u6b65es\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)bkSyncSceneCommodityToEsRspBO));
            }
        }
        return rspBo;
    }
}

