/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.extension.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.commodity.base.constant.OutMessageConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.extension.busi.api.BkUccOutMsgResolveBusiService;
import com.tydic.commodity.common.extension.busi.bo.BkUccOutMsgResolveBusiReqBO;
import com.tydic.commodity.dao.XExtSkuChangeHistoryProMapper;
import com.tydic.commodity.dao.XExtSkuChangeProMapper;
import com.tydic.commodity.po.XExtSkuChangeHistoryProPO;
import com.tydic.commodity.po.XExtSkuChangeProPO;
import com.tydic.dyc.base.bo.BaseRspBo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BkUccOutMsgResolveBusiServiceImpl
implements BkUccOutMsgResolveBusiService {
    private static final Logger log = LoggerFactory.getLogger(BkUccOutMsgResolveBusiServiceImpl.class);
    @Value(value="${kunpeng.msg.fail.count:5}")
    private Integer FAIL_COUNT;
    @Autowired
    private XExtSkuChangeProMapper xExtSkuChangeProMapper;
    @Autowired
    private XExtSkuChangeHistoryProMapper xExtSkuChangeHistoryProMapper;

    @Override
    public BaseRspBo dealOutMsgResolve(BkUccOutMsgResolveBusiReqBO reqBO) {
        try {
            ArrayList<Long> failIds = new ArrayList<Long>();
            List reqSuccList = JSON.parseArray((String)JSON.toJSONString(reqBO.getReqProList()), XExtSkuChangeProPO.class);
            if (!CollectionUtil.isEmpty(reqBO.getFailProList())) {
                List sucList;
                ArrayList<XExtSkuChangeHistoryProPO> failList = new ArrayList<XExtSkuChangeHistoryProPO>();
                ArrayList<Long> growFailCountIdList = new ArrayList<Long>();
                List reqFailList = JSON.parseArray((String)JSON.toJSONString(reqBO.getFailProList()), XExtSkuChangeProPO.class);
                for (XExtSkuChangeProPO po : reqFailList) {
                    failIds.add(po.getId());
                    po.setExtSkuHandleState(OutMessageConstant.EXT_SKU_HANDLE_STATE.FAIL);
                    po.setFailureCount(Integer.valueOf(po.getFailureCount() + 1));
                    po.setUpdateTime(new Date());
                    if (po.getFailureCount() >= this.FAIL_COUNT) {
                        XExtSkuChangeHistoryProPO historyProPO = (XExtSkuChangeHistoryProPO)JSON.parseObject((String)JSON.toJSONString((Object)po), XExtSkuChangeHistoryProPO.class);
                        failList.add(historyProPO);
                        continue;
                    }
                    growFailCountIdList.add(po.getId());
                }
                if (!CollectionUtil.isEmpty(failList)) {
                    this.xExtSkuChangeHistoryProMapper.insertBatch(failList);
                    this.xExtSkuChangeProMapper.deleteByIds(failList.stream().map(XExtSkuChangeHistoryProPO::getId).collect(Collectors.toList()));
                }
                if (!CollectionUtil.isEmpty(growFailCountIdList)) {
                    this.xExtSkuChangeProMapper.failedGrowth(growFailCountIdList);
                }
                if (!CollectionUtil.isEmpty(sucList = reqSuccList.stream().filter(e -> !failIds.contains(e.getId())).collect(Collectors.toList()))) {
                    List historyProPOS = JSON.parseArray((String)JSON.toJSONString(sucList), XExtSkuChangeHistoryProPO.class);
                    this.xExtSkuChangeHistoryProMapper.insertBatch(historyProPOS);
                    XExtSkuChangeProPO po = new XExtSkuChangeProPO();
                    po.setIds(sucList.stream().map(XExtSkuChangeProPO::getId).collect(Collectors.toList()));
                    this.xExtSkuChangeProMapper.deleteBy(po);
                }
            } else {
                List historyProPOS = JSON.parseArray((String)JSON.toJSONString(reqBO.getReqProList()), XExtSkuChangeHistoryProPO.class);
                this.xExtSkuChangeHistoryProMapper.insertBatch(historyProPOS);
                XExtSkuChangeProPO po = new XExtSkuChangeProPO();
                po.setIds(reqSuccList.stream().map(XExtSkuChangeProPO::getId).collect(Collectors.toList()));
                this.xExtSkuChangeProMapper.deleteBy(po);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error("\u6d88\u606f\u5904\u7406\u5931\u8d25 {}", (Object)e2.getMessage());
            throw new BusinessException("8888", e2.getMessage());
        }
        BaseRspBo rspBo = new BaseRspBo();
        rspBo.setRespCode("0000");
        return rspBo;
    }
}

