/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.extension.components.outmessage.parser;

import com.tydic.commodity.common.extension.ability.bo.UccOutMessageParsePoolBo;
import com.tydic.commodity.common.extension.ability.bo.UccParseAndSaveOutMessageServiceReqBo;
import com.tydic.commodity.common.extension.components.outmessage.parser.UccOutMessageParser;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class UccOutMessageParserManager {
    private static final Logger log = LoggerFactory.getLogger(UccOutMessageParserManager.class);
    private final Map<String, UccOutMessageParser> manageMap = new ConcurrentHashMap<String, UccOutMessageParser>();

    public UccOutMessageParsePoolBo parseOutMessage(UccParseAndSaveOutMessageServiceReqBo reqBo) {
        UccOutMessageParser instance = this.getInstance(reqBo);
        return instance.parseOutMessage(reqBo);
    }

    public void register(UccOutMessageParser intObj) {
        String supplierTypeCode = intObj.getSupplierMessageTypeCode();
        Assert.notNull((Object)intObj, (String)"intObj can not be null");
        Assert.notNull((Object)supplierTypeCode, (String)"supplierTypeCode can not be null");
        UccOutMessageParser intRet = this.manageMap.get(supplierTypeCode);
        if (intRet != null) {
            throw new BaseBusinessException("8888", "\u4e0d\u540c\u5916\u90e8\u6d88\u606f\u5904\u7406\u5b9e\u73b0\u7c7b(" + supplierTypeCode + ")\u51fa\u73b0\u591a\u4e2a\u5b9e\u73b0\u7c7b\uff01");
        }
        log.info(UccOutMessageParserManager.class.getSimpleName() + ".register\u6ce8\u518c\u4e86\u901a\u77e5\u5b9e\u73b0\u7c7b\uff1a" + supplierTypeCode);
        this.manageMap.put(supplierTypeCode, intObj);
    }

    private UccOutMessageParser getInstance(UccParseAndSaveOutMessageServiceReqBo reqBo) {
        String supplierMessageTypeCode = reqBo.getSupplier() + "_" + reqBo.getMessageType();
        UccOutMessageParser intRet = this.manageMap.get(supplierMessageTypeCode);
        if (intRet == null) {
            throw new BaseBusinessException("8888", "\u5916\u90e8\u6d88\u606f\u4fdd\u5b58\u5b9e\u73b0\u7c7b(" + supplierMessageTypeCode + ")\u4e0d\u5b58\u5728\uff01");
        }
        return intRet;
    }
}

