/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.extension.components.outmessage.resolver;

import com.tydic.commodity.common.extension.ability.bo.UccOutMessageResolveServiceReqBo;
import com.tydic.commodity.common.extension.ability.bo.UccOutMessageResolveServiceRspBo;
import com.tydic.commodity.common.extension.busi.api.BkUccOutMsgResolveBusiService;
import com.tydic.commodity.common.extension.busi.bo.BkUccOutMsgResolveBusiReqBO;
import com.tydic.commodity.common.extension.components.outmessage.resolver.UccOutMessageResolve;
import com.tydic.commodity.dao.XExtSkuChangeProMapper;
import com.tydic.dyc.base.bo.BaseRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class UccOutMessageResolveManager {
    private static final Logger log = LoggerFactory.getLogger(UccOutMessageResolveManager.class);
    @Autowired
    private XExtSkuChangeProMapper xExtSkuChangeProMapper;
    @Autowired
    private BkUccOutMsgResolveBusiService bkUccOutMsgResolveBusiService;
    private final Map<String, UccOutMessageResolve> manageMap = new ConcurrentHashMap<String, UccOutMessageResolve>();

    public BaseRspBo parseOutMessage(UccOutMessageResolveServiceReqBo reqBo) {
        UccOutMessageResolve instance = this.getInstance(reqBo);
        UccOutMessageResolveServiceRspBo dealOutMessage = instance.dealOutMessage(reqBo);
        if ("0000".equals(dealOutMessage.getRespCode())) {
            BkUccOutMsgResolveBusiReqBO outMsgResolveBusiReqBO = new BkUccOutMsgResolveBusiReqBO();
            outMsgResolveBusiReqBO.setReqProList(reqBo.getExtSkuChangeProBOS());
            outMsgResolveBusiReqBO.setFailProList(dealOutMessage.getFails());
            this.bkUccOutMsgResolveBusiService.dealOutMsgResolve(outMsgResolveBusiReqBO);
        }
        BaseRspBo rspBo = new BaseRspBo();
        rspBo.setRespCode("0000");
        return rspBo;
    }

    public void register(UccOutMessageResolve intObj) {
        String supplierTypeCode = intObj.getResolveTag();
        Assert.notNull((Object)intObj, (String)"intObj can not be null");
        Assert.notNull((Object)supplierTypeCode, (String)"supplierTypeCode can not be null");
        UccOutMessageResolve intRet = this.manageMap.get(supplierTypeCode);
        if (intRet != null) {
            throw new BaseBusinessException("8888", "\u4e0d\u540c\u5916\u90e8\u6d88\u606f\u5904\u7406\u5b9e\u73b0\u7c7b(" + supplierTypeCode + ")\u51fa\u73b0\u591a\u4e2a\u5b9e\u73b0\u7c7b\uff01");
        }
        log.info(UccOutMessageResolveManager.class.getSimpleName() + ".register\u6ce8\u518c\u4e86\u901a\u77e5\u5b9e\u73b0\u7c7b\uff1a" + supplierTypeCode);
        this.manageMap.put(supplierTypeCode, intObj);
    }

    private UccOutMessageResolve getInstance(UccOutMessageResolveServiceReqBo reqBo) {
        String supplierMessageTypeCode = reqBo.getSupplier() + "_" + reqBo.getMessageType();
        UccOutMessageResolve intRet = this.manageMap.get(supplierMessageTypeCode);
        if (intRet == null) {
            throw new BaseBusinessException("8888", "\u5916\u90e8\u6d88\u606f\u4fdd\u5b58\u5b9e\u73b0\u7c7b(" + supplierMessageTypeCode + ")\u4e0d\u5b58\u5728\uff01");
        }
        return intRet;
    }
}

