/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uic.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.uic.busi.api.UicEditCarBusiService;
import com.tydic.uic.busi.bo.UicEditCarBusiReqBO;
import com.tydic.uic.busi.bo.UicEditCarBusiRspBO;
import com.tydic.uic.dao.UicAttachmentMapper;
import com.tydic.uic.dao.UicCarMapper;
import com.tydic.uic.po.UicAttachmentPO;
import com.tydic.uic.po.UicCarPO;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UicEditCarBusiServiceImpl
implements UicEditCarBusiService {
    @Autowired
    private UicCarMapper uicCarMapper;
    @Autowired
    private UicAttachmentMapper uicAttachmentMapper;

    @Override
    public UicEditCarBusiRspBO editCar(UicEditCarBusiReqBO reqBO) {
        String needApprove = reqBO.getNeedApprove();
        UicEditCarBusiRspBO rspBO = new UicEditCarBusiRspBO();
        UicCarPO uicCarPO = new UicCarPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uicCarPO);
        uicCarPO.setUpdateTime(new Date());
        uicCarPO.setUpdateUserId(reqBO.getUserId());
        uicCarPO.setUpdateUserName(reqBO.getUserName());
        if ("1".equals(needApprove)) {
            uicCarPO.setCarApproveStatus(1);
        } else {
            uicCarPO.setCarApproveStatus(2);
        }
        int i = this.uicCarMapper.updateByPrimaryKeySelective(uicCarPO);
        if (i != 1) {
            throw new ZTBusinessException("\u66f4\u65b0\u8f66\u8f86\u4fe1\u606f\u5931\u8d25");
        }
        this.deleteAttach(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8f66\u8f86\u7f16\u8f91\u64cd\u4f5c\u6210\u529f");
        return rspBO;
    }

    private void deleteAttach(UicEditCarBusiReqBO reqBO) {
        UicAttachmentPO po = new UicAttachmentPO();
        po.setRelateType(1);
        po.setRelateId(reqBO.getCarId());
        this.uicAttachmentMapper.deleteByPrimaryKey(po);
        List<UicAttachmentPO> pos = reqBO.getAttachmentInfos().stream().map(obj -> {
            UicAttachmentPO uicAttachmentPO = new UicAttachmentPO();
            BeanUtils.copyProperties((Object)obj, (Object)uicAttachmentPO);
            uicAttachmentPO.setAttachmentId(Sequence.getInstance().nextId());
            uicAttachmentPO.setRelateType(1);
            uicAttachmentPO.setRelateId(reqBO.getCarId());
            return uicAttachmentPO;
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(pos)) {
            int a = this.uicAttachmentMapper.insertBatch(pos);
            if (pos.size() != a) {
                throw new ZTBusinessException("\u65b0\u589e\u9644\u4ef6\u4fe1\u606f\u5931\u8d25");
            }
        }
    }
}

