/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uic.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.uic.atom.api.ToDoListNotifyAtomService;
import com.tydic.uic.atom.api.UicStartApprovalProcessAtomService;
import com.tydic.uic.busi.api.UicSubmitInsureBusiService;
import com.tydic.uic.busi.bo.UicAddOrderPolicyInfoReqBO;
import com.tydic.uic.busi.bo.UicAddPolicyInfoReqBO;
import com.tydic.uic.busi.bo.UicAddVehicleRiskReqBO;
import com.tydic.uic.busi.bo.UicInvoiceInfoReqBO;
import com.tydic.uic.busi.bo.UicSubmitInsureBusiReqBO;
import com.tydic.uic.busi.bo.UicSubmitInsureBusiRspBO;
import com.tydic.uic.dao.UicAttachmentMapper;
import com.tydic.uic.dao.UicCarMapper;
import com.tydic.uic.dao.UicInsuranceMapper;
import com.tydic.uic.dao.UicInvoiceAddressMapper;
import com.tydic.uic.dao.UicInvoiceMapper;
import com.tydic.uic.dao.UicOrderMapper;
import com.tydic.uic.dao.UicOrderRelationMapper;
import com.tydic.uic.po.UicAttachmentPO;
import com.tydic.uic.po.UicCarPO;
import com.tydic.uic.po.UicInvoiceAddressPO;
import com.tydic.uic.po.UicInvoicePO;
import com.tydic.uic.po.UicOrderPO;
import com.tydic.uic.po.UicOrderRelationPO;
import com.tydic.uic.utils.HttpUtil;
import com.tydic.uic.utils.UicTransFieldUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UicSubmitInsureBusiServiceImpl
implements UicSubmitInsureBusiService {
    private static final Logger log = LoggerFactory.getLogger(UicSubmitInsureBusiServiceImpl.class);
    @Autowired
    private UicOrderMapper uicOrderMapper;
    @Autowired
    private UicOrderRelationMapper uicOrderRelationMapper;
    @Autowired
    private UicInvoiceMapper uicInvoiceMapper;
    @Autowired
    private UicInvoiceAddressMapper uicInvoiceAddressMapper;
    @Autowired
    private UicAttachmentMapper uicAttachmentMapper;
    @Autowired
    private UicStartApprovalProcessAtomService uicStartApprovalProcessAtomService;
    @Autowired
    private UicInsuranceMapper uicInsuranceMapper;
    @Autowired
    private ToDoListNotifyAtomService toDoListNotifyAtomService;
    @Autowired
    private UicCarMapper uicCarMapper;
    @Value(value="${ESB_ACCESS_IP}")
    private String ADDRESS;
    private static final String SERVICE = "/OSN/api/addorderpolicy/v1";
    private static final String CODE_SUCCESS = "0";
    @Value(value="${waibuFlag:true}")
    private Boolean waibuFlag;
    public static final String PROCESS = "\u6295\u4fdd\u63d0\u4ea4\u5ba1\u6279";

    @Override
    public UicSubmitInsureBusiRspBO submitInsure(UicSubmitInsureBusiReqBO reqBO) {
        UicSubmitInsureBusiRspBO rspBO = new UicSubmitInsureBusiRspBO();
        if (!"3".equals(reqBO.getType())) {
            if ("1".equals(reqBO.getType())) {
                log.info("\u518d\u6b21\u6295\u4fdd " + reqBO.getOrderId());
                this.updateOrder(reqBO);
            } else {
                log.info("\u7b2c\u4e00\u6b21\u6295\u4fdd " + reqBO.getOrderId());
                this.insertOrder(reqBO);
            }
            this.insertAll(reqBO);
        } else if (reqBO.getIsFinish().booleanValue()) {
            this.newAppove(reqBO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6295\u4fdd\u63d0\u4ea4\u6210\u529f");
        return rspBO;
    }

    private void insertAll(UicSubmitInsureBusiReqBO reqBO) {
        this.insertOrderDetail(reqBO);
        this.insertInvoice(reqBO);
        this.insertAddress(reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getAttachmentInfos())) {
            this.insertAttachemnt(reqBO);
        }
    }

    private void insertOrder(UicSubmitInsureBusiReqBO reqBO) {
        UicOrderPO uicOrderPO = new UicOrderPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uicOrderPO);
        uicOrderPO.setOrderNo(Sequence.getInstance().nextId() + "");
        uicOrderPO.setApproveStatus(1);
        uicOrderPO.setStatus(1);
        uicOrderPO.setCreateTime(new Date());
        uicOrderPO.setCreateUserId(reqBO.getUserId());
        uicOrderPO.setCreateUserName(reqBO.getName());
        uicOrderPO.setInsureOrgId(reqBO.getOrgId());
        uicOrderPO.setInsureOrgName(reqBO.getOrgNameInnerFullIn());
        uicOrderPO.setGenerateFlag(0);
        UicCarPO uicCarPO = this.uicCarMapper.selectByPrimaryKey(reqBO.getCarId());
        uicOrderPO.setInsureOrgIdOld(uicCarPO.getCarIdentifyCode());
        uicOrderPO.setCarId(reqBO.getCarId());
        uicOrderPO.setEngineNo(uicCarPO.getEngineNo());
        uicOrderPO.setLegalPersonCompanyId(reqBO.getLegalPersonCompanyId());
        uicOrderPO.setLegalPersonCompanyName(reqBO.getLegalPersonCompanyName());
        int i = this.uicOrderMapper.insertSelective(uicOrderPO);
        if (1 != i) {
            throw new ZTBusinessException("\u65b0\u589e\u4fdd\u5355\u8868\u5931\u8d25");
        }
    }

    private void updateOrder(UicSubmitInsureBusiReqBO reqBO) {
        UicOrderPO uicOrderPO = new UicOrderPO();
        uicOrderPO.setOrderId(reqBO.getOrderId());
        uicOrderPO.setApproveStatus(1);
        uicOrderPO.setStatus(1);
        uicOrderPO.setCreateUserId(reqBO.getUserId());
        uicOrderPO.setCreateUserName(reqBO.getName());
        uicOrderPO.setInsureOrgId(reqBO.getOrgId());
        uicOrderPO.setInsureOrgName(reqBO.getOrgNameInnerFullIn());
        uicOrderPO.setRemark(reqBO.getRemark());
        uicOrderPO.setDeliveryTime(reqBO.getDeliveryTime());
        uicOrderPO.setStepId(reqBO.getStepId());
        uicOrderPO.setAuditOrderId(reqBO.getAuditOrderId());
        uicOrderPO.setRegionOrgPath(reqBO.getRegionOrgPath());
        uicOrderPO.setLegalPersonCompanyId(reqBO.getLegalPersonCompanyId());
        uicOrderPO.setLegalPersonCompanyName(reqBO.getLegalPersonCompanyName());
        try {
            this.uicOrderMapper.updateByPrimaryKeySelective(uicOrderPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u4fee\u6539\u4fdd\u5355\u8868\u5931\u8d25");
        }
        this.uicOrderRelationMapper.deleteByPrimaryKey(reqBO.getOrderId());
    }

    private void insertOrderDetail(UicSubmitInsureBusiReqBO reqBO) {
        List<UicOrderRelationPO> poList = reqBO.getInsureItems().stream().map(obj -> {
            UicOrderRelationPO uicOrderRelationPO = new UicOrderRelationPO();
            BeanUtils.copyProperties((Object)obj, (Object)uicOrderRelationPO);
            uicOrderRelationPO.setOrderId(reqBO.getOrderId());
            uicOrderRelationPO.setId(Sequence.getInstance().nextId());
            return uicOrderRelationPO;
        }).collect(Collectors.toList());
        int i = this.uicOrderRelationMapper.insertBatch(poList);
        if (i != poList.size()) {
            throw new ZTBusinessException("\u65b0\u589e\u6295\u4fdd\u660e\u7ec6\u8868\u5931\u8d25");
        }
    }

    private void insertInvoice(UicSubmitInsureBusiReqBO reqBO) {
        UicInvoicePO uicInvoicePO = new UicInvoicePO();
        BeanUtils.copyProperties((Object)reqBO.getInvoiceInfo(), (Object)uicInvoicePO);
        uicInvoicePO.setInvoiceId(Sequence.getInstance().nextId());
        uicInvoicePO.setInvoiceType(String.valueOf(reqBO.getInvoiceInfo().getInvoiceType()));
        uicInvoicePO.setOrderId(reqBO.getOrderId());
        int i = this.uicInvoiceMapper.insertSelective(uicInvoicePO);
        if (1 != i) {
            throw new ZTBusinessException("\u65b0\u589e\u4fdd\u9669\u53d1\u7968\u8868\u5931\u8d25");
        }
    }

    private void insertAddress(UicSubmitInsureBusiReqBO reqBO) {
        UicInvoiceAddressPO uicInvoiceAddressPO = new UicInvoiceAddressPO();
        BeanUtils.copyProperties((Object)reqBO.getInvoiceAddressInfo(), (Object)uicInvoiceAddressPO);
        uicInvoiceAddressPO.setId(Sequence.getInstance().nextId());
        uicInvoiceAddressPO.setOrderId(reqBO.getOrderId());
        int i = this.uicInvoiceAddressMapper.insertSelective(uicInvoiceAddressPO);
        if (1 != i) {
            throw new ZTBusinessException("\u65b0\u589e\u4fdd\u5355\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u8868\u5931\u8d25");
        }
    }

    private void insertAttachemnt(UicSubmitInsureBusiReqBO reqBO) {
        List<UicAttachmentPO> collect = reqBO.getAttachmentInfos().stream().map(obj -> {
            UicAttachmentPO uicAttachmentPO = new UicAttachmentPO();
            uicAttachmentPO.setAttachmentUrl(obj.getAttachmentUrl());
            uicAttachmentPO.setAttachmentName(obj.getAttachmentName());
            uicAttachmentPO.setRelateType(2);
            uicAttachmentPO.setRelateId(reqBO.getOrderId());
            uicAttachmentPO.setAttachmentId(Sequence.getInstance().nextId());
            return uicAttachmentPO;
        }).collect(Collectors.toList());
        int i = this.uicAttachmentMapper.insertBatch(collect);
        if (i != collect.size()) {
            throw new ZTBusinessException("\u65b0\u589e\u9644\u4ef6\u4fe1\u606f\u8868\u5931\u8d25");
        }
    }

    private void newAppove(UicSubmitInsureBusiReqBO reqBO) {
        UicOrderPO po = new UicOrderPO();
        po.setOrderId(reqBO.getOrderId());
        po.setApproveStatus(2);
        this.uicOrderMapper.updateByPrimaryKeySelective(po);
        UicOrderPO uicOrderPO = this.uicOrderMapper.selectByPrimaryKey(reqBO.getOrderId());
        log.info("\u8f66\u8f86id{},\u8f66\u67b6\u53f7{}", (Object)uicOrderPO.getCarId(), (Object)uicOrderPO.getInsureOrgIdOld());
        List<UicOrderRelationPO> uicOrderRelationPOS = this.uicOrderRelationMapper.selectByList(reqBO.getOrderId());
        UicInvoicePO uicInvoicePO = this.uicInvoiceMapper.selectByPrimaryKey(reqBO.getOrderId());
        UicInvoiceAddressPO uicInvoiceAddressPO = this.uicInvoiceAddressMapper.selectByPrimaryKey(reqBO.getOrderId());
        UicAddOrderPolicyInfoReqBO infoReqBO = new UicAddOrderPolicyInfoReqBO();
        infoReqBO.setMerchOrderNo(uicOrderPO.getOrderNo());
        infoReqBO.setPlateNo(uicOrderPO.getCarNo());
        infoReqBO.setMerchVehicleInfoNo(uicOrderPO.getCarId() + "");
        infoReqBO.setInsuranceCompany(this.uicInsuranceMapper.selectByCompany());
        infoReqBO.setOrderStatus(1);
        UicInvoiceInfoReqBO infoReqBO1 = new UicInvoiceInfoReqBO();
        int invoiceTypeOut = UicTransFieldUtil.tranUicInvoiceTypeOut(uicInvoicePO.getInvoiceType());
        infoReqBO1.setInvoiceType(invoiceTypeOut);
        infoReqBO1.setTin(uicInvoicePO.getTaxpayerId());
        infoReqBO1.setCompanyName(uicOrderPO.getInsureOrgName());
        infoReqBO1.setRegisterAddress(uicInvoicePO.getAddress());
        infoReqBO1.setRegisterPhone(uicInvoicePO.getPhone());
        infoReqBO1.setDepositBank(uicInvoicePO.getBank());
        infoReqBO1.setBankAccount(uicInvoicePO.getAccount());
        infoReqBO1.setReceiverName(uicInvoiceAddressPO.getName());
        infoReqBO1.setReceiverPhone(uicInvoiceAddressPO.getTel());
        String address = uicInvoiceAddressPO.getProvinceName() + uicInvoiceAddressPO.getCityName() + uicInvoiceAddressPO.getCountyName() + uicInvoiceAddressPO.getTownName() + uicInvoiceAddressPO.getAddrDesc();
        infoReqBO1.setReceiverAddress(address);
        infoReqBO.setInvoiceInfo(infoReqBO1);
        ArrayList<UicAddPolicyInfoReqBO> intgPolicyInfoList = new ArrayList<UicAddPolicyInfoReqBO>();
        ArrayList<UicAddVehicleRiskReqBO> boList1 = new ArrayList<UicAddVehicleRiskReqBO>();
        ArrayList<UicAddVehicleRiskReqBO> boList2 = new ArrayList<UicAddVehicleRiskReqBO>();
        uicOrderRelationPOS.forEach(obj -> {
            UicAddVehicleRiskReqBO riskBO = new UicAddVehicleRiskReqBO();
            riskBO.setPlateNo(uicOrderPO.getCarNo());
            riskBO.setRiskCode(obj.getInsuranceCode());
            riskBO.setRiskName(obj.getInsuranceName());
            String sumInsured = obj.getSumInsured();
            if (sumInsured.contains("\u4e07")) {
                riskBO.setSumInsured(sumInsured.substring(0, sumInsured.lastIndexOf("\u4e07")) + "0000");
            } else {
                riskBO.setSumInsured(sumInsured);
            }
            riskBO.setAerDesc(obj.getAer() == 1 ? "\u662f" : "\u5426");
            if (obj.getInsuranceType() == 1 && !"1".equals(obj.getSumInsured())) {
                boList1.add(riskBO);
            }
            if (obj.getInsuranceType() == 2) {
                boList2.add(riskBO);
            }
        });
        if (!CollectionUtils.isEmpty(boList2)) {
            UicAddPolicyInfoReqBO bo1 = new UicAddPolicyInfoReqBO();
            bo1.setPlateNo(uicOrderPO.getCarNo());
            bo1.setPolicyType(1);
            bo1.setVehicleRiskList(boList2);
            bo1.setPolicyStatus(1);
            intgPolicyInfoList.add(bo1);
        }
        if (!CollectionUtils.isEmpty(boList1)) {
            UicAddPolicyInfoReqBO bo2 = new UicAddPolicyInfoReqBO();
            bo2.setPlateNo(uicOrderPO.getCarNo());
            bo2.setPolicyType(2);
            bo2.setVehicleRiskList(boList1);
            bo2.setPolicyStatus(1);
            intgPolicyInfoList.add(bo2);
        }
        infoReqBO.setIntgPolicyInfoList(intgPolicyInfoList);
        log.info("\u8bf7\u6c42\u5730\u5740: " + this.ADDRESS + SERVICE);
        log.info("\u8bf7\u6c42\u53c2\u6570: " + JSON.toJSONString((Object)infoReqBO));
        if (this.waibuFlag.booleanValue()) {
            String s = HttpUtil.doPost(this.ADDRESS + SERVICE, JSON.toJSONString((Object)infoReqBO));
            log.info("\u8bf7\u6c42\u51fa\u53c2\uff1a" + s);
            JSONObject obj2 = JSON.parseObject((String)s);
            if (!s.contains("code") || !CODE_SUCCESS.equals(obj2.getString("code"))) {
                log.info("\u65b0\u589e\u8ba2\u5355\u4fdd\u9669\u5931\u8d25");
                UicOrderPO poLog = new UicOrderPO();
                poLog.setOrderId(uicOrderPO.getOrderId());
                poLog.setParamReq(JSON.toJSONString((Object)infoReqBO));
                poLog.setParamRsq(s);
                poLog.setCreateTime(new Date());
                this.uicOrderMapper.saveLog(poLog);
            }
        }
    }
}

