/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uic.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.uic.busi.api.UicTransferAndJoinTaskBusiService;
import com.tydic.uic.busi.bo.UicTransferAndJoinTaskBusiReqBO;
import com.tydic.uic.busi.bo.UicTransferAndJoinTaskBusiRspBO;
import com.tydic.uic.dao.UicOrderMapper;
import com.tydic.uic.insurance.ability.bo.EacRuTaskAbilityBO;
import com.tydic.uic.po.EacRuTaskPO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UicTransferAndJoinTaskBusiServiceImpl
implements UicTransferAndJoinTaskBusiService {
    private static final Logger log = LoggerFactory.getLogger(UicTransferAndJoinTaskBusiServiceImpl.class);
    @Autowired
    private UicOrderMapper uicOrderMapper;

    @Override
    public UicTransferAndJoinTaskBusiRspBO transferAndJoinTask(UicTransferAndJoinTaskBusiReqBO reqBO) {
        if (reqBO.getType() == 1) {
            EacRuTaskPO eacRuTaskPO = new EacRuTaskPO();
            eacRuTaskPO.setBusinessId(reqBO.getOrderId() + "");
            eacRuTaskPO.setUserId(reqBO.getTransferUserId());
            eacRuTaskPO.setUserName(reqBO.getTransferUserName());
            eacRuTaskPO.setOrgId(reqBO.getTransferOrgId());
            eacRuTaskPO.setOrgName(reqBO.getTransferOrgName());
            eacRuTaskPO.setStationCode(reqBO.getTransferStationCode());
            eacRuTaskPO.setStationName(reqBO.getTransferStationName());
            eacRuTaskPO.setRoleId(reqBO.getTransferRoleId());
            eacRuTaskPO.setRoleName(reqBO.getTransferRoleName());
            eacRuTaskPO.setTaskId(reqBO.getTaskId());
            this.uicOrderMapper.updateEacTran(eacRuTaskPO);
        }
        if (reqBO.getType() == 2 || reqBO.getType() == 3) {
            this.uicOrderMapper.updateFilter(reqBO.getOrderId());
            this.taskProcess(reqBO.getTaskList());
        }
        if (reqBO.getType() == 4 && !CollectionUtils.isEmpty(reqBO.getTaskList())) {
            this.taskProcess(reqBO.getTaskList());
        }
        UicTransferAndJoinTaskBusiRspBO rspBO = new UicTransferAndJoinTaskBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("0000");
        return rspBO;
    }

    private void taskProcess(List<EacRuTaskAbilityBO> taskList) {
        taskList.forEach(obj -> {
            EacRuTaskPO eacRuTaskPO = new EacRuTaskPO();
            BeanUtils.copyProperties((Object)obj, (Object)eacRuTaskPO);
            Long nextId = Sequence.getInstance().nextId();
            eacRuTaskPO.setStatus("0");
            eacRuTaskPO.setId(nextId);
            eacRuTaskPO.setCreateTime(new Date());
            eacRuTaskPO.setApproveStatus(2);
            this.uicOrderMapper.insertSelectiveEac(eacRuTaskPO);
        });
    }
}

