/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.esb;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.external.api.bo.FscBillGetYcPersonInfoReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillGetYcPersonInfoRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleDecryptionReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleDecryptionRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleEncryPtionReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleEncryPtionRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscBillGetYcPersonInfoService;
import com.tydic.fsc.busibase.external.api.esb.FscUnifySettleRelatedInterfacesAtomService;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.EncryptUtil;
import com.tydic.fsc.utils.SSLClient;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class FscBillGetYcPersonInfoServiceImpl
implements FscBillGetYcPersonInfoService {
    private static final Logger log = LoggerFactory.getLogger(FscBillGetYcPersonInfoServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Value(value="${YC_PERSON_INFO_URL:http://172.16.11.136:30000/eip-ar/ebay/queryPer}")
    private String Bill_TAX_YC_SYS_URL;
    @Value(value="${YC_PERSON_SQL_ID:30050}")
    private String personSqlId;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;
    @Autowired
    private FscUnifySettleRelatedInterfacesAtomService fscUnifySettleRelatedInterfacesAtomService;
    @Autowired
    private Environment prop;

    @Override
    public FscBillGetYcPersonInfoRspBO getPersonInfo(FscBillGetYcPersonInfoReqBO reqBO) {
        if (this.isDebugEnabled) {
            log.debug("\u5411\u4e1a\u8d22\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5165\u53c2\uff1a" + reqBO.toString());
        }
        this.valid(reqBO);
        PebExtUnifySettleTokenQryAbilityReqBO qryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        qryAbilityReqBO.setUserId(reqBO.getAgentAccount().toString());
        qryAbilityReqBO.setTimeOut(reqBO.getTimeOut());
        PebExtUnifySettleTokenQryAbilityRspBO qryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(qryAbilityReqBO);
        if (!qryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(qryAbilityRspBO.getRespCode(), "\u83b7\u53d6\u65b0\u4e1a\u8d22token\u5931\u8d25\uff1a" + qryAbilityRspBO.getMsg());
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", qryAbilityRspBO.getData());
        JSONArray jsonArray = new JSONArray();
        JSONObject object = new JSONObject();
        object.put("sqlId", (Object)this.personSqlId);
        HashMap<String, Object> jsonMap = new HashMap<String, Object>(2);
        jsonMap.put("ORG_ID", reqBO.getORG_ID());
        jsonMap.put("PERSON_NUM", reqBO.getPERSON_NUM());
        jsonMap.put("PERSON_NAME", reqBO.getPERSON_NAME());
        object.put("jsonMap", jsonMap);
        jsonArray.add((Object)object);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        FscUnifySettleEncryPtionReqBO encryptionAbilityReqBO = new FscUnifySettleEncryPtionReqBO();
        encryptionAbilityReqBO.setData(jsonArray.toString());
        FscUnifySettleEncryPtionRspBO encryptionRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealArrayEncryption(encryptionAbilityReqBO);
        if (StringUtils.isEmpty((Object)encryptionRspBO.getData())) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u65b0\u4e1a\u8d22\u52a0\u5bc6\u63a5\u53e3\u5931\u8d25\uff1a" + encryptionRspBO.getMsg());
        }
        paramMap.put("cipherCode", encryptionRspBO.getData());
        log.debug("\u5411\u4e1a\u8d22\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u8bf7\u6c42\u62a5\u6587\uff1a{}, \u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)jsonArray.toJSONString(), (Object)this.Bill_TAX_YC_SYS_URL);
        String returnString = SSLClient.doPost(this.Bill_TAX_YC_SYS_URL, paramMap, headerMap);
        log.debug("\u5411\u4e1a\u8d22\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)returnString);
        if (StringUtils.isEmpty((Object)returnString)) {
            throw new FscBusinessException("194317", "\u5411\u4e1a\u8d22\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        JSONObject jsonObject = JSON.parseObject((String)returnString);
        String data = jsonObject.getString("data");
        if (StringUtils.isEmpty((Object)data)) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u65b0\u4e1a\u8d22\u8fd4\u56de\u4eba\u5458\u4fe1\u606fdata\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        FscUnifySettleDecryptionReqBO decryptionAbilityReqBO = new FscUnifySettleDecryptionReqBO();
        decryptionAbilityReqBO.setData(data);
        FscUnifySettleDecryptionRspBO decryptionAbilityRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealParamDecryption(decryptionAbilityReqBO);
        if (StringUtils.isEmpty((Object)decryptionAbilityRspBO.getData())) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u65b0\u4e1a\u8d22\u89e3\u5bc6\u63a5\u53e3\u5931\u8d25\uff1a" + decryptionAbilityRspBO.getRespDesc());
        }
        JSONObject result = JSONObject.parseObject((String)decryptionAbilityRspBO.getData());
        log.debug("\u4e1a\u8d22\u4eba\u5458\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\u89e3\u5bc6\uff1a{}" + decryptionAbilityRspBO.getData());
        FscBillGetYcPersonInfoRspBO fscBillGetYcPersonInfoRspBO = new FscBillGetYcPersonInfoRspBO();
        fscBillGetYcPersonInfoRspBO.setRespCode("0000");
        if (!ObjectUtils.isEmpty((Object)result.getString("flag"))) {
            fscBillGetYcPersonInfoRspBO.setFlag(result.getString("flag"));
        }
        if (!ObjectUtils.isEmpty((Object)result.getString("msg"))) {
            fscBillGetYcPersonInfoRspBO.setMsg(result.getString("msg"));
        }
        if (result.isEmpty()) {
            return fscBillGetYcPersonInfoRspBO;
        }
        if (ObjectUtils.isEmpty((Object)result.get((Object)"outJsonMap"))) {
            return fscBillGetYcPersonInfoRspBO;
        }
        fscBillGetYcPersonInfoRspBO = (FscBillGetYcPersonInfoRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)result.get((Object)"outJsonMap")), FscBillGetYcPersonInfoRspBO.class));
        fscBillGetYcPersonInfoRspBO.setRespCode("0000");
        return fscBillGetYcPersonInfoRspBO;
    }

    @Override
    public FscBillGetYcPersonInfoRspBO getPersonInfo1(FscBillGetYcPersonInfoReqBO reqBO) {
        if (this.isDebugEnabled) {
            log.debug("\u5411\u4e1a\u8d22\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5165\u53c2\uff1a" + reqBO.toString());
        }
        this.valid(reqBO);
        PebExtUnifySettleTokenQryAbilityReqBO qryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        qryAbilityReqBO.setUserId(reqBO.getAgentAccount().toString());
        PebExtUnifySettleTokenQryAbilityRspBO qryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(qryAbilityReqBO);
        if (!qryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(qryAbilityRspBO.getRespCode(), "\u83b7\u53d6\u65b0\u4e1a\u8d22token\u5931\u8d25\uff1a" + qryAbilityRspBO.getMsg());
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", qryAbilityRspBO.getData());
        headerMap.put("stamp", EncryptUtil.getStamp());
        JSONArray jsonArray = new JSONArray();
        JSONObject object = new JSONObject();
        object.put("sqlId", (Object)this.personSqlId);
        HashMap<String, Object> jsonMap = new HashMap<String, Object>(2);
        jsonMap.put("ORG_ID", reqBO.getORG_ID());
        jsonMap.put("PERSON_NUM", reqBO.getPERSON_NUM());
        jsonMap.put("PERSON_NAME", reqBO.getPERSON_NAME());
        object.put("jsonMap", jsonMap);
        jsonArray.add((Object)object);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        FscUnifySettleEncryPtionReqBO encryptionAbilityReqBO = new FscUnifySettleEncryPtionReqBO();
        encryptionAbilityReqBO.setData(jsonArray.toString());
        FscUnifySettleEncryPtionRspBO encryptionRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealArrayEncryption(encryptionAbilityReqBO);
        if (StringUtils.isEmpty((Object)encryptionRspBO.getData())) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u65b0\u4e1a\u8d22\u52a0\u5bc6\u63a5\u53e3\u5931\u8d25\uff1a" + encryptionRspBO.getMsg());
        }
        paramMap.put("cipherCode", encryptionRspBO.getData());
        log.debug("\u5411\u4e1a\u8d22\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u8bf7\u6c42\u62a5\u6587\uff1a{}, \u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)jsonArray.toJSONString(), (Object)this.Bill_TAX_YC_SYS_URL);
        String returnString = SSLClient.doPostNew(this.Bill_TAX_YC_SYS_URL, paramMap, headerMap);
        log.debug("\u5411\u4e1a\u8d22\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)returnString);
        if (StringUtils.isEmpty((Object)returnString)) {
            throw new FscBusinessException("194317", "\u5411\u4e1a\u8d22\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        JSONObject jsonObject = JSON.parseObject((String)returnString);
        String data = jsonObject.getString("data");
        if (StringUtils.isEmpty((Object)data)) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u65b0\u4e1a\u8d22\u8fd4\u56de\u4eba\u5458\u4fe1\u606fdata\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        FscUnifySettleDecryptionReqBO decryptionAbilityReqBO = new FscUnifySettleDecryptionReqBO();
        decryptionAbilityReqBO.setData(data);
        FscUnifySettleDecryptionRspBO decryptionAbilityRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealParamDecryption(decryptionAbilityReqBO);
        if (StringUtils.isEmpty((Object)decryptionAbilityRspBO.getData())) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u65b0\u4e1a\u8d22\u89e3\u5bc6\u63a5\u53e3\u5931\u8d25\uff1a" + decryptionAbilityRspBO.getRespDesc());
        }
        JSONObject result = JSONObject.parseObject((String)decryptionAbilityRspBO.getData());
        log.debug("\u4e1a\u8d22\u4eba\u5458\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\u89e3\u5bc6\uff1a{}" + decryptionAbilityRspBO.getData());
        FscBillGetYcPersonInfoRspBO fscBillGetYcPersonInfoRspBO = new FscBillGetYcPersonInfoRspBO();
        fscBillGetYcPersonInfoRspBO.setRespCode("0000");
        if (!ObjectUtils.isEmpty((Object)result.getString("flag"))) {
            fscBillGetYcPersonInfoRspBO.setFlag(result.getString("flag"));
        }
        if (!ObjectUtils.isEmpty((Object)result.getString("msg"))) {
            fscBillGetYcPersonInfoRspBO.setMsg(result.getString("msg"));
        }
        if (result.isEmpty()) {
            return fscBillGetYcPersonInfoRspBO;
        }
        if (ObjectUtils.isEmpty((Object)result.get((Object)"outJsonMap"))) {
            return fscBillGetYcPersonInfoRspBO;
        }
        fscBillGetYcPersonInfoRspBO = (FscBillGetYcPersonInfoRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)result.get((Object)"outJsonMap")), FscBillGetYcPersonInfoRspBO.class));
        fscBillGetYcPersonInfoRspBO.setRespCode("0000");
        return fscBillGetYcPersonInfoRspBO;
    }

    private void valid(FscBillGetYcPersonInfoReqBO reqBo) {
        if (null == reqBo.getORG_ID()) {
            throw new FscBusinessException("194317", "\u83b7\u53d6\u4e1a\u8d22\u4eba\u5458\u4fe1\u606f\u5165\u53c2\u3010ORG_ID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getAgentAccount())) {
            throw new FscBusinessException("194317", "\u83b7\u53d6\u4e1a\u8d22\u4eba\u5458\u4fe1\u606f\u5165\u53c2\u3010agentAccount\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

