/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.esb;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.external.api.bo.FscNoticeEcomCancelInvoiceReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscNoticeEcomCancelInvoiceRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscNoticeEcomCancelInvoiceService;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.EsbParamUtil;
import com.tydic.fsc.utils.SSLClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class FscNoticeEcomCancelInvoiceServiceImpl
implements FscNoticeEcomCancelInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(FscNoticeEcomCancelInvoiceServiceImpl.class);
    @Autowired
    private Environment environment;
    @Value(value="${esb.cancelInvoice.url:}")
    private String ESB_INVOICE_CANCEL_URL;

    @Override
    public FscNoticeEcomCancelInvoiceRspBO cancelInvoice(FscNoticeEcomCancelInvoiceReqBO reqBO) {
        this.valid(reqBO);
        String hsn = this.environment.getProperty("SUPPLIER_ID_" + reqBO.getSupplierId());
        String reqString = JSON.toJSONString((Object)((Object)reqBO));
        String reqEsbJson = EsbParamUtil.getEsbReqStr(reqString, hsn, "BUSINESS_PAY");
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42ESB\u7535\u5546\u53d6\u6d88\u5f00\u7968\u5165\u53c2:{},URL:{}", (Object)reqEsbJson, (Object)this.ESB_INVOICE_CANCEL_URL);
        }
        String rspJson = SSLClient.doPost(this.ESB_INVOICE_CANCEL_URL, reqEsbJson);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42ESB\u7535\u5546\u53d6\u6d88\u5f00\u7968\u51fa\u53c2:{}", (Object)rspJson);
        }
        if (StringUtils.isBlank((CharSequence)rspJson)) {
            throw new FscBusinessException("194320", "\u8bf7\u6c42ESB\u7535\u5546\u53d6\u6d88\u5f00\u7968\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff01");
        }
        FscNoticeEcomCancelInvoiceRspBO rspBO = (FscNoticeEcomCancelInvoiceRspBO)((Object)JSON.parseObject((String)rspJson, FscNoticeEcomCancelInvoiceRspBO.class));
        if (!rspBO.getSuccess().booleanValue()) {
            throw new FscBusinessException("194320", rspBO.getResultMessage());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public void valid(FscNoticeEcomCancelInvoiceReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("\u901a\u77e5\u7535\u5546\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)reqBO)));
        }
        if (reqBO.getMarkId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u7533\u8bf7\u5355id[markId]\u4e3a\u7a7a");
        }
        if (reqBO.getSupplierId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4f9b\u5e94\u5546id[supplierId]\u4e3a\u7a7a");
        }
    }
}

