/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.esb;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.external.api.bo.FscDraftReleaseOccReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscDraftReleaseOccRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleDecryptionReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleDecryptionRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleEncryPtionReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleEncryPtionRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscDraftReleaseOccService;
import com.tydic.fsc.busibase.external.api.esb.FscUnifySettleRelatedInterfacesAtomService;
import com.tydic.fsc.constants.FscDraftTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.utils.SSLClient;
import com.tydic.uoc.common.ability.api.PebExtUnifySettlePersonQryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtUnifySettleTokenQryAbilityRspBO;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscDraftReleaseOccServiceImpl
implements FscDraftReleaseOccService {
    private static final Logger log = LoggerFactory.getLogger(FscDraftReleaseOccServiceImpl.class);
    @Value(value="${esb.draft.release.url:http://172.16.11.136:30000/eip-zcht/service/updateBill}")
    private String draftReleaseOccUrl;
    @Autowired
    private FscUnifySettleRelatedInterfacesAtomService fscUnifySettleRelatedInterfacesAtomService;
    @Autowired
    private PebExtUnifySettlePersonQryAbilityService pebExtUnifySettlePersonQryAbilityService;

    @Override
    public FscDraftReleaseOccRspBO draftReleaseOcc(FscDraftReleaseOccReqBO reqBO) {
        PebExtUnifySettleTokenQryAbilityReqBO tokenQryAbilityReqBO = new PebExtUnifySettleTokenQryAbilityReqBO();
        tokenQryAbilityReqBO.setUserId(reqBO.getAgentAccount());
        PebExtUnifySettleTokenQryAbilityRspBO tokenQryAbilityRspBO = this.pebExtUnifySettlePersonQryAbilityService.qryUnifyPersonToken(tokenQryAbilityReqBO);
        if (!tokenQryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(tokenQryAbilityRspBO.getRespCode(), "\u83b7\u53d6\u65b0\u4e1a\u8d22token\u5931\u8d25\uff1a" + tokenQryAbilityRspBO.getRespDesc());
        }
        String reqData = this.initParam(reqBO);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", tokenQryAbilityRspBO.getData());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("cipherCode", reqData);
        log.info("\u4e1a\u8d22\u5360\u7528/\u91ca\u653e\u6c47\u7968\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a{}", paramMap);
        String returnString = SSLClient.doPost(this.draftReleaseOccUrl, paramMap, headerMap);
        log.info("\u4e1a\u8d22\u5360\u7528/\u91ca\u653e\u6c47\u7968\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)returnString);
        if (StringUtils.isEmpty((Object)returnString)) {
            throw new FscBusinessException("194317", "\u4e1a\u8d22\u5360\u7528/\u91ca\u653e\u6c47\u7968\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        String result = jsonObject.getString("data");
        FscUnifySettleDecryptionReqBO decryptionReqBO = new FscUnifySettleDecryptionReqBO();
        decryptionReqBO.setData(result);
        FscUnifySettleDecryptionRspBO decryptionRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealParamDecryption(decryptionReqBO);
        if (!decryptionRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u65b0\u4e1a\u8d22\u89e3\u5bc6\u63a5\u53e3\u5931\u8d25\uff1a" + decryptionRspBO.getRespDesc());
        }
        log.debug("\u4e1a\u8d22\u5360\u7528/\u91ca\u653e\u6c47\u7968\u63a5\u53e3\u54cd\u5e94\u89e3\u5bc6\u62a5\u6587\uff1a{}" + decryptionRspBO.getData());
        JSONObject object = JSONObject.parseObject((String)decryptionRspBO.getData());
        if (!"Y".equals(object.getString("FLAG"))) {
            throw new FscBusinessException("194317", "\u4e1a\u8d22\u5360\u7528/\u91ca\u653e\u6c47\u7968\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u54cd\u5e94\u62a5\u6587\u5f02\u5e38:" + object.getString("MSG"));
        }
        FscDraftReleaseOccRspBO rspBO = new FscDraftReleaseOccRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private String initParam(FscDraftReleaseOccReqBO reqBO) {
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("HEADER_ID", (Object)String.join((CharSequence)",", reqBO.getDraftList()));
        FscDraftTypeEnum instance = FscDraftTypeEnum.getInstance((String)reqBO.getType());
        jsonObject.put("BILL_STATUS", (Object)instance.getCodeDesc());
        jsonObject.put("BILL_STATUS_DIS", (Object)instance.getGroupName());
        jsonObject.put("ZY_BILL_NUM", (Object)reqBO.getBillNum());
        jsonObject.put("LAST_UPDATE_DATE", (Object)DateUtil.dateToStr((Date)new Date()));
        jsonArray.add((Object)jsonObject);
        log.info("\u4e1a\u8d22\u5360\u7528/\u91ca\u653e\u6c47\u7968\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a{}, \u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)jsonArray.toJSONString(), (Object)this.draftReleaseOccUrl);
        FscUnifySettleEncryPtionReqBO encryptionReqBO = new FscUnifySettleEncryPtionReqBO();
        encryptionReqBO.setData(jsonArray.toJSONString());
        FscUnifySettleEncryPtionRspBO encryptionRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealArrayEncryption(encryptionReqBO);
        if (!encryptionRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(encryptionRspBO.getRespCode(), "\u8c03\u7528\u65b0\u4e1a\u8d22\u52a0\u5bc6\u63a5\u53e3\u5931\u8d25\uff1a" + encryptionRspBO.getRespDesc());
        }
        return encryptionRspBO.getData();
    }
}

