/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.esb.finance;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceShareTokenRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.SSLClient;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinanceShareRelatedInterfacesAtomServiceImpl
implements FscFinanceShareRelatedInterfacesAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceShareRelatedInterfacesAtomServiceImpl.class);
    @Value(value="${finance.token.version:2019-10-08}")
    private String VERSION;
    @Value(value="${finance.token.clientId:d7de806da88e463fb195fdea4a1c119a}")
    private String CLIENT_ID;
    @Value(value="${finance.token.clientSecret:62f85fe7cea34bebb8e59e7f4103acdb}")
    private String CLIENT_SECRET;
    @Value(value="${finance.token.action:GenToken}")
    private String ACTION;
    @Value(value="${finance.token.url:http://172.16.192.224/oauth2}")
    private String FINANCE_TOKEN_URL;
    private static final String FINANCE_TOKEN_KEY = "fsc:finance_share_token";
    @Autowired
    private CacheClient cacheService;

    @Override
    public FscFinanceShareTokenRspBO getFinanceShareToken() {
        FscFinanceShareTokenRspBO rspBO = new FscFinanceShareTokenRspBO();
        try {
            Object object = this.cacheService.get(FINANCE_TOKEN_KEY);
            if (object != null) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                rspBO.setToken(object.toString());
                return rspBO;
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u7f13\u5b58\u83b7\u53d6\u5171\u4eabtoken\u5f02\u5e38:" + e);
            throw new FscBusinessException("190000", "\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf\u83b7\u53d6token\u63a5\u53e3\u5f02\u5e38!");
        }
        this.getToken(rspBO);
        if (Objects.isNull(rspBO.getToken()) || Objects.isNull(rspBO.getExpireTime())) {
            throw new FscBusinessException("190000", "\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf\u83b7\u53d6token\u63a5\u53e3\u5f02\u5e38!");
        }
        try {
            long expireTime = (Long.parseLong(rspBO.getExpireTime()) - System.currentTimeMillis() - 500L) / 1000L;
            this.cacheService.set(FINANCE_TOKEN_KEY, (Object)rspBO.getToken(), (int)expireTime);
        }
        catch (Exception e) {
            log.error("\u5c06\u5171\u4eabtoken\u5199\u5165\u7f13\u5b58\u65f6\u53d1\u751f\u5f02\u5e38:" + e);
            throw new FscBusinessException("190000", "\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf\u83b7\u53d6token\u63a5\u53e3\u5f02\u5e38!");
        }
        return rspBO;
    }

    private void getToken(FscFinanceShareTokenRspBO rspBO) {
        try {
            StringBuilder buffer = new StringBuilder(this.FINANCE_TOKEN_URL);
            buffer.append("?Version=").append(this.VERSION);
            buffer.append("&ClientId=").append(this.CLIENT_ID);
            buffer.append("&ClientSecret=").append(this.CLIENT_SECRET);
            buffer.append("&Action=").append(this.ACTION);
            log.info("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf\u83b7\u53d6token\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)buffer.toString());
            Map<String, String> headerMap = SSLClient.doGetHeader(buffer.toString());
            log.debug("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf\u83b7\u53d6token\u63a5\u53e3\u4e0b\u53d1\u62a5\u6587\uff1a{}", (Object)JSONObject.toJSONString(headerMap));
            if (CollectionUtils.isEmpty(headerMap)) {
                throw new FscBusinessException("198888", "\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf\u83b7\u53d6token\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u4e3a\u7a7a\uff01");
            }
            rspBO.setToken(headerMap.get("x-oauth2-token"));
            rspBO.setExpireTime(headerMap.get("x-oauth2-expire-time"));
            log.info("\u5171\u4eabtoken\u8fc7\u671f\u65f6\u95f4: " + rspBO.getExpireTime() + "; \u5f53\u524d\u65f6\u95f4\u6233\uff1a" + System.currentTimeMillis());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8d22\u52a1\u5171\u4eab\u7cfb\u7edftoken\u5f02\u5e38\uff1a{}", (Throwable)e);
            throw new FscBusinessException("190000", "\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf\u83b7\u53d6token\u63a5\u53e3\u5f02\u5e38:" + e.getMessage());
        }
    }
}

