/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.utils;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class UploadUtil {
    private static final Logger log = LoggerFactory.getLogger(UploadUtil.class);
    @Autowired
    private FileClient fileClient;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    private static final String PATH = "uoc";
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    @Value(value="${fastdfs.downloadUrl}")
    private String fastDownloadUrl;

    public String upload(String path) {
        String exportUrl;
        String fileName = UUID.randomUUID().toString() + path.substring(path.lastIndexOf("."));
        FileInputStream fileInput = null;
        try {
            fileInput = new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        String url = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)fileInput);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + url;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)url);
            exportUrl = this.fastDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        this.deleteFile(path);
        return exportUrl;
    }

    public void deleteFile(String fileName) {
        File directory = new File(".");
        String system = System.getProperties().getProperty("os.name");
        try {
            File file = new File(fileName);
            if (!file.delete()) {
                log.error("\u6587\u4ef6\u5220\u9664\u5931\u8d25" + fileName);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }
}

