/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.base.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.beans.BeanUtils;

public class ConvertUtils {
    public static <S, T> T convertTo(S source, Supplier<T> targetSupplier) {
        return ConvertUtils.convertTo(source, targetSupplier, null);
    }

    public static <S, T> T convertTo(S source, Supplier<T> targetSupplier, ConvertCallBack<S, T> callBack) {
        if (null == source || null == targetSupplier) {
            return null;
        }
        T target = targetSupplier.get();
        BeanUtils.copyProperties(source, target);
        if (callBack != null) {
            callBack.callBack(source, target);
        }
        return target;
    }

    public static <S, T> List<T> convertListTo(List<S> sources, Supplier<T> targetSupplier) {
        return ConvertUtils.convertListTo(sources, targetSupplier, null);
    }

    public static <S, T> List<T> convertListTo(List<S> sources, Supplier<T> targetSupplier, ConvertCallBack<S, T> callBack) {
        if (null == sources || null == targetSupplier) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(sources.size());
        for (S source : sources) {
            T target = targetSupplier.get();
            BeanUtils.copyProperties(source, target);
            if (callBack != null) {
                callBack.callBack(source, target);
            }
            list.add(target);
        }
        return list;
    }

    @FunctionalInterface
    public static interface ConvertCallBack<S, T> {
        public void callBack(S var1, T var2);
    }
}

